/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.cache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FilenameFilter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TargetCacheImpl_Utils {
    public static final String UTF_8_ENCODING_NAME = "UTF-8";
    public static final PrefixWidget APP_PREFIX_WIDGET;
    public static final PrefixWidget MOD_PREFIX_WIDGET;
    public static final PrefixWidget CON_PREFIX_WIDGET;
    static final long serialVersionUID = -7041537848382419377L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public static final String encodePath(String path) {
        if (path == null) {
            return null;
        }
        try {
            return URLEncoder.encode(path, UTF_8_ENCODING_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Utils", (String)"42", null, (Object[])new Object[]{path});
            throw new IllegalArgumentException("Unable to use UTF-8 encoding [ UTF-8 ]", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final String decodePath(String e_path) {
        if (e_path == null) {
            return null;
        }
        try {
            return URLDecoder.decode(e_path, UTF_8_ENCODING_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Utils", (String)"55", null, (Object[])new Object[]{e_path});
            throw new IllegalArgumentException("Unable to use UTF-8 encoding [ UTF-8 ]", (Throwable)e);
        }
    }

    public static FilenameFilter createPrefixFilter(final String prefix) {
        return new FilenameFilter(){
            static final long serialVersionUID = 1021120621740584294L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Utils$1", 1.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        };
    }

    public static FilenameFilter createPrefixFilter(PrefixWidget prefixWidget) {
        final String prefix = prefixWidget.getPrefix();
        return new FilenameFilter(){
            static final long serialVersionUID = 7184636538206790844L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Utils$2", 2.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        };
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Utils", TargetCacheImpl_Utils.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        APP_PREFIX_WIDGET = new PrefixWidget("A_", "_A");
        MOD_PREFIX_WIDGET = new PrefixWidget("M_", "_M");
        CON_PREFIX_WIDGET = new PrefixWidget("C_", "_C");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static abstract class PrefixListWidget
    implements ListWidget {
        protected final PrefixWidget prefixWidget;
        protected final FilenameFilter filter;
        static final long serialVersionUID = -5454559655639767718L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public PrefixListWidget(PrefixWidget prefixWidget) {
            this.prefixWidget = prefixWidget;
            this.filter = TargetCacheImpl_Utils.createPrefixFilter(prefixWidget);
        }

        public PrefixWidget getPrefixWidget() {
            return this.prefixWidget;
        }

        @Override
        public String e_addPrefix(String e_name) {
            if (e_name == null) {
                return null;
            }
            return this.getPrefixWidget().e_addPrefix(e_name);
        }

        @Override
        public String e_removePrefix(String e_name) {
            if (e_name == null) {
                return null;
            }
            return this.getPrefixWidget().e_removePrefix(e_name);
        }

        @Override
        public FilenameFilter getFilter() {
            return this.filter;
        }

        @Override
        public void storeParent(File parentDir) {
            File[] childFiles;
            for (File childFile : childFiles = UtilImpl_FileUtils.listFiles(parentDir, this.getFilter())) {
                this.storeChild(new File(parentDir, childFile.getName()));
            }
        }

        @Override
        public void storeChild(File childFile) {
            String e_childFileName = childFile.getName();
            String e_childName = this.e_removePrefix(e_childFileName);
            String childName = TargetCacheImpl_Utils.decodePath(e_childName);
            this.storeChild(childName, e_childName, childFile);
        }

        public abstract void storeChild(String var1, String var2, File var3);

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Utils$PrefixListWidget", PrefixListWidget.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class PrefixWidget {
        private final String prefix;
        private final String e_prefix;
        private final int e_prefixLength;
        private final String suffix;
        private final String e_suffix;
        private final int e_suffixLength;
        private final int e_addedLength;
        static final long serialVersionUID = -8774458077024529595L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public PrefixWidget(String prefix, String suffix) {
            this.prefix = prefix;
            this.e_prefix = TargetCacheImpl_Utils.encodePath(prefix);
            this.e_prefixLength = this.e_prefix.length();
            this.suffix = suffix;
            this.e_suffix = TargetCacheImpl_Utils.encodePath(suffix);
            this.e_suffixLength = this.e_suffix.length();
            this.e_addedLength = this.e_prefixLength + this.e_suffixLength;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String e_getPrefix() {
            return this.e_prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String e_getSuffix() {
            return this.e_suffix;
        }

        public String e_removePrefix(String e_name) {
            if (e_name == null) {
                return null;
            }
            return e_name.substring(this.e_prefixLength, e_name.length() - this.e_addedLength);
        }

        public String e_addPrefix(String e_name) {
            if (e_name == null) {
                return null;
            }
            return this.e_getPrefix() + e_name + this.e_getSuffix();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Utils$PrefixWidget", PrefixWidget.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    public static interface ListWidget {
        public String e_removePrefix(String var1);

        public String e_addPrefix(String var1);

        public FilenameFilter getFilter();

        public void storeParent(File var1);

        public void storeChild(File var1);
    }
}

