/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.sso.common.saml.propagation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.saml2.Saml20Token;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SamlCommonUtil {
    protected static final TraceComponent tc = Tr.register(SamlCommonUtil.class, (String)"SAML_PROPAGATION", (String)"com.ibm.ws.security.sso.common.internal.resources.SAMLPropagationMessages");
    static final long serialVersionUID = -1703767082665223092L;

    /*
     * WARNING - void declaration
     */
    public static Saml20Token getSaml20TokenFromSubject(final Subject subject) {
        Saml20Token saml20Token = null;
        try {
            saml20Token = (Saml20Token)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                static final long serialVersionUID = 554075916982178494L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Object run() throws Exception {
                    Iterator<Saml20Token> authIterator = subject.getPrivateCredentials(Saml20Token.class).iterator();
                    if (authIterator.hasNext()) {
                        Saml20Token token = authIterator.next();
                        return token;
                    }
                    Tr.warning((TraceComponent)tc, (String)"no_saml_found_in_subject", (Object[])new Object[0]);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.sso.common.saml.propagation.SamlCommonUtil$1", 1.class, (String)"SAML_PROPAGATION", (String)"com.ibm.ws.security.sso.common.internal.resources.SAMLPropagationMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.sso.common.saml.propagation.SamlCommonUtil", (String)"52", null, (Object[])new Object[]{subject});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception while getting SAML token from subject:", (Object[])new Object[]{e.getCause()});
            }
            Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_token_from_subject", (Object[])new Object[]{e.getLocalizedMessage()});
        }
        return saml20Token;
    }

    /*
     * WARNING - void declaration
     */
    public static Saml20Token getSaml20TokenFromSubject(Subject subject, boolean isPrivileged) {
        if (isPrivileged) {
            return SamlCommonUtil.getSaml20TokenFromSubject(subject);
        }
        Saml20Token saml20Token = null;
        try {
            Iterator<Saml20Token> authIterator = subject.getPrivateCredentials(Saml20Token.class).iterator();
            if (authIterator.hasNext()) {
                saml20Token = authIterator.next();
            }
        }
        catch (Exception authIterator) {
            void e;
            FFDCFilter.processException((Throwable)authIterator, (String)"com.ibm.ws.security.sso.common.saml.propagation.SamlCommonUtil", (String)"78", null, (Object[])new Object[]{subject, isPrivileged});
            Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_token_from_subject", (Object[])new Object[]{e.getLocalizedMessage()});
        }
        if (saml20Token == null) {
            Tr.warning((TraceComponent)tc, (String)"no_saml_found_in_subject", (Object[])new Object[0]);
        }
        return saml20Token;
    }
}

