/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.data;

import com.ibm.ws.logging.data.AccessLogDataFormatter;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.NameAliases;
import java.util.HashMap;
import java.util.Map;

public class AccessLogData
extends GenericData {
    public static final String[] NAMES_JSON = new String[]{"ibm_requestStartTime", "ibm_uriPath", "ibm_requestMethod", "ibm_queryString", "ibm_requestHost", "ibm_requestPort", "ibm_remoteHost", "ibm_userAgent", "ibm_requestProtocol", "ibm_bytesReceived", "ibm_responseCode", "ibm_elapsedTime", "ibm_datetime", "ibm_sequence", "host", "ibm_userDir", "ibm_serverName", "type", "ibm_remoteIP", "ibm_bytesSent", "ibm_cookie", "ibm_requestElapsedTime", "ibm_requestHeader", "ibm_responseHeader", "ibm_requestFirstLine", "ibm_accessLogDatetime", "ibm_remoteUserID"};
    private static final String[] NAMES_LC = new String[]{"requestStartTime", "uriPath", "requestMethod", "queryString", "requestHost", "requestPort", "remoteHost", "userAgent", "requestProtocol", "bytesReceived", "responseCode", "elapsedTime", "datetime", "sequence", "hostName", "wlpUserDir", "serverName", "type", "remoteIP", "bytesSent", "cookie", "requestElapsedTime", "requestHeader", "responseHeader", "requestFirstLine", "accessLogDatetime", "remoteUserID"};
    private static final short JSON_KEY = 0;
    private static Map<String, String> cookieMap = new HashMap<String, String>();
    private static Map<String, String> requestHeaderMap = new HashMap<String, String>();
    private static Map<String, String> responseHeaderMap = new HashMap<String, String>();
    private static NameAliases jsonLoggingNameAliases = new NameAliases(NAMES_JSON);
    private static NameAliases jsonLoggingNameAliasesLogstash = new NameAliases(NAMES_LC);
    private static NameAliases[] nameAliases = new NameAliases[]{jsonLoggingNameAliases, jsonLoggingNameAliasesLogstash};
    public AccessLogDataFormatter[] formatters = new AccessLogDataFormatter[4];
    KeyValuePairList kvplCookies = new KeyValuePairList("cookies");
    KeyValuePairList kvplRequestHeaders = new KeyValuePairList("requestHeaders");
    KeyValuePairList kvplResponseHeaders = new KeyValuePairList("responseHeaders");

    public static void populateDataMaps(Map<String, String> cookies, Map<String, String> requestHeaders, Map<String, String> responseHeaders) {
        cookieMap = cookies;
        requestHeaderMap = requestHeaders;
        responseHeaderMap = responseHeaders;
    }

    public void addFormatters(AccessLogDataFormatter[] formatters) {
        this.formatters = formatters;
    }

    public AccessLogDataFormatter[] getFormatters() {
        return this.formatters;
    }

    public static void newJsonLoggingNameAliases(Map<String, String> newAliases) {
        jsonLoggingNameAliases.newAliases(newAliases);
    }

    public static void resetJsonLoggingNameAliases() {
        jsonLoggingNameAliases.resetAliases();
        cookieMap = new HashMap<String, String>();
        requestHeaderMap = new HashMap<String, String>();
        responseHeaderMap = new HashMap<String, String>();
    }

    public AccessLogData() {
        super(24);
    }

    private void setPair(int index, String s) {
        this.setPair(index, NAMES_JSON[index], s);
    }

    private void setPair(int index, int i) {
        this.setPair(index, NAMES_JSON[index], i);
    }

    private void setPair(int index, long l) {
        this.setPair(index, NAMES_JSON[index], l);
    }

    private KeyValuePairList getValues(int index) {
        return (KeyValuePairList)this.getPairs()[index];
    }

    public void setRequestStartTime(long l) {
        this.setPair(0, l);
    }

    public void setUriPath(String s) {
        this.setPair(1, s);
    }

    public void setRequestMethod(String s) {
        this.setPair(2, s);
    }

    public void setQueryString(String s) {
        this.setPair(3, s);
    }

    public void setRequestHost(String s) {
        this.setPair(4, s);
    }

    public void setRequestPort(String s) {
        this.setPair(5, s);
    }

    public void setRemoteHost(String s) {
        this.setPair(6, s);
    }

    public void setUserAgent(String s) {
        this.setPair(7, s);
    }

    public void setRequestProtocol(String s) {
        this.setPair(8, s);
    }

    public void setBytesReceived(long l) {
        this.setPair(9, l);
    }

    public void setResponseCode(int i) {
        this.setPair(10, i);
    }

    public void setElapsedTime(long l) {
        this.setPair(11, l);
    }

    public void setDatetime(long l) {
        this.setPair(12, l);
    }

    public void setSequence(String s) {
        this.setPair(13, s);
    }

    public void setRemoteIP(String s) {
        this.setPair(14, s);
    }

    public void setBytesSent(long l) {
        this.setPair(15, l);
    }

    public void setRequestElapsedTime(long l) {
        this.setPair(17, l);
    }

    public void setRequestFirstLine(String s) {
        this.setPair(20, s);
    }

    public void setAccessLogDatetime(long l) {
        this.setPair(21, l);
    }

    public void setRemoteUser(String s) {
        this.setPair(22, s);
    }

    public void setCookies(String name, String value) {
        this.kvplCookies.addKeyValuePair(name, value);
        this.setPair(16, this.kvplCookies);
    }

    public void setRequestHeader(String name, String value) {
        this.kvplRequestHeaders.addKeyValuePair(name, value);
        this.setPair(18, this.kvplRequestHeaders);
    }

    public void setResponseHeader(String name, String value) {
        this.kvplResponseHeaders.addKeyValuePair(name, value);
        this.setPair(19, this.kvplResponseHeaders);
    }

    public long getRequestStartTime() {
        return this.getLongValue(0);
    }

    public String getUriPath() {
        return this.getStringValue(1);
    }

    public String getRequestMethod() {
        return this.getStringValue(2);
    }

    public String getQueryString() {
        return this.getStringValue(3);
    }

    public String getRequestHost() {
        return this.getStringValue(4);
    }

    public String getRequestPort() {
        return this.getStringValue(5);
    }

    public String getRemoteHost() {
        return this.getStringValue(6);
    }

    public String getUserAgent() {
        return this.getStringValue(7);
    }

    public String getRequestProtocol() {
        return this.getStringValue(8);
    }

    public long getBytesReceived() {
        return this.getLongValue(9);
    }

    public int getResponseCode() {
        return this.getIntValue(10);
    }

    public long getElapsedTime() {
        return this.getLongValue(11);
    }

    public long getDatetime() {
        return this.getLongValue(12);
    }

    public String getSequence() {
        return this.getStringValue(13);
    }

    public String getRemoteIP() {
        return this.getStringValue(14);
    }

    public long getBytesSent() {
        return this.getLongValue(15);
    }

    public KeyValuePairList getCookies() {
        return this.getValues(16);
    }

    public long getRequestElapsedTime() {
        return this.getLongValue(17);
    }

    public KeyValuePairList getRequestHeaders() {
        return this.getValues(18);
    }

    public KeyValuePairList getResponseHeaders() {
        return this.getValues(19);
    }

    public String getRequestFirstLine() {
        return this.getStringValue(20);
    }

    public long getAccessLogDatetime() {
        return this.getLongValue(21);
    }

    public String getRemoteUser() {
        return this.getStringValue(22);
    }

    public static String getRequestStartTimeKey(int format) {
        return AccessLogData.nameAliases[format].aliases[0];
    }

    public static String getUriPathKey(int format) {
        return AccessLogData.nameAliases[format].aliases[1];
    }

    public static String getRequestMethodKey(int format) {
        return AccessLogData.nameAliases[format].aliases[2];
    }

    public static String getQueryStringKey(int format) {
        return AccessLogData.nameAliases[format].aliases[3];
    }

    public static String getRequestHostKey(int format) {
        return AccessLogData.nameAliases[format].aliases[4];
    }

    public static String getRequestPortKey(int format) {
        return AccessLogData.nameAliases[format].aliases[5];
    }

    public static String getRemoteHostKey(int format) {
        return AccessLogData.nameAliases[format].aliases[6];
    }

    public static String getUserAgentKey(int format) {
        return AccessLogData.nameAliases[format].aliases[7];
    }

    public static String getRequestProtocolKey(int format) {
        return AccessLogData.nameAliases[format].aliases[8];
    }

    public static String getBytesReceivedKey(int format) {
        return AccessLogData.nameAliases[format].aliases[9];
    }

    public static String getResponseCodeKey(int format) {
        return AccessLogData.nameAliases[format].aliases[10];
    }

    public static String getElapsedTimeKey(int format) {
        return AccessLogData.nameAliases[format].aliases[11];
    }

    public static String getDatetimeKey(int format) {
        return AccessLogData.nameAliases[format].aliases[12];
    }

    public static String getSequenceKey(int format) {
        return AccessLogData.nameAliases[format].aliases[13];
    }

    public static String getHostKey(int format) {
        return AccessLogData.nameAliases[format].aliases[14];
    }

    public static String getUserDirKey(int format) {
        return AccessLogData.nameAliases[format].aliases[15];
    }

    public static String getServerNameKey(int format) {
        return AccessLogData.nameAliases[format].aliases[16];
    }

    public static String getTypeKey(int format) {
        return AccessLogData.nameAliases[format].aliases[17];
    }

    public static String getRemoteIPKey(int format) {
        return AccessLogData.nameAliases[format].aliases[18];
    }

    public static String getBytesSentKey(int format) {
        return AccessLogData.nameAliases[format].aliases[19];
    }

    public static String getRequestElapsedTimeKey(int format) {
        return AccessLogData.nameAliases[format].aliases[21];
    }

    public static String getRequestFirstLineKey(int format) {
        return AccessLogData.nameAliases[format].aliases[24];
    }

    public static String getAccessLogDatetimeKey(int format) {
        return AccessLogData.nameAliases[format].aliases[25];
    }

    public static String getRemoteUserKey(int format) {
        return AccessLogData.nameAliases[format].aliases[26];
    }

    public static String getCookieKey(int format, KeyValuePair kvp) {
        String cookieName = kvp.getKey();
        if (cookieMap.containsKey(cookieName) && format == 0) {
            return cookieMap.get(cookieName);
        }
        return AccessLogData.nameAliases[format].aliases[20] + "_" + cookieName;
    }

    public static String getRequestHeaderKey(int format, KeyValuePair kvp) {
        String requestHeader = kvp.getKey();
        if (requestHeaderMap.containsKey(requestHeader) && format == 0) {
            return requestHeaderMap.get(requestHeader);
        }
        return AccessLogData.nameAliases[format].aliases[22] + "_" + requestHeader;
    }

    public static String getResponseHeaderKey(int format, KeyValuePair kvp) {
        String responseHeader = kvp.getKey();
        if (responseHeaderMap.containsKey(responseHeader) && format == 0) {
            return responseHeaderMap.get(responseHeader);
        }
        return AccessLogData.nameAliases[format].aliases[23] + "_" + responseHeader;
    }
}

