/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import org.apache.yoko.orb.OB.CorbalocURLScheme;
import org.apache.yoko.orb.OB.CorbalocURLSchemeHelper;
import org.apache.yoko.orb.OB.CorbalocURLSchemePackage.ProtocolAlreadyExists;
import org.apache.yoko.orb.OB.URLRegistryHelper;
import org.apache.yoko.orb.OB.URLScheme;
import org.apache.yoko.orb.OCI.AccFactoryRegistry;
import org.apache.yoko.orb.OCI.AccFactoryRegistryHelper;
import org.apache.yoko.orb.OCI.ConFactoryRegistryHelper;
import org.apache.yoko.orb.OCI.FactoryAlreadyExists;
import org.apache.yoko.orb.OCI.IIOP.AccFactory_impl;
import org.apache.yoko.orb.OCI.IIOP.ConFactory_impl;
import org.apache.yoko.orb.OCI.IIOP.ConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.CorbalocProtocol_impl;
import org.apache.yoko.orb.OCI.IIOP.ExtendedConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.ListenerMap;
import org.apache.yoko.orb.OCI.Plugin;
import org.apache.yoko.util.Assert;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;

public final class Plugin_impl
extends LocalObject
implements Plugin {
    private ORB orb_;
    private ListenerMap listenMap_;
    private final ConnectionHelper connectionHelper_;
    private final ExtendedConnectionHelper extendedConnectionHelper_;

    @Override
    public String id() {
        return "iiop";
    }

    @Override
    public int tag() {
        return 0;
    }

    @Override
    public void init_client(String[] params) {
        Object registry;
        boolean keepAlive = true;
        for (int i = 0; i < params.length; ++i) {
            if (params[i].equals("--no-keepalive")) {
                keepAlive = false;
                continue;
            }
            throw new INITIALIZE("iiop: unknown client parameter `" + params[i] + "'");
        }
        try {
            registry = ConFactoryRegistryHelper.narrow(this.orb_.resolve_initial_references("OCIConFactoryRegistry"));
            if (this.connectionHelper_ != null) {
                registry.add_factory(new ConFactory_impl(this.orb_, keepAlive, this.listenMap_, this.connectionHelper_));
            } else {
                registry.add_factory(new ConFactory_impl(this.orb_, keepAlive, this.listenMap_, this.extendedConnectionHelper_));
            }
        }
        catch (InvalidName ex) {
            throw Assert.fail((Throwable)ex);
        }
        catch (FactoryAlreadyExists ex) {
            throw new INITIALIZE("OCI IIOP plug-in already installed");
        }
        try {
            registry = URLRegistryHelper.narrow(this.orb_.resolve_initial_references("URLRegistry"));
            URLScheme scheme = registry.find_scheme("corbaloc");
            Assert.ensure((scheme != null ? 1 : 0) != 0);
            CorbalocURLScheme corbaloc = CorbalocURLSchemeHelper.narrow(scheme);
            corbaloc.add_protocol(new CorbalocProtocol_impl());
        }
        catch (InvalidName ex) {
            throw Assert.fail((Throwable)ex);
        }
        catch (ProtocolAlreadyExists ex) {
            throw Assert.fail((Throwable)((Object)ex));
        }
    }

    @Override
    public void init_server(String[] params) {
        try {
            AccFactoryRegistry registry = AccFactoryRegistryHelper.narrow(this.orb_.resolve_initial_references("OCIAccFactoryRegistry"));
            registry.add_factory(new AccFactory_impl(this.orb_, this.listenMap_, this.connectionHelper_, this.extendedConnectionHelper_));
        }
        catch (InvalidName ex) {
            throw Assert.fail((Throwable)ex);
        }
        catch (FactoryAlreadyExists ex) {
            throw new INITIALIZE("OCI IIOP plug-in already installed");
        }
    }

    public Plugin_impl(ORB orb, ConnectionHelper helper) {
        this.orb_ = orb;
        this.connectionHelper_ = helper;
        this.extendedConnectionHelper_ = null;
        this.listenMap_ = new ListenerMap();
    }

    public Plugin_impl(ORB orb, ExtendedConnectionHelper helper) {
        this.orb_ = orb;
        this.connectionHelper_ = null;
        this.extendedConnectionHelper_ = helper;
        this.listenMap_ = new ListenerMap();
    }
}

