/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Vector;
import org.apache.yoko.orb.OB.DispatchRequest;
import org.apache.yoko.util.Assert;
import org.omg.CORBA.OBJ_ADAPTER;

final class ThreadPool {
    private boolean destroy_ = false;
    private Vector requests_ = new Vector();
    private ThreadGroup group_;

    public ThreadPool(int id, int n) {
        this.group_ = new ThreadGroup("ThreadPool-" + id);
        for (int i = 0; i < n; ++i) {
            Dispatcher t = new Dispatcher(this.group_, this, id, i);
            t.start();
        }
    }

    protected void finalize() throws Throwable {
        if (!this.destroy_) {
            throw new InternalError();
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        Object object = this;
        synchronized (object) {
            if (this.destroy_) {
                return;
            }
            this.destroy_ = true;
            this.notifyAll();
        }
        object = this.group_;
        synchronized (object) {
            while (this.group_.activeCount() > 0) {
                try {
                    this.group_.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                this.group_.destroy();
            }
            catch (IllegalThreadStateException ex) {
                throw Assert.fail((Throwable)ex);
            }
        }
    }

    synchronized void add(DispatchRequest request) {
        if (this.destroy_) {
            throw new OBJ_ADAPTER("Thread pool is destroyed");
        }
        this.requests_.addElement(request);
        this.notify();
    }

    private synchronized DispatchRequest get() {
        while (!this.destroy_ && this.requests_.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        DispatchRequest result = null;
        if (!this.destroy_) {
            result = (DispatchRequest)this.requests_.firstElement();
            this.requests_.removeElementAt(0);
        }
        return result;
    }

    private class Dispatcher
    extends Thread {
        private ThreadPool threadPool_;

        Dispatcher(ThreadGroup group, ThreadPool threadPool2, int id, int n) {
            super(group, "Yoko:ThreadPool-" + id + ":Dispatcher-" + n);
            this.threadPool_ = threadPool2;
        }

        @Override
        public void run() {
            DispatchRequest req;
            while ((req = this.threadPool_.get()) != null) {
                req.invoke();
            }
            return;
        }
    }
}

