/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.CORBA;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.yoko.orb.CORBA.Any;
import org.apache.yoko.orb.OB.Util;
import org.apache.yoko.util.Assert;
import org.apache.yoko.util.MinorCodes;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;

public final class TypeCode
extends org.omg.CORBA.TypeCode {
    public TCKind kind_;
    public String id_;
    public String name_;
    public String[] memberNames_;
    public TypeCode[] memberTypes_;
    public Any[] labels_;
    public TypeCode discriminatorType_;
    public int length_;
    public TypeCode contentType_;
    public short fixedDigits_;
    public short fixedScale_;
    public short[] memberVisibility_;
    public short typeModifier_;
    public TypeCode concreteBaseType_;
    public String recId_;
    TypeCode recType_;

    public String toString() {
        return this.describe(new StringBuilder(), "").toString();
    }

    private StringBuilder describe(StringBuilder sb, String prefix) {
        String indent = prefix + "\t";
        sb.append("TypeCode{\n");
        if (this.kind_ != null) {
            sb.append(indent).append("kind: ").append(this.kind_).append("\n");
        }
        if (this.id_ != null) {
            sb.append(indent).append("id: ").append(this.id_).append("\n");
        }
        if (this.name_ != null) {
            sb.append(indent).append("name: ").append(this.name_).append("\n");
        }
        if (this.recId_ != null) {
            sb.append(indent).append("recursive id: ").append(this.recId_).append("\n");
        }
        if (this.typeModifier_ != 0) {
            sb.append(indent).append("type modifier: ").append(this.typeModifier_).append("\n");
        }
        if (this.length_ != 0) {
            sb.append(indent).append("length: ").append(this.length_).append("\n");
        }
        if (this.fixedDigits_ != 0) {
            sb.append(indent).append("fixed digits: ").append(this.fixedDigits_).append("\n");
        }
        if (this.fixedScale_ != 0) {
            sb.append(indent).append("fixed scale: ").append(this.fixedScale_).append("\n");
        }
        if (this.memberNames_ != null) {
            int visCount;
            int n = visCount = this.memberVisibility_ == null ? 0 : this.memberVisibility_.length;
            if (this.memberTypes_ == null) {
                sb.append(indent).append("members: ").append(Arrays.toString(this.memberNames_)).append("\n");
            } else {
                for (int i = 0; i < this.memberNames_.length; ++i) {
                    TypeCode tc = i < this.memberTypes_.length ? this.memberTypes_[i] : null;
                    sb.append(indent).append(this.memberNames_[i]);
                    if (i < visCount) {
                        sb.append(" (visibility = ").append(this.memberVisibility_[i]).append(")");
                    }
                    TypeCode.appendTC(sb, ": ", tc, indent).append("\n");
                }
            }
        }
        if (this.recType_ != null) {
            TypeCode.appendTC(sb, "recursive typecode: ", this.recType_, indent).append("\n");
        }
        if (this.discriminatorType_ != null) {
            TypeCode.appendTC(sb, "discriminator type: ", this.discriminatorType_, indent).append("\n");
        }
        if (this.contentType_ != null) {
            TypeCode.appendTC(sb, "content type: ", this.contentType_, indent).append("\n");
        }
        if (this.concreteBaseType_ != null) {
            TypeCode.appendTC(sb, "concrete base type: ", this.concreteBaseType_, indent).append("\n");
        }
        return sb.append(prefix).append("}");
    }

    private static StringBuilder appendTC(StringBuilder sb, String prefix, TypeCode tc, String indent) {
        sb.append(prefix);
        if (tc == null) {
            sb.append("typecode was null");
        } else {
            tc.describe(sb, indent);
        }
        return sb;
    }

    private boolean equivalentRecHelper(org.omg.CORBA.TypeCode t, Vector history, Vector otherHistory) {
        int i;
        if (t == null) {
            return false;
        }
        if (t == this) {
            return true;
        }
        boolean foundLoop = false;
        boolean foundOtherLoop = false;
        for (i = 0; i < history.size() && !foundLoop; ++i) {
            if (this != history.elementAt(i)) continue;
            foundLoop = true;
        }
        for (i = 0; i < otherHistory.size() && !foundOtherLoop; ++i) {
            if (t != otherHistory.elementAt(i)) continue;
            foundOtherLoop = true;
        }
        if (foundLoop && foundOtherLoop) {
            return true;
        }
        history.addElement(this);
        otherHistory.addElement(t);
        boolean result = this.equivalentRec(t, history, otherHistory);
        history.setSize(history.size() - 1);
        otherHistory.setSize(otherHistory.size() - 1);
        return result;
    }

    private boolean equivalentRec(org.omg.CORBA.TypeCode t, Vector history, Vector otherHistory) {
        int i;
        TypeCode tc = null;
        try {
            tc = (TypeCode)t;
        }
        catch (ClassCastException ex) {
            tc = TypeCode._OB_convertForeignTypeCode(t);
        }
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.equivalentRecHelper(t, history, otherHistory);
        }
        if (tc.recId_ != null) {
            if (tc.recType_ == null) {
                throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446349), 1330446349, CompletionStatus.COMPLETED_NO);
            }
            return this.equivalentRecHelper(tc.recType_, history, otherHistory);
        }
        TypeCode tc1 = this._OB_getOrigType();
        TypeCode tc2 = tc._OB_getOrigType();
        if (tc1.kind_ != tc2.kind_) {
            return false;
        }
        if (!(tc1.kind_ != TCKind.tk_objref && tc1.kind_ != TCKind.tk_struct && tc1.kind_ != TCKind.tk_union && tc1.kind_ != TCKind.tk_enum && tc1.kind_ != TCKind.tk_alias && tc1.kind_ != TCKind.tk_value && tc1.kind_ != TCKind.tk_value_box && tc1.kind_ != TCKind.tk_native && tc1.kind_ != TCKind.tk_abstract_interface && tc1.kind_ != TCKind.tk_except && tc1.kind_ != org.omg.CORBA_2_4.TCKind.tk_local_interface || tc1.id_.equals("") || tc2.id_.equals(""))) {
            return tc1.id_.equals(tc2.id_);
        }
        if (tc1.kind_ == TCKind.tk_struct || tc1.kind_ == TCKind.tk_union || tc1.kind_ == TCKind.tk_value || tc1.kind_ == TCKind.tk_except) {
            if (tc1.memberTypes_.length != tc2.memberTypes_.length) {
                return false;
            }
            for (i = 0; i < tc1.memberTypes_.length; ++i) {
                if (tc1.memberTypes_[i].equivalentRecHelper(tc2.memberTypes_[i], history, otherHistory)) continue;
                return false;
            }
        }
        if (tc1.kind_ == TCKind.tk_union) {
            if (tc1.labels_.length != tc2.labels_.length) {
                return false;
            }
            block7: for (i = 0; i < tc1.labels_.length; ++i) {
                org.omg.CORBA.TypeCode ltc2;
                org.omg.CORBA.TypeCode ltc1 = tc1.labels_[i]._OB_type();
                if (!ltc1.equivalent(ltc2 = tc2.labels_[i]._OB_type())) {
                    return false;
                }
                Object v1 = tc1.labels_[i].value();
                Object v2 = tc2.labels_[i].value();
                ltc1 = TypeCode._OB_getOrigType(ltc1);
                switch (ltc1.kind().value()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 9: 
                    case 17: 
                    case 23: 
                    case 24: {
                        if (v1.equals(v2)) continue block7;
                        return false;
                    }
                    case 10: {
                        continue block7;
                    }
                    default: {
                        throw Assert.fail((String)"unsupported type in tk_union");
                    }
                }
            }
            if (!tc1.discriminatorType_.equivalent(tc2.discriminatorType_)) {
                return false;
            }
        }
        if ((tc1.kind_ == TCKind.tk_string || tc1.kind_ == TCKind.tk_wstring || tc1.kind_ == TCKind.tk_sequence || tc1.kind_ == TCKind.tk_array) && tc1.length_ != tc2.length_) {
            return false;
        }
        if (!(tc1.kind_ != TCKind.tk_sequence && tc1.kind_ != TCKind.tk_array && tc1.kind_ != TCKind.tk_value_box && tc1.kind_ != TCKind.tk_alias || tc1.contentType_.equivalentRecHelper(tc2.contentType_, history, otherHistory))) {
            return false;
        }
        if (tc1.kind_ == TCKind.tk_fixed && (tc1.fixedDigits_ != tc2.fixedDigits_ || tc1.fixedScale_ != tc2.fixedScale_)) {
            return false;
        }
        if (tc1.kind_ == TCKind.tk_value) {
            if (tc1.memberVisibility_.length != tc2.memberVisibility_.length) {
                return false;
            }
            for (i = 0; i < tc1.memberVisibility_.length; ++i) {
                if (tc1.memberVisibility_[i] == tc2.memberVisibility_[i]) continue;
                return false;
            }
            if (tc1.typeModifier_ != tc2.typeModifier_) {
                return false;
            }
            if (tc1.concreteBaseType_ != null || tc2.concreteBaseType_ != null) {
                if (tc1.concreteBaseType_ == null || tc2.concreteBaseType_ == null) {
                    return false;
                }
                if (!tc1.concreteBaseType_.equivalent(tc2.concreteBaseType_)) {
                    return false;
                }
            }
        }
        return true;
    }

    private TypeCode getCompactTypeCodeRec(Vector history, Vector compacted) {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.getCompactTypeCodeRec(history, compacted);
        }
        for (int i = 0; i < history.size(); ++i) {
            if (this != history.elementAt(i)) continue;
            return (TypeCode)((Object)compacted.elementAt(i));
        }
        history.addElement(this);
        TypeCode result = new TypeCode();
        compacted.addElement(result);
        String[] names = null;
        if (this.memberNames_ != null) {
            names = new String[this.memberNames_.length];
            for (int i = 0; i < this.memberNames_.length; ++i) {
                names[i] = "";
            }
        }
        TypeCode[] types = null;
        if (this.memberTypes_ != null) {
            types = new TypeCode[this.memberTypes_.length];
            for (int i = 0; i < this.memberTypes_.length; ++i) {
                types[i] = this.memberTypes_[i].getCompactTypeCodeRec(history, compacted);
            }
        }
        TypeCode content = null;
        if (this.contentType_ != null) {
            content = this.contentType_.getCompactTypeCodeRec(history, compacted);
        }
        TypeCode discriminator = null;
        if (this.discriminatorType_ != null) {
            discriminator = this.discriminatorType_.getCompactTypeCodeRec(history, compacted);
        }
        TypeCode concrete = null;
        if (this.concreteBaseType_ != null) {
            concrete = this.concreteBaseType_.getCompactTypeCodeRec(history, compacted);
        }
        switch (this.kind_.value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                result.kind_ = this.kind_;
                break;
            }
            case 28: {
                result.kind_ = this.kind_;
                result.fixedDigits_ = this.fixedDigits_;
                result.fixedScale_ = this.fixedScale_;
                break;
            }
            case 14: 
            case 31: 
            case 32: 
            case 33: {
                result.kind_ = this.kind_;
                result.id_ = this.id_;
                result.name_ = "";
                break;
            }
            case 15: 
            case 22: {
                result.kind_ = this.kind_;
                result.id_ = this.id_;
                result.name_ = "";
                result.memberNames_ = names;
                result.memberTypes_ = types;
                break;
            }
            case 16: {
                result.kind_ = this.kind_;
                result.id_ = this.id_;
                result.name_ = "";
                result.memberNames_ = names;
                result.memberTypes_ = types;
                result.labels_ = this.labels_;
                result.discriminatorType_ = discriminator;
                break;
            }
            case 17: {
                result.kind_ = this.kind_;
                result.id_ = this.id_;
                result.name_ = "";
                result.memberNames_ = names;
                break;
            }
            case 18: 
            case 27: {
                result.kind_ = this.kind_;
                result.length_ = this.length_;
                break;
            }
            case 19: 
            case 20: {
                result.kind_ = this.kind_;
                result.length_ = this.length_;
                result.contentType_ = content;
                break;
            }
            case 21: 
            case 30: {
                result.kind_ = this.kind_;
                result.id_ = this.id_;
                result.name_ = "";
                result.contentType_ = content;
                break;
            }
            case 29: {
                result.kind_ = this.kind_;
                result.id_ = this.id_;
                result.name_ = "";
                result.memberNames_ = names;
                result.memberTypes_ = types;
                result.memberVisibility_ = this.memberVisibility_;
                result.typeModifier_ = this.typeModifier_;
                result.concreteBaseType_ = concrete;
                break;
            }
            default: {
                throw Assert.fail((String)"unsupported typecode");
            }
        }
        return result;
    }

    public boolean equal(org.omg.CORBA.TypeCode t) {
        if (t == null) {
            return false;
        }
        if (t == this) {
            return true;
        }
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.equal(t);
        }
        TypeCode tc = null;
        try {
            tc = (TypeCode)t;
        }
        catch (ClassCastException ex) {
            tc = TypeCode._OB_convertForeignTypeCode(t);
        }
        if (tc.recId_ != null) {
            if (tc.recType_ == null) {
                throw new BAD_PARAM(MinorCodes.describeBadParam((int)1330446349), 1330446349, CompletionStatus.COMPLETED_NO);
            }
            return this.equal(tc.recType_);
        }
        if (this.kind_ != tc.kind_) {
            return false;
        }
        if (this.kind_ == TCKind.tk_objref || this.kind_ == TCKind.tk_struct || this.kind_ == TCKind.tk_union || this.kind_ == TCKind.tk_enum || this.kind_ == TCKind.tk_alias || this.kind_ == TCKind.tk_value || this.kind_ == TCKind.tk_value_box || this.kind_ == TCKind.tk_native || this.kind_ == TCKind.tk_abstract_interface || this.kind_ == TCKind.tk_except || this.kind_ == org.omg.CORBA_2_4.TCKind.tk_local_interface) {
            if (!this.id_.equals("") || !tc.id_.equals("")) {
                return this.id_.equals(tc.id_);
            }
            if (!(this.name_.equals("") && tc.name_.equals("") || this.name_.equals(tc.name_))) {
                return false;
            }
        }
        if (this.kind_ == TCKind.tk_struct || this.kind_ == TCKind.tk_union || this.kind_ == TCKind.tk_enum || this.kind_ == TCKind.tk_value || this.kind_ == TCKind.tk_except) {
            if (this.memberNames_.length != tc.memberNames_.length) {
                return false;
            }
            for (int i = 0; i < this.memberNames_.length; ++i) {
                if (this.memberNames_[i].equals("") && tc.memberNames_[i].equals("") || this.memberNames_[i].equals(tc.memberNames_[i])) continue;
                return false;
            }
        }
        if (this.kind_ == TCKind.tk_struct || this.kind_ == TCKind.tk_union || this.kind_ == TCKind.tk_value || this.kind_ == TCKind.tk_except) {
            if (this.memberTypes_.length != tc.memberTypes_.length) {
                return false;
            }
            for (int i = 0; i < this.memberTypes_.length; ++i) {
                if (this.memberTypes_[i].equal(tc.memberTypes_[i])) continue;
                return false;
            }
        }
        if (this.kind_ == TCKind.tk_union) {
            if (this.labels_.length != tc.labels_.length) {
                return false;
            }
            for (int i = 0; i < this.labels_.length; ++i) {
                if (!this.labels_[i].type().equal(tc.labels_[i].type())) {
                    return false;
                }
                if (this.labels_[i].equal(tc.labels_[i])) continue;
                return false;
            }
            if (!this.discriminatorType_.equal(tc.discriminatorType_)) {
                return false;
            }
        }
        if ((this.kind_ == TCKind.tk_string || this.kind_ == TCKind.tk_wstring || this.kind_ == TCKind.tk_sequence || this.kind_ == TCKind.tk_array) && this.length_ != tc.length_) {
            return false;
        }
        if (!(this.kind_ != TCKind.tk_sequence && this.kind_ != TCKind.tk_array && this.kind_ != TCKind.tk_value_box && this.kind_ != TCKind.tk_alias || this.contentType_.equal(tc.contentType_))) {
            return false;
        }
        if (this.kind_ == TCKind.tk_fixed && (this.fixedDigits_ != tc.fixedDigits_ || this.fixedScale_ != tc.fixedScale_)) {
            return false;
        }
        if (this.kind_ == TCKind.tk_value) {
            if (this.memberVisibility_.length != tc.memberVisibility_.length) {
                return false;
            }
            for (int i = 0; i < this.memberVisibility_.length; ++i) {
                if (this.memberVisibility_[i] == tc.memberVisibility_[i]) continue;
                return false;
            }
            if (this.typeModifier_ != tc.typeModifier_) {
                return false;
            }
            if (this.concreteBaseType_ != null || tc.concreteBaseType_ != null) {
                if (this.concreteBaseType_ == null || tc.concreteBaseType_ == null) {
                    return false;
                }
                if (!this.concreteBaseType_.equal(tc.concreteBaseType_)) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equivalent(org.omg.CORBA.TypeCode t) {
        Vector history = new Vector();
        Vector otherHistory = new Vector();
        boolean result = this.equivalentRecHelper(t, history, otherHistory);
        Assert.ensure((history.size() == 0 ? 1 : 0) != 0);
        Assert.ensure((otherHistory.size() == 0 ? 1 : 0) != 0);
        return result;
    }

    public org.omg.CORBA.TypeCode get_compact_typecode() {
        Vector history = new Vector();
        Vector compacted = new Vector();
        return this.getCompactTypeCodeRec(history, compacted);
    }

    public TCKind kind() {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.kind();
        }
        return this.kind_;
    }

    public String id() throws BadKind {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.id();
        }
        if (this.kind_ != TCKind.tk_objref && this.kind_ != TCKind.tk_struct && this.kind_ != TCKind.tk_union && this.kind_ != TCKind.tk_enum && this.kind_ != TCKind.tk_alias && this.kind_ != TCKind.tk_value && this.kind_ != TCKind.tk_value_box && this.kind_ != TCKind.tk_native && this.kind_ != TCKind.tk_abstract_interface && this.kind_ != TCKind.tk_except && this.kind_ != org.omg.CORBA_2_4.TCKind.tk_local_interface) {
            throw new BadKind();
        }
        return this.id_;
    }

    public String name() throws BadKind {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.name();
        }
        if (this.kind_ != TCKind.tk_objref && this.kind_ != TCKind.tk_struct && this.kind_ != TCKind.tk_union && this.kind_ != TCKind.tk_enum && this.kind_ != TCKind.tk_alias && this.kind_ != TCKind.tk_value && this.kind_ != TCKind.tk_value_box && this.kind_ != TCKind.tk_native && this.kind_ != TCKind.tk_abstract_interface && this.kind_ != TCKind.tk_except && this.kind_ != org.omg.CORBA_2_4.TCKind.tk_local_interface) {
            throw new BadKind();
        }
        return this.name_;
    }

    public int member_count() throws BadKind {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.member_count();
        }
        if (this.kind_ != TCKind.tk_struct && this.kind_ != TCKind.tk_union && this.kind_ != TCKind.tk_enum && this.kind_ != TCKind.tk_value && this.kind_ != TCKind.tk_except) {
            throw new BadKind();
        }
        return this.memberNames_.length;
    }

    public String member_name(int index) throws BadKind, Bounds {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.member_name(index);
        }
        if (this.kind_ != TCKind.tk_struct && this.kind_ != TCKind.tk_union && this.kind_ != TCKind.tk_enum && this.kind_ != TCKind.tk_value && this.kind_ != TCKind.tk_except) {
            throw new BadKind();
        }
        try {
            return this.memberNames_[index];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new Bounds();
        }
    }

    public org.omg.CORBA.TypeCode member_type(int index) throws BadKind, Bounds {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.member_type(index);
        }
        if (this.kind_ != TCKind.tk_struct && this.kind_ != TCKind.tk_union && this.kind_ != TCKind.tk_value && this.kind_ != TCKind.tk_except) {
            throw new BadKind();
        }
        try {
            return this.memberTypes_[index];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new Bounds();
        }
    }

    public org.omg.CORBA.Any member_label(int index) throws BadKind, Bounds {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.member_label(index);
        }
        if (this.kind_ != TCKind.tk_union) {
            throw new BadKind();
        }
        try {
            return this.labels_[index];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new Bounds();
        }
    }

    public org.omg.CORBA.TypeCode discriminator_type() throws BadKind {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.discriminator_type();
        }
        if (this.kind_ != TCKind.tk_union) {
            throw new BadKind();
        }
        return this.discriminatorType_;
    }

    public int default_index() throws BadKind {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.default_index();
        }
        if (this.kind_ != TCKind.tk_union) {
            throw new BadKind();
        }
        for (int i = 0; i < this.labels_.length; ++i) {
            org.omg.CORBA.TypeCode tc = this.labels_[i].type();
            if (tc.kind() != TCKind.tk_octet) continue;
            return i;
        }
        return -1;
    }

    public int length() throws BadKind {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.length();
        }
        if (this.kind_ != TCKind.tk_string && this.kind_ != TCKind.tk_wstring && this.kind_ != TCKind.tk_sequence && this.kind_ != TCKind.tk_array) {
            throw new BadKind();
        }
        return this.length_;
    }

    public TypeCode content_type() throws BadKind {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.content_type();
        }
        if (this.kind_ != TCKind.tk_sequence && this.kind_ != TCKind.tk_array && this.kind_ != TCKind.tk_value_box && this.kind_ != TCKind.tk_alias) {
            throw new BadKind();
        }
        return this.contentType_;
    }

    public short fixed_digits() throws BadKind {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.fixed_digits();
        }
        if (this.kind_ != TCKind.tk_fixed) {
            throw new BadKind();
        }
        return this.fixedDigits_;
    }

    public short fixed_scale() throws BadKind {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.fixed_scale();
        }
        if (this.kind_ != TCKind.tk_fixed) {
            throw new BadKind();
        }
        return this.fixedScale_;
    }

    public short member_visibility(int index) throws BadKind, Bounds {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.member_visibility(index);
        }
        if (this.kind_ != TCKind.tk_value) {
            throw new BadKind();
        }
        try {
            return this.memberVisibility_[index];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new Bounds();
        }
    }

    public short type_modifier() throws BadKind {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.type_modifier();
        }
        if (this.kind_ != TCKind.tk_value) {
            throw new BadKind();
        }
        return this.typeModifier_;
    }

    public org.omg.CORBA.TypeCode concrete_base_type() throws BadKind {
        if (this.recId_ != null) {
            if (this.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode((int)1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            return this.recType_.concrete_base_type();
        }
        if (this.kind_ != TCKind.tk_value) {
            throw new BadKind();
        }
        return this.concreteBaseType_;
    }

    public TypeCode _OB_getOrigType() {
        return TypeCode._OB_getOrigType(this);
    }

    public static org.omg.CORBA.TypeCode _OB_getOrigType(org.omg.CORBA.TypeCode tc) {
        try {
            while (tc.kind() == TCKind.tk_alias) {
                tc = tc.content_type();
            }
        }
        catch (BadKind ex) {
            throw Assert.fail((Throwable)ex);
        }
        return tc;
    }

    public static TypeCode _OB_getOrigType(TypeCode tc) {
        try {
            while (tc.kind() == TCKind.tk_alias) {
                tc = tc.content_type();
            }
        }
        catch (BadKind ex) {
            throw Assert.fail((Throwable)ex);
        }
        return tc;
    }

    public boolean _OB_isSystemException() {
        if (this.kind_ != TCKind.tk_except) {
            return false;
        }
        return Util.isSystemException(this.id_);
    }

    private static TypeCode _OB_convertForeignTypeCodeHelper(org.omg.CORBA.TypeCode tc, Hashtable history, Vector recHistory) {
        if (tc instanceof TypeCode) {
            return (TypeCode)tc;
        }
        TypeCode result = null;
        try {
            TCKind kind = tc.kind();
            int kindValue = kind.value();
            if (kindValue == 15 || kindValue == 22 || kindValue == 16 || kindValue == 29) {
                for (int i = 0; i < recHistory.size(); ++i) {
                    if (tc != recHistory.elementAt(i)) continue;
                    result = new TypeCode();
                    result.recId_ = tc.id();
                    result.recType_ = (TypeCode)((Object)history.get(tc));
                    Assert.ensure((result.recType_ != null ? 1 : 0) != 0);
                    return result;
                }
            }
            if ((result = (TypeCode)((Object)history.get(tc))) != null) {
                return result;
            }
            result = new TypeCode();
            history.put(tc, result);
            switch (kindValue) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    result.kind_ = kind;
                    break;
                }
                case 28: {
                    result.kind_ = kind;
                    result.fixedDigits_ = tc.fixed_digits();
                    result.fixedScale_ = tc.fixed_scale();
                    break;
                }
                case 14: 
                case 31: 
                case 32: 
                case 33: {
                    result.kind_ = kind;
                    result.id_ = tc.id();
                    result.name_ = tc.name();
                    break;
                }
                case 15: 
                case 22: {
                    int i;
                    result.kind_ = kind;
                    result.id_ = tc.id();
                    result.name_ = tc.name();
                    int count = tc.member_count();
                    result.memberNames_ = new String[count];
                    for (i = 0; i < count; ++i) {
                        result.memberNames_[i] = tc.member_name(i);
                    }
                    recHistory.addElement(tc);
                    result.memberTypes_ = new TypeCode[count];
                    for (i = 0; i < count; ++i) {
                        result.memberTypes_[i] = TypeCode._OB_convertForeignTypeCodeHelper(tc.member_type(i), history, recHistory);
                    }
                    recHistory.setSize(recHistory.size() - 1);
                    break;
                }
                case 16: {
                    int i;
                    result.kind_ = kind;
                    result.id_ = tc.id();
                    result.name_ = tc.name();
                    int count = tc.member_count();
                    result.memberNames_ = new String[count];
                    for (i = 0; i < count; ++i) {
                        result.memberNames_[i] = tc.member_name(i);
                    }
                    recHistory.addElement(tc);
                    result.memberTypes_ = new TypeCode[count];
                    for (i = 0; i < count; ++i) {
                        result.memberTypes_[i] = TypeCode._OB_convertForeignTypeCodeHelper(tc.member_type(i), history, recHistory);
                    }
                    recHistory.setSize(recHistory.size() - 1);
                    result.labels_ = new Any[count];
                    for (i = 0; i < count; ++i) {
                        result.labels_[i] = new Any(tc.member_label(i));
                    }
                    result.discriminatorType_ = TypeCode._OB_convertForeignTypeCodeHelper(tc.discriminator_type(), history, null);
                    break;
                }
                case 17: {
                    result.kind_ = kind;
                    result.id_ = tc.id();
                    result.name_ = tc.name();
                    int count = tc.member_count();
                    result.memberNames_ = new String[count];
                    for (int i = 0; i < count; ++i) {
                        result.memberNames_[i] = tc.member_name(i);
                    }
                    break;
                }
                case 18: 
                case 27: {
                    result.kind_ = kind;
                    result.length_ = tc.length();
                    break;
                }
                case 19: 
                case 20: {
                    result.kind_ = kind;
                    result.length_ = tc.length();
                    result.contentType_ = TypeCode._OB_convertForeignTypeCodeHelper(tc.content_type(), history, recHistory);
                    break;
                }
                case 21: 
                case 30: {
                    result.kind_ = kind;
                    result.id_ = tc.id();
                    result.name_ = tc.name();
                    result.contentType_ = TypeCode._OB_convertForeignTypeCodeHelper(tc.content_type(), history, recHistory);
                    break;
                }
                case 29: {
                    int i;
                    result.kind_ = kind;
                    result.id_ = tc.id();
                    result.name_ = tc.name();
                    int count = tc.member_count();
                    result.memberNames_ = new String[count];
                    for (i = 0; i < count; ++i) {
                        result.memberNames_[i] = tc.member_name(i);
                    }
                    recHistory.addElement(tc);
                    result.memberTypes_ = new TypeCode[count];
                    for (i = 0; i < count; ++i) {
                        result.memberTypes_[i] = TypeCode._OB_convertForeignTypeCodeHelper(tc.member_type(i), history, recHistory);
                    }
                    recHistory.setSize(recHistory.size() - 1);
                    result.memberVisibility_ = new short[count];
                    for (i = 0; i < count; ++i) {
                        result.memberVisibility_[i] = tc.member_visibility(i);
                    }
                    result.typeModifier_ = tc.type_modifier();
                    result.concreteBaseType_ = TypeCode._OB_convertForeignTypeCodeHelper(tc.concrete_base_type(), history, recHistory);
                    break;
                }
                default: {
                    throw Assert.fail((String)"Unsupported typecode");
                }
            }
        }
        catch (BadKind | Bounds ex) {
            throw Assert.fail((Throwable)ex);
        }
        return result;
    }

    public static TypeCode _OB_convertForeignTypeCode(org.omg.CORBA.TypeCode tc) {
        Assert.ensure((!(tc instanceof TypeCode) ? 1 : 0) != 0);
        Hashtable history = new Hashtable(7);
        Vector recHistory = new Vector();
        return TypeCode._OB_convertForeignTypeCodeHelper(tc, history, recHistory);
    }

    public static void _OB_embedRecTC(TypeCode outer) {
        Assert.ensure((outer.recId_ == null ? 1 : 0) != 0);
        if (outer.kind_ != TCKind.tk_struct && outer.kind_ != TCKind.tk_except && outer.kind_ != TCKind.tk_union && outer.kind_ != TCKind.tk_value) {
            throw new BAD_TYPECODE("Illegal recursion");
        }
        TypeCode._OB_embedRecTC(outer, outer);
    }

    public static void _OB_embedRecTC(TypeCode outer, TypeCode inner) {
        if (inner.recId_ != null) {
            if (inner.recId_.equals(outer.id_)) {
                if (inner.recType_ != null) {
                    Assert.ensure((inner.recType_ == outer ? 1 : 0) != 0);
                } else {
                    inner.recType_ = outer;
                }
            }
        } else {
            if (inner.kind_ == TCKind.tk_sequence || inner.kind_ == TCKind.tk_value_box || inner.kind_ == TCKind.tk_array || inner.kind_ == TCKind.tk_alias) {
                Assert.ensure((inner.contentType_ != outer ? 1 : 0) != 0);
                TypeCode._OB_embedRecTC(outer, inner.contentType_);
            }
            if (inner.kind_ == TCKind.tk_struct || inner.kind_ == TCKind.tk_union || inner.kind_ == TCKind.tk_value || inner.kind_ == TCKind.tk_except) {
                for (int i = 0; i < inner.memberTypes_.length; ++i) {
                    Assert.ensure((inner.memberTypes_[i] != outer ? 1 : 0) != 0);
                    TypeCode._OB_embedRecTC(outer, inner.memberTypes_[i]);
                }
            }
            if (inner.kind_ == TCKind.tk_value && inner.concreteBaseType_ != null) {
                TypeCode._OB_embedRecTC(outer, inner.concreteBaseType_);
            }
        }
    }
}

