/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.ws.sib.admin.AliasDestination;
import com.ibm.ws.sib.admin.internal.BaseDestinationImpl;

public class AliasDestinationImpl
extends BaseDestinationImpl
implements AliasDestination {
    private String targetDestination = null;
    private String overrideOfQOSByProducerAllowed = "true";
    private String defaultReliability = "ASSURED_PERSISTENT";
    private String maximumReliability = "ASSURED_PERSISTENT";
    private String sendAllowed = "true";
    private String receiveAllowed = "true";
    private boolean delegateAuthCheckToTargetDestination = true;

    public AliasDestinationImpl() {
    }

    public AliasDestinationImpl(String name) {
        super(name, true, false);
    }

    public boolean equals(Object o) {
        AliasDestination oldDestination = (AliasDestination)o;
        boolean isEqual = true;
        isEqual = this.getTargetDestination().equals(oldDestination.getTargetDestination()) && this.isOverrideOfQOSByProducerAllowed().equals(oldDestination.isOverrideOfQOSByProducerAllowed()) && this.isReceiveAllowed().equals(oldDestination.isReceiveAllowed()) && this.isSendAllowed().equals(oldDestination.isSendAllowed()) && this.getDefaultReliability().equals(oldDestination.getDefaultReliability()) && this.getMaximumReliability().equals(oldDestination.getMaximumReliability()) && this.getDelegateAuthCheckToTargetDestination() == oldDestination.getDelegateAuthCheckToTargetDestination();
        return isEqual;
    }

    public String getDefaultReliability() {
        return this.defaultReliability;
    }

    public boolean getDelegateAuthCheckToTargetDestination() {
        return this.delegateAuthCheckToTargetDestination;
    }

    public String getMaximumReliability() {
        return this.maximumReliability;
    }

    public String getTargetDestination() {
        return this.targetDestination;
    }

    public String isOverrideOfQOSByProducerAllowed() {
        return this.overrideOfQOSByProducerAllowed;
    }

    public String isReceiveAllowed() {
        return this.receiveAllowed;
    }

    public String isSendAllowed() {
        return this.sendAllowed;
    }

    public void setDefaultReliability(String defaultReliability) {
        this.defaultReliability = this.getDestinationReliability(defaultReliability);
    }

    public void setDelegateAuthCheckToTargetDestination(boolean delegateAuthCheckToTargetDestination) {
        this.delegateAuthCheckToTargetDestination = delegateAuthCheckToTargetDestination;
    }

    public void setMaximumReliability(String maximumReliability) {
        this.maximumReliability = this.getDestinationReliability(maximumReliability);
    }

    public void setOverrideOfQOSByProducerAllowed(String overrideOfQOSByProducerAllowed) {
        this.overrideOfQOSByProducerAllowed = overrideOfQOSByProducerAllowed;
    }

    public void setReceiveAllowed(String receiveAllowed) {
        this.receiveAllowed = receiveAllowed;
    }

    public void setSendAllowed(String sendAllowed) {
        this.sendAllowed = sendAllowed;
    }

    public void setTargetDestination(String targetDestination) {
        this.targetDestination = targetDestination;
    }

    private String getDestinationReliability(String reliability) {
        String rel = null;
        if (reliability.equals("BestEffortNonPersistent")) {
            rel = "BEST_EFFORT_NONPERSISTENT";
        } else if (reliability.equals("ExpressNonPersistent")) {
            rel = "EXPRESS_NONPERSISTENT";
        } else if (reliability.equals("ReliableNonPersistent")) {
            rel = "RELIABLE_NONPERSISTENT";
        } else if (reliability.equals("ReliablePersistent")) {
            rel = "RELIABLE_PERSISTENT";
        } else if (reliability.equals("AssuredPersistent")) {
            rel = "ASSURED_PERSISTENT";
        } else if (reliability.equals("Inherit")) {
            rel = "INHERIT";
        }
        return rel;
    }
}

