/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.file;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.websphere.security.audit.InvalidConfigurationException;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.KeyValueStringPair;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.encryption.AuditEncryptionImpl;
import com.ibm.ws.security.audit.encryption.AuditSigningImpl;
import com.ibm.ws.security.audit.event.AuditMgmtEvent;
import com.ibm.ws.security.audit.logutils.FileLog;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.CollectorManager;
import com.ibm.wsspi.collector.manager.Handler;
import com.ibm.wsspi.collector.manager.SynchronousHandler;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.audit.AuditEncryptionException;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.AuditSigningException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={Handler.class}, configurationPid={"com.ibm.ws.security.audit.file.handler"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"service.vendor=IBM"}, immediate=true)
public class AuditFileHandler
implements SynchronousHandler {
    private static final TraceComponent tc = Tr.register(AuditFileHandler.class, (String)"auditFileHandler", (String)"com.ibm.ws.security.audit.file.internal.resources.AuditMessages");
    private static final String AUDIT_FILE_LOG_DEFAULT_NAME = "audit.log";
    private volatile CollectorManager collectorMgr;
    private static final String KEY_EXECUTOR_SERVICE = "executorSrvc";
    private final AtomicServiceReference<ExecutorService> executorSrvcRef = new AtomicServiceReference("executorSrvc");
    static final String KEY_KEYSTORE_SERVICE_REF = "keyStoreService";
    private final AtomicServiceReference<KeyStoreService> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    public static final String KEY_CONFIGURATION_ADMIN = "configurationAdmin";
    private final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configurationAdmin");
    private static final Object KEY_ID = "id";
    private volatile Future<?> handlerTaskRef = null;
    private volatile BufferManager bufferMgr = null;
    protected volatile FileLog auditLog = null;
    private final String KEY_LOCATION_ADMIN = "locationAdmin";
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    private static final String KEY_AUDIT_SERVICE = "auditService";
    protected final AtomicServiceReference<AuditService> auditServiceRef = new AtomicServiceReference("auditService");
    private final List<String> sourceIds = new ArrayList<String>(){
        static final long serialVersionUID = -7688872831171341278L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;
        {
            this.add("audit|server");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.audit.file.AuditFileHandler$1", 1.class, (String)"auditFileHandler", (String)"com.ibm.ws.security.audit.file.internal.resources.AuditMessages");
        }
    };
    private boolean encrypt = false;
    private boolean sign = false;
    private String encryptAlias = null;
    private String signerAlias = null;
    private final String encryptKeyStoreRef;
    private String encryptKeyStoreId = null;
    private final String signerKeyStoreRef;
    private String signerKeyStoreId = null;
    private String wrapBehavior = null;
    private String logDirectory = null;
    private Integer maxFiles = -1;
    private Integer maxFileSize = -1;
    private String[] events = null;
    private boolean compact = false;
    private Map<String, Object> thisConfiguration;
    private String encryptKeyStoreLocation = null;
    private String signerKeyStoreLocation = null;
    private final Certificate encryptCert = null;
    private Key sharedKey = null;
    private String sharedKeyAlias = null;
    private Key publicKey = null;
    private byte[] encryptedSharedKey = null;
    private X509Certificate cert = null;
    private AuditService auditService = null;
    private Key signedSharedKey = null;
    private Key publicSignerKey = null;
    private Key privateSignerKey = null;
    private byte[] encryptedSignerSharedKey = null;
    private X509Certificate signerCert = null;
    private byte[] signerCertBytes = null;
    private static final String encryptionOpenTag = "<EncryptionInformation>\n";
    private static final String encryptionCloseTag = "</EncryptionInformation>\n";
    private static final String encryptedSharedKeyOpenTag = "   <encryptedSharedKey>";
    private static final String encryptedSharedKeyCloseTag = "</encryptedSharedKey>\n";
    private static final String encryptionCertAliasOpenTag = "   <encryptionCertAlias>";
    private static final String encryptionCertAliasCloseTag = "</encryptionCertAlias>\n";
    private static final String signingCertAliasOpenTag = "   <signingCertAlias>";
    private static final String signingCertAliasCloseTag = "</signingCertAlias>\n";
    private static final String encryptionKeyStoreOpenTag = "   <encryptionKeyStore>";
    private static final String encryptionKeyStoreCloseTag = "</encryptionKeyStore>\n";
    private static final String signingKeyStoreOpenTag = "   <signingKeyStore>";
    private static final String signingKeyStoreCloseTag = "</signingKeyStore>\n";
    private static final String keyStoreNameOpenTag = "   <keyStoreName>";
    private static final String keyStoreNameCloseTag = "</keyStoreName>\n";
    private static final String encryptionCertificateOpenTag = "   <encryptionCertificate>";
    private static final String encryptionCertificateCloseTag = "</encryptionCertificate>\n";
    private static final String signingCertificateOpenTag = "   <signingCertificate>";
    private static final String signingCertificateCloseTag = "</signingCertificate>\n";
    private static final String scopeOpenTag = "   <scope>";
    private static final String scopeCloseTag = "</scope>\n";
    private static final String signatureOpenTag = "<signature>";
    private static final String signatureCloseTag = "</signature>";
    private static final String signingOpenTag = "<SigningInformation>\n";
    private static final String signingCloseTag = "</SigningInformation>\n";
    private static final String signingSharedKeyOpenTag = "   <signingSharedKey>";
    private static final String signingSharedKeyCloseTag = "</signingSharedKey>\n";
    private final String signerKeyStoreName;
    private final String signerKeyStoreScope;
    private final String signerCertAlias;
    private final String signerKeyFileLocation;
    private static final String newLine = "\n";
    private static final String begin = "<auditRecord>";
    private static final String end = "</auditRecord>";
    List<Map<String, Object>> configuredEvents = null;
    AuditEncryptionImpl ae = null;
    AuditSigningImpl as = null;
    boolean encryptHeaderEmitted = false;
    boolean signerHeaderEmitted = false;
    private final int eventSequenceNumber = 0;
    byte[] signedEncryptedAuditRecord = null;
    byte[] signedAuditRecord = null;
    byte[] mergedByteRecord = null;
    byte[] er = null;
    ByteArrayOutputStream baos = null;
    private static Object syncObject = new Object();
    private static Object syncSeqNum = new Object();
    private String bundleLocation;
    static final long serialVersionUID = -8915755365355903961L;

    public AuditFileHandler() {
        this.encryptKeyStoreRef = null;
        this.signerKeyStoreRef = null;
        this.signerKeyStoreName = null;
        this.signerKeyStoreScope = null;
        this.signerCertAlias = null;
        this.signerKeyFileLocation = null;
    }

    @Activate
    protected void activate(ComponentContext cc) throws KeyStoreException, AuditEncryptionException, AuditSigningException {
        Map configuration;
        Tr.info((TraceComponent)tc, (String)"AUDIT_FILEHANDLER_STARTING", (Object[])new Object[0]);
        this.locationAdminRef.activate(cc);
        this.executorSrvcRef.activate(cc);
        this.auditServiceRef.activate(cc);
        this.configAdminRef.activate(cc);
        this.bundleLocation = cc.getBundleContext().getBundle().getLocation();
        this.thisConfiguration = configuration = (Map)((Object)cc.getProperties());
        if (configuration != null && !configuration.isEmpty()) {
            for (Map.Entry entry : configuration.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (key.equals("maxFiles")) {
                    this.setMaxFiles(value);
                    continue;
                }
                if (key.equals("maxFileSize")) {
                    this.setMaxFileSize(value);
                    continue;
                }
                if (key.equals("encrypt")) {
                    this.setEncrypt(value);
                    continue;
                }
                if (key.equals("sign")) {
                    this.setSign(value);
                    continue;
                }
                if (key.equals("wrapBehavior")) {
                    this.setWrapBehavior(value);
                    continue;
                }
                if (key.equals("logDirectory")) {
                    this.setLogDirectory(value);
                    continue;
                }
                if (key.equals("compact")) {
                    this.setCompact(value);
                    continue;
                }
                if (key.equals("encryptAlias")) {
                    this.setEncryptAlias(value);
                    continue;
                }
                if (key.equals("signingAlias")) {
                    this.setSignerAlias(value);
                    continue;
                }
                if (key.equals("encryptKeyStoreRef")) {
                    this.setEncryptKeyStoreRef(value);
                    continue;
                }
                if (!key.equals("signingKeyStoreRef")) continue;
                this.setSignerKeyStoreRef(value);
            }
        }
        this.configuredEvents = Nester.nest("events", configuration);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("configuredEvents being sent to AuditService: " + this.configuredEvents.toString()), (Object[])new Object[0]);
        }
        if (this.getEncrypt().booleanValue() || this.getSign().booleanValue()) {
            this.keyStoreServiceRef.activate(cc);
        }
        this.auditService = (AuditService)this.auditServiceRef.getService();
        try {
            this.auditService.registerEvents(this.getHandlerName(), this.configuredEvents);
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            FFDCFilter.processException((Throwable)invalidConfigurationException, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"265", (Object)this, (Object[])new Object[]{cc});
            this.locationAdminRef.deactivate(cc);
            this.executorSrvcRef.deactivate(cc);
            this.auditServiceRef.deactivate(cc);
            this.keyStoreServiceRef.deactivate(cc);
            this.configAdminRef.deactivate(cc);
            cc.disableComponent((String)configuration.get("service.pid"));
            Tr.info((TraceComponent)tc, (String)"AUDIT_FILEHANDLER_STOPPED", (Object[])new Object[0]);
            throw new ComponentException("Caught invalidConfigurationException");
        }
        this.auditLog = FileLog.createFileLogHolder(null, this.logDirectory != null ? new File(this.logDirectory) : new File(this.getLogDir()), AUDIT_FILE_LOG_DEFAULT_NAME, this.maxFiles != -1 ? this.maxFiles : 100, this.maxFileSize != -1 ? (long)this.maxFileSize.intValue() * 1024L * 1024L : 0x1400000L);
        if (this.getEncrypt().booleanValue()) {
            this.setEncryptionKeys();
        }
        if (this.getSign().booleanValue()) {
            this.setSignerKeys();
        }
        Tr.info((TraceComponent)tc, (String)"AUDIT_FILEHANDLER_READY", (Object[])new Object[0]);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.auditService.unRegisterEvents(this.getHandlerName());
        this.locationAdminRef.deactivate(cc);
        this.executorSrvcRef.deactivate(cc);
        this.auditServiceRef.deactivate(cc);
        if (this.getEncrypt().booleanValue() || this.getSign().booleanValue()) {
            this.keyStoreServiceRef.deactivate(cc);
        }
        this.configAdminRef.deactivate(cc);
        this.bundleLocation = null;
        this.auditLog.close();
        Tr.info((TraceComponent)tc, (String)"AUDIT_FILEHANDLER_STOPPED", (Object[])new Object[0]);
    }

    @Reference(service=WsLocationAdmin.class, name="locationAdmin")
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> reference) {
        this.locationAdminRef.setReference(reference);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> reference) {
        this.locationAdminRef.unsetReference(reference);
    }

    @Reference(service=AuditService.class, name="auditService")
    protected void setAuditService(ServiceReference<AuditService> reference) {
        this.auditServiceRef.setReference(reference);
    }

    protected void unsetAuditService(ServiceReference<AuditService> reference) {
        this.auditServiceRef.unsetReference(reference);
    }

    @Reference(service=ExecutorService.class, name="executorSrvc", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setExecutorSrvc(ServiceReference<ExecutorService> service) {
        this.executorSrvcRef.setReference(service);
    }

    protected void unsetExecutorSrvc(ServiceReference<ExecutorService> service) {
        this.executorSrvcRef.unsetReference(service);
    }

    @Reference(name="keyStoreService", service=KeyStoreService.class)
    protected void setKeyStoreService(ServiceReference<KeyStoreService> reference) {
        this.keyStoreServiceRef.setReference(reference);
    }

    protected void unsetKeyStoreService(ServiceReference<KeyStoreService> reference) {
        this.keyStoreServiceRef.unsetReference(reference);
    }

    @Reference(name="configurationAdmin", service=ConfigurationAdmin.class)
    protected void setConfigurationAdmin(ServiceReference<ConfigurationAdmin> ref) {
        this.configAdminRef.setReference(ref);
    }

    protected void unsetConfigurationAdmin(ServiceReference<ConfigurationAdmin> ref) {
        this.configAdminRef.unsetReference(ref);
    }

    public String getHandlerName() {
        return "AuditFileHandler";
    }

    public void init(CollectorManager collectorMgr) {
        try {
            this.collectorMgr = collectorMgr;
            this.collectorMgr.subscribe((Handler)this, this.sourceIds);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"372", (Object)this, (Object[])new Object[]{collectorMgr});
        }
    }

    public void setBufferManager(String sourceId, BufferManager bufferMgr) {
        this.auditService.sendEvent(null);
    }

    public void unsetBufferManager(String sourceId, BufferManager bufferMgr) {
        if (this.auditService.isAuditRequired("SECURITY_AUDIT_MGMT", "success")) {
            AuditMgmtEvent av = new AuditMgmtEvent(this.thisConfiguration, "AuditHandler:" + "AuditFileHandler", "stop");
            this.auditService.sendEvent((AuditEvent)av);
            av = new AuditMgmtEvent(this.thisConfiguration, "AuditService", "stop");
            this.auditService.sendEvent((AuditEvent)av);
        }
    }

    private String getLogDir() {
        StringBuffer output = new StringBuffer();
        WsLocationAdmin locationAdmin = (WsLocationAdmin)this.locationAdminRef.getService();
        output.append(locationAdmin.resolveString("${server.output.dir}").replace('\\', '/')).append("/logs");
        return output.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String mapToJSONString(Map<String, Object> eventMap) {
        String jsonString;
        block2: {
            JSONObject jsonEvent = new JSONObject();
            jsonString = null;
            this.map2JSON(jsonEvent, eventMap);
            try {
                jsonString = !this.compact ? jsonEvent.serialize(true).replaceAll("\\\\/", "/") : jsonEvent.toString();
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"427", (Object)this, (Object[])new Object[]{eventMap});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Unexpected error converting AuditEvent to JSON String", (Object[])new Object[]{e});
            }
        }
        return jsonString;
    }

    private JSONObject map2JSON(JSONObject jo, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            JSONObject jsonSubstruc;
            String subkeys = null;
            String key = null;
            Object value = entry.getValue();
            int i = entry.getKey().indexOf(".");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"raw key, index", (Object[])new Object[]{entry.getKey(), i});
            }
            if (i > -1) {
                subkeys = entry.getKey().substring(i + 1);
                key = entry.getKey().substring(0, i);
            } else {
                key = entry.getKey();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"key, subkeys", (Object[])new Object[]{key, subkeys});
            }
            if (subkeys == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("simple key: " + entry.getKey()), (Object[])new Object[0]);
                }
                if (value == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"value is null", (Object[])new Object[0]);
                    }
                    jo.put((Object)key, (Object)"null");
                    continue;
                }
                if (value instanceof Map) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"value is a Map, calling map2JSON", (Object[])new Object[]{value});
                    }
                    jo.put((Object)key, (Object)this.map2JSON(new JSONObject(), (Map)value));
                    continue;
                }
                if (value.getClass().isArray()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"value is an array, calling array2JSON", (Object[])new Object[]{value});
                    }
                    jo.put((Object)key, (Object)this.array2JSON(new JSONArray(), (Object[])value));
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"simple value, adding to jo", (Object[])new Object[]{value});
                }
                jo.put((Object)key, value);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("compound key: " + entry.getKey()), (Object[])new Object[0]);
            }
            if ((jsonSubstruc = (JSONObject)jo.get((Object)key)) == null) {
                jsonSubstruc = new JSONObject();
                jo.put((Object)key, (Object)jsonSubstruc);
            }
            TreeMap<String, Object> submap = new TreeMap<String, Object>();
            submap.put(subkeys, value);
            this.map2JSON(jsonSubstruc, submap);
        }
        return jo;
    }

    private JSONArray array2JSON(JSONArray ja, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] instanceof Map) {
                ja.add((Object)this.map2JSON(new JSONObject(), (Map)array[i]));
                continue;
            }
            if (array[i].getClass().isArray()) {
                ja.add((Object)this.array2JSON(new JSONArray(), (Object[])array[i]));
                continue;
            }
            ja.add(array[i]);
        }
        return ja;
    }

    public void setMaxFiles(Object value) {
        this.maxFiles = (Integer)value;
    }

    public Integer getMaxFiles() {
        return this.maxFiles;
    }

    public void setMaxFileSize(Object value) {
        this.maxFileSize = (Integer)value;
    }

    public Integer getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setLogDirectory(Object value) {
        this.logDirectory = (String)value;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public void setWrapBehavior(Object value) {
        this.wrapBehavior = (String)value;
    }

    public String getWrapBehavior() {
        return this.wrapBehavior;
    }

    public void setEncrypt(Object value) {
        this.encrypt = (Boolean)value;
    }

    public Boolean getEncrypt() {
        return this.encrypt;
    }

    public void setSign(Object value) {
        this.sign = (Boolean)value;
    }

    public Boolean getSign() {
        return this.sign;
    }

    public void setCompact(Object value) {
        this.compact = (Boolean)value;
    }

    public Boolean getCompact() {
        return this.compact;
    }

    public void setEncryptAlias(Object value) {
        this.encryptAlias = (String)value;
    }

    public String getEncryptAlias() {
        return this.encryptAlias;
    }

    public void setSignerAlias(Object value) {
        this.signerAlias = (String)value;
    }

    public String getSignerAlias() {
        return this.signerAlias;
    }

    public void setEncryptKeyStoreRef(Object value) {
        String id;
        this.encryptKeyStoreId = id = this.getKeyStoreId((String)value);
    }

    public String getEncryptKeyStoreRef() {
        return this.encryptKeyStoreId;
    }

    public void setSignerKeyStoreRef(Object value) {
        String id;
        this.signerKeyStoreId = id = this.getKeyStoreId((String)value);
    }

    public String getSignerKeyStoreRef() {
        return this.signerKeyStoreId;
    }

    public void setEvents(Object value) {
        this.events = ((String)value).split(", ");
    }

    public String[] getEvents() {
        return this.events;
    }

    /*
     * WARNING - void declaration
     */
    public void setSignerKeys() throws KeyStoreException, AuditSigningException {
        KeyStoreService service = null;
        int retries = 0;
        if (this.getSign().booleanValue()) {
            service = (KeyStoreService)this.keyStoreServiceRef.getService();
            try {
                this.signerKeyStoreLocation = service.getKeyStoreLocation(this.signerKeyStoreId);
            }
            catch (KeyStoreException keyStoreException) {
                void e;
                FFDCFilter.processException((Throwable)keyStoreException, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"663", (Object)this, (Object[])new Object[0]);
                ++retries;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"667", (Object)this, (Object[])new Object[0]);
                }
                if (retries < 6) {
                    try {
                        this.signerKeyStoreLocation = service.getKeyStoreLocation(this.signerKeyStoreId);
                    }
                    catch (KeyStoreException keyStoreException2) {
                        FFDCFilter.processException((Throwable)keyStoreException2, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"673", (Object)this, (Object[])new Object[0]);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception with keystore.", (Object[])new Object[]{e.getMessage()});
                }
                Tr.error((TraceComponent)tc, (String)"FAILURE_INITIALIZING_SIGNING_CONFIGURATION", (Object[])new Object[]{e.getMessage()});
                throw new KeyStoreException((Throwable)e);
            }
        }
        try {
            this.as = new AuditSigningImpl(this.signerKeyStoreId, this.signerKeyStoreLocation, null, null, null, this.signerAlias);
        }
        catch (AuditSigningException e) {
            void ase;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"687", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"FAILURE_INITIALIZING_SIGNING_CONFIGURATION", (Object[])new Object[]{ase.getMessage()});
            throw new AuditSigningException((Exception)ase);
        }
        try {
            this.signedSharedKey = this.as.generateSharedKey();
        }
        catch (Exception ase) {
            FFDCFilter.processException((Throwable)ase, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"697", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error generating key.", (Object[])new Object[]{e});
            }
            Tr.error((TraceComponent)tc, (String)"FAILURE_INITIALIZING_SIGNING_CONFIGURATION", (Object[])new Object[]{e.getMessage()});
            throw new AuditSigningException(e.getMessage(), (Exception)e);
        }
        try {
            this.signerCert = service.getX509CertificateFromKeyStore(this.signerKeyStoreId, this.signerAlias);
            this.publicSignerKey = this.signerCert.getPublicKey();
            this.privateSignerKey = service.getPrivateKeyFromKeyStore(this.signerKeyStoreId, this.signerAlias, null);
            this.encryptedSignerSharedKey = this.as.encryptSharedKey(this.signedSharedKey, this.publicSignerKey);
        }
        catch (IOException e) {
            void ioe;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"709", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"security.audit.keystore.open.error", (Object[])new Object[]{ioe});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{ioe.getMessage()});
            }
            Tr.error((TraceComponent)tc, (String)"FAILURE_INITIALIZING_SIGNING_CONFIGURATION", (Object[])new Object[]{ioe.getMessage()});
            throw new AuditSigningException(ioe.getMessage());
        }
        catch (CertificateException ioe) {
            void ce;
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"715", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception with certificate.", (Object[])new Object[]{ce.getMessage()});
            }
            Tr.error((TraceComponent)tc, (String)"INCORRECT_AUDIT_SIGNING_CONFIGURATION", (Object[])new Object[]{this.signerAlias, this.signerKeyStoreId});
            throw new AuditSigningException(ce.getMessage());
        }
        catch (KeyStoreException ce) {
            void ke;
            FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"720", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception with keystore.", (Object[])new Object[]{ke.getMessage()});
            }
            Tr.error((TraceComponent)tc, (String)"INCORRECT_AUDIT_ENCRYPTION_CONFIGURATION", (Object[])new Object[]{this.signerAlias, this.signerKeyStoreId});
            throw new AuditSigningException(ke.getMessage());
        }
        catch (Exception ke) {
            FFDCFilter.processException((Throwable)ke, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"725", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"security.audit.retrieve.signer.error", (Object[])new Object[]{e});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to retrieve the signer information.", (Object[])new Object[]{e.getMessage()});
            }
            Tr.error((TraceComponent)tc, (String)"FAILURE_INITIALIZING_SIGNING_CONFIGURATION", (Object[])new Object[]{e.getMessage()});
            throw new AuditSigningException(e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setEncryptionKeys() throws KeyStoreException, AuditEncryptionException {
        int MAX_RETRIES = 10;
        KeyStoreService service = null;
        if (this.getEncrypt().booleanValue()) {
            service = (KeyStoreService)this.keyStoreServiceRef.getService();
            for (int retries = 0; retries < 10; ++retries) {
                try {
                    this.encryptKeyStoreLocation = service.getKeyStoreLocation(this.encryptKeyStoreId);
                    break;
                }
                catch (KeyStoreException keyStoreException) {
                    FFDCFilter.processException((Throwable)keyStoreException, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"749", (Object)this, (Object[])new Object[0]);
                    if (retries == 9) {
                        void e;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exception with keystore.", (Object[])new Object[]{e.getMessage()});
                        }
                        Tr.error((TraceComponent)tc, (String)"FAILURE_INITIALIZING_ENCRYPTION_CONFIGURATION", (Object[])new Object[]{e.getMessage()});
                        throw new KeyStoreException((Throwable)e);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"758", (Object)this, (Object[])new Object[0]);
                    }
                    continue;
                }
            }
        }
        try {
            this.ae = new AuditEncryptionImpl(this.encryptKeyStoreId, this.encryptKeyStoreLocation, null, null, null, this.encryptAlias);
        }
        catch (AuditEncryptionException retries) {
            void aee;
            FFDCFilter.processException((Throwable)retries, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"768", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"FAILURE_INITIALIZING_ENCRYPTION_CONFIGURATION", (Object[])new Object[]{aee.getMessage()});
            throw new AuditEncryptionException((Exception)aee);
        }
        try {
            this.sharedKey = this.ae.generateSharedKey();
        }
        catch (Exception aee) {
            void e;
            FFDCFilter.processException((Throwable)aee, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"775", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error generating key.", (Object[])new Object[]{e});
            }
            Tr.error((TraceComponent)tc, (String)"FAILURE_INITIALIZING_ENCRYPTION_CONFIGURATION", (Object[])new Object[]{e.getMessage()});
            throw new AuditEncryptionException(e.getMessage(), (Exception)e);
        }
        this.sharedKeyAlias = this.ae.generateAliasForSharedKey();
        try {
            this.cert = service.getX509CertificateFromKeyStore(this.encryptKeyStoreId, this.encryptAlias);
            this.publicKey = this.cert.getPublicKey();
            this.encryptedSharedKey = this.ae.encryptSharedKey(this.sharedKey, this.publicKey);
        }
        catch (IOException e) {
            void ioe;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"789", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{ioe.getMessage()});
            }
            Tr.error((TraceComponent)tc, (String)"FAILURE_INITIALIZING_ENCRYPTION_CONFIGURATION", (Object[])new Object[]{ioe.getMessage()});
            throw new AuditEncryptionException(ioe.getMessage());
        }
        catch (CertificateException ioe) {
            void ce;
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"794", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception with certificate.", (Object[])new Object[]{ce.getMessage()});
            }
            Tr.error((TraceComponent)tc, (String)"INCORRECT_AUDIT_ENCRYPTION_CONFIGURATION", (Object[])new Object[]{this.encryptAlias, this.encryptKeyStoreId});
            throw new AuditEncryptionException(ce.getMessage());
        }
        catch (KeyStoreException ce) {
            void ke;
            FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"799", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception with keystore.", (Object[])new Object[]{ke.getMessage()});
            }
            Tr.error((TraceComponent)tc, (String)"INCORRECT_AUDIT_ENCRYPTION_CONFIGURATION", (Object[])new Object[]{this.encryptAlias, this.encryptKeyStoreId});
            throw new AuditEncryptionException(ke.getMessage());
        }
    }

    public String buildEncSignerHeader() {
        String header = null;
        if (this.getEncrypt().booleanValue()) {
            String encHeader;
            header = encHeader = this.buildEncryptionHeader();
        }
        if (this.getSign().booleanValue()) {
            String signHeader = this.buildSignerHeader();
            header = header != null ? header.concat(signHeader) : signHeader;
        }
        return header;
    }

    public String buildEncryptionHeader() {
        String header = null;
        byte[] certBytes = this.publicKey.toString().getBytes();
        header = encryptionOpenTag;
        header = header.concat(encryptedSharedKeyOpenTag);
        byte[] x = Base64Coder.base64Encode((byte[])this.encryptedSharedKey);
        header = header.concat(new String(x));
        header = header.concat(encryptedSharedKeyCloseTag);
        header = header.concat(encryptionCertAliasOpenTag);
        header = header.concat(this.encryptAlias);
        header = header.concat(encryptionCertAliasCloseTag);
        header = header.concat(encryptionKeyStoreOpenTag);
        header = header.concat(this.encryptKeyStoreLocation);
        header = header.concat(encryptionKeyStoreCloseTag);
        header = header.concat(encryptionCertificateOpenTag);
        header = header.concat(new String(certBytes));
        header = header.concat(newLine);
        header = header.concat(encryptionCertificateCloseTag);
        header = header.concat(encryptionCloseTag);
        return header;
    }

    public String buildSignerHeader() {
        String header = null;
        this.signerCertBytes = this.publicSignerKey.toString().getBytes();
        header = header == null ? signingOpenTag : header.concat(signingOpenTag);
        header = header.concat(signingSharedKeyOpenTag);
        byte[] x = Base64Coder.base64Encode((byte[])this.encryptedSignerSharedKey);
        header = header.concat(new String(x));
        header = header.concat(signingSharedKeyCloseTag);
        header = header.concat(signingCertAliasOpenTag);
        header = header.concat(this.signerAlias);
        header = header.concat(signingCertAliasCloseTag);
        header = header.concat(signingKeyStoreOpenTag);
        header = header.concat(this.signerKeyStoreLocation);
        header = header.concat(signingKeyStoreCloseTag);
        header = header.concat(signingCertificateOpenTag);
        header = header.concat(new String(this.signerCertBytes));
        header = header.concat(newLine);
        header = header.concat(signingCertificateCloseTag);
        header = header.concat(signingCloseTag);
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronousWrite(Object arg) {
        Object object = syncSeqNum;
        synchronized (object) {
            block48: {
                String header;
                if (this.getEncrypt().booleanValue() && !this.encryptHeaderEmitted) {
                    header = this.buildEncryptionHeader();
                    this.auditLog.writeRecord(header);
                    this.encryptHeaderEmitted = true;
                }
                if (this.getSign().booleanValue() && !this.signerHeaderEmitted) {
                    header = this.buildSignerHeader();
                    this.auditLog.writeRecord(header);
                    this.signerHeaderEmitted = true;
                }
                try {
                    String jsonEvent;
                    String eo;
                    String en;
                    AuditService auditService;
                    AuditEvent event = new AuditEvent();
                    GenericData gdo = (GenericData)arg;
                    for (KeyValuePair kvp : gdo.getPairs()) {
                        if (!(kvp instanceof KeyValueStringPair) || kvp.getKey().equals("ibm_datetime") || kvp.getKey().equals("ibm_sequence")) continue;
                        event.set(kvp.getKey(), (Object)kvp.getStringValue());
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Received event " + event), (Object[])new Object[]{this});
                    }
                    if ((auditService = (AuditService)this.auditServiceRef.getService()) == null || !auditService.isAuditRequired(en = (String)event.getMap().get("eventName"), eo = (String)event.getMap().get("outcome"))) break block48;
                    if (this.getEncrypt().booleanValue()) {
                        Object sclose;
                        jsonEvent = this.mapToJSONString(event.getMap());
                        byte[] er = null;
                        byte[] encryptedAuditRecord = null;
                        byte[] eventBytes = jsonEvent.getBytes("UTF-8");
                        String z = new String(eventBytes);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("eventBytes: " + z + "eventBytes.length: " + eventBytes.length), (Object[])new Object[0]);
                        }
                        er = this.ae.encrypt(eventBytes, this.sharedKey);
                        encryptedAuditRecord = new byte[er.length];
                        System.arraycopy(er, 0, encryptedAuditRecord, 0, er.length);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("length of er: " + er.length + " length of encryptedAuditRecord: " + encryptedAuditRecord.length), (Object[])new Object[0]);
                            Tr.debug((TraceComponent)tc, (String)("encryptedAuditRecord: " + new String(encryptedAuditRecord)), (Object[])new Object[0]);
                            Tr.debug((TraceComponent)tc, (String)("er: " + new String(er)), (Object[])new Object[0]);
                        }
                        if (this.getSign().booleanValue()) {
                            this.signedEncryptedAuditRecord = this.as.sign(er, this.signedSharedKey);
                            byte[] sopen = signatureOpenTag.getBytes();
                            sclose = signatureCloseTag.getBytes();
                            this.baos = new ByteArrayOutputStream(er.length + sopen.length + this.signedEncryptedAuditRecord.length + ((Object)sclose).length);
                            this.baos.write(er, 0, er.length);
                            this.baos.write(sopen, 0, sopen.length);
                            this.baos.write(this.signedEncryptedAuditRecord, 0, this.signedEncryptedAuditRecord.length);
                            this.baos.write((byte[])sclose, 0, ((Object)sclose).length);
                            this.mergedByteRecord = new byte[this.baos.toByteArray().length];
                            this.mergedByteRecord = this.baos.toByteArray();
                            byte[] tmpPrivate = Base64Coder.base64Encode((byte[])this.mergedByteRecord);
                            Object object2 = syncObject;
                            synchronized (object2) {
                                long total_to_add_length = begin.getBytes().length + tmpPrivate.length + end.getBytes().length;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("total_to_add_length: " + total_to_add_length), (Object[])new Object[0]);
                                }
                                long currentFileSize = this.auditLog.getCurrentCountStream();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("currentFileSize: " + currentFileSize), (Object[])new Object[0]);
                                }
                                if (currentFileSize != 0L) {
                                    if (this.getMaxFileSize() != 0) {
                                        long max = (long)this.getMaxFileSize().intValue() * 1024L * 1024L;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("maxFileSize: " + max), (Object[])new Object[0]);
                                        }
                                        if (currentFileSize + total_to_add_length >= max) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)"adding padding to roll into new log", (Object[])new Object[0]);
                                            }
                                            byte[] padding = new byte[(int)(max - currentFileSize)];
                                            this.auditLog.writeRecord(padding, this.buildEncSignerHeader());
                                        }
                                    }
                                    this.auditLog.writeRecord(begin);
                                    this.auditLog.writeRecord(tmpPrivate, this.buildEncSignerHeader());
                                    this.auditLog.writeRecord(end);
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("mergedByteRecord: " + new String(tmpPrivate)), (Object[])new Object[0]);
                            }
                        } else {
                            byte[] tmpPrivate = Base64Coder.base64Encode((byte[])er);
                            sclose = syncObject;
                            synchronized (sclose) {
                                long total_to_add_length = begin.getBytes().length + tmpPrivate.length + end.getBytes().length;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("total_to_add_length: " + total_to_add_length), (Object[])new Object[0]);
                                }
                                long currentFileSize = this.auditLog.getCurrentCountStream();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("currentFileSize: " + currentFileSize), (Object[])new Object[0]);
                                }
                                if (currentFileSize != 0L) {
                                    if (this.getMaxFileSize() != 0) {
                                        long max = (long)this.getMaxFileSize().intValue() * 1024L * 1024L;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("maxFileSize: " + max), (Object[])new Object[0]);
                                        }
                                        if (currentFileSize + total_to_add_length >= max) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)"adding padding to roll into new log", (Object[])new Object[0]);
                                            }
                                            byte[] padding = new byte[(int)(max - currentFileSize)];
                                            this.auditLog.writeRecord(padding, this.buildEncSignerHeader());
                                        }
                                    }
                                    this.auditLog.writeRecord(begin);
                                    this.auditLog.writeRecord(tmpPrivate, this.buildEncSignerHeader());
                                    this.auditLog.writeRecord(end);
                                }
                            }
                        }
                    }
                    if (this.getSign().booleanValue() && !this.getEncrypt().booleanValue()) {
                        jsonEvent = this.mapToJSONString(event.getMap());
                        byte[] eventBytes = jsonEvent.getBytes("UTF-8");
                        this.signedAuditRecord = this.as.sign(eventBytes, this.signedSharedKey);
                        byte[] sopen = signatureOpenTag.getBytes();
                        byte[] sclose = signatureCloseTag.getBytes();
                        this.baos = new ByteArrayOutputStream(eventBytes.length + sopen.length + this.signedAuditRecord.length + sclose.length);
                        this.baos.write(eventBytes, 0, eventBytes.length);
                        this.baos.write(sopen, 0, sopen.length);
                        this.baos.write(this.signedAuditRecord, 0, this.signedAuditRecord.length);
                        this.baos.write(sclose, 0, sclose.length);
                        this.mergedByteRecord = new byte[this.baos.toByteArray().length];
                        this.mergedByteRecord = this.baos.toByteArray();
                        byte[] tmpPrivate = Base64Coder.base64Encode((byte[])this.mergedByteRecord);
                        Object object3 = syncObject;
                        synchronized (object3) {
                            long total_to_add_length = begin.getBytes().length + tmpPrivate.length + end.getBytes().length;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("total_to_add_length: " + total_to_add_length), (Object[])new Object[0]);
                            }
                            long currentFileSize = this.auditLog.getCurrentCountStream();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("currentFileSize: " + currentFileSize), (Object[])new Object[0]);
                            }
                            if (currentFileSize != 0L) {
                                if (this.getMaxFileSize() != 0) {
                                    long max = (long)this.getMaxFileSize().intValue() * 1024L * 1024L;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("maxFileSize: " + max), (Object[])new Object[0]);
                                    }
                                    if (currentFileSize + total_to_add_length >= max) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"adding padding to roll into new log", (Object[])new Object[0]);
                                        }
                                        byte[] padding = new byte[(int)(max - currentFileSize)];
                                        this.auditLog.writeRecord(padding, this.buildEncSignerHeader());
                                    }
                                }
                                this.auditLog.writeRecord(begin);
                                this.auditLog.writeRecord(tmpPrivate, this.buildEncSignerHeader());
                                this.auditLog.writeRecord(end);
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("mergedByteRecord: " + new String(tmpPrivate)), (Object[])new Object[0]);
                        }
                    }
                    if (!this.getEncrypt().booleanValue() && !this.getSign().booleanValue()) {
                        this.auditLog.writeRecord(this.mapToJSONString(event.getMap()));
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"1104", (Object)this, (Object[])new Object[]{arg});
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getKeyStoreId(String keyStoreRef) {
        if (keyStoreRef == null || keyStoreRef.isEmpty()) {
            return null;
        }
        Configuration config = null;
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
        try {
            if (configAdmin != null) {
                config = configAdmin.getConfiguration(keyStoreRef, this.bundleLocation);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.audit.file.AuditFileHandler", (String)"1118", (Object)this, (Object[])new Object[]{keyStoreRef});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Invalid authFilterRef configuration", (Object[])new Object[]{e.getMessage()});
            }
            return null;
        }
        if (config == null) {
            return null;
        }
        Dictionary props = config.getProperties();
        if (props == null) {
            return null;
        }
        String id = (String)props.get(KEY_ID);
        return id;
    }
}

