/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Objects;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.CodeSetInfo;
import org.apache.yoko.orb.OB.CodeSetReader;
import org.apache.yoko.orb.OB.CodeSetWriter;
import org.apache.yoko.orb.OB.FixedWidth2Reader;
import org.apache.yoko.orb.OB.FixedWidth2Writer;
import org.apache.yoko.orb.OB.UTF16Reader;
import org.apache.yoko.orb.OB.UTF16Writer;
import org.apache.yoko.orb.OB.UTF8Reader;
import org.apache.yoko.orb.OB.UTF8Writer;
import org.apache.yoko.orb.OCI.ReadBuffer;
import org.apache.yoko.orb.OCI.WriteBuffer;
import org.omg.CORBA.DATA_CONVERSION;

public abstract class CodeConverterBase {
    private final CodeSetInfo sourceCodeSet;
    private final CodeSetInfo destinationCodeSet;
    private final CodeSetReader reader_;
    private final CodeSetWriter writer_;

    CodeConverterBase(CodeSetInfo source, CodeSetInfo destination) {
        if (source == null) {
            source = CodeSetInfo.NONE;
        }
        if (destination == null) {
            destination = CodeSetInfo.NONE;
        }
        this.sourceCodeSet = source;
        this.destinationCodeSet = destination;
        if (source == CodeSetInfo.UTF_8) {
            this.reader_ = new UTF8Reader();
        } else if (source == CodeSetInfo.UTF_16) {
            this.reader_ = new UTF16Reader();
        } else if (source.max_bytes <= 2) {
            this.reader_ = new FixedWidth2Reader();
        } else {
            throw Assert.fail("Yoko doesn't support wide characters larger than 16 bit");
        }
        if (destination == CodeSetInfo.UTF_8) {
            this.writer_ = new UTF8Writer();
        } else if (destination == CodeSetInfo.UTF_16) {
            this.writer_ = new UTF16Writer();
        } else if (destination.max_bytes <= 2) {
            this.writer_ = new FixedWidth2Writer();
        } else {
            throw Assert.fail("Yoko doesn't support wide characters larger than 16 bit");
        }
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof CodeConverterBase && this.equals((CodeConverterBase)other);
    }

    private boolean equals(CodeConverterBase that) {
        return this.sourceCodeSet == that.sourceCodeSet && this.destinationCodeSet == that.destinationCodeSet;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceCodeSet, this.destinationCodeSet});
    }

    public final char read_char(ReadBuffer readBuffer) throws DATA_CONVERSION {
        return this.reader_.read_char(readBuffer);
    }

    public char read_wchar(ReadBuffer readBuffer, int len) throws DATA_CONVERSION {
        return this.reader_.read_wchar(readBuffer, len);
    }

    public void write_char(WriteBuffer writeBuffer, char v) throws DATA_CONVERSION {
        this.writer_.write_char(writeBuffer, v);
    }

    public void write_wchar(WriteBuffer writeBuffer, char v) throws DATA_CONVERSION {
        this.writer_.write_wchar(writeBuffer, v);
    }

    public int read_count_wchar(char v) {
        return this.reader_.count_wchar(v);
    }

    public int write_count_wchar(char v) {
        return this.writer_.count_wchar(v);
    }

    public final boolean readerRequired() {
        return this.sourceCodeSet == CodeSetInfo.UTF_8 || this.sourceCodeSet == CodeSetInfo.UTF_16;
    }

    public final boolean writerRequired() {
        return this.destinationCodeSet == CodeSetInfo.UTF_8 || this.destinationCodeSet == CodeSetInfo.UTF_16;
    }

    public final CodeSetInfo getSourceCodeSet() {
        return this.sourceCodeSet;
    }

    public final CodeSetInfo getDestinationCodeSet() {
        return this.destinationCodeSet;
    }

    public final void set_reader_flags(int flags) {
        this.reader_.set_flags(flags);
    }

    public final void set_writer_flags(int flags) {
        this.writer_.set_flags(flags);
    }

    public abstract boolean conversionRequired();

    public abstract char convert(char var1);
}

