/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.plugins.OAuth20TokenImpl;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Logger;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
public class CacheEntry
implements Serializable {
    private static transient TraceComponent tc = Tr.register(CacheEntry.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    static final transient String CLASS = CacheEntry.class.getName();
    private transient Logger _log;
    private static final long serialVersionUID = 5802154139964139458L;
    public long _expiryTime;
    public OAuth20Token _token;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public CacheEntry(OAuth20Token token, int lifetime) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{token, lifetime});
        }
        this._log = Logger.getLogger(CLASS);
        this._token = !(token instanceof Serializable) ? new OAuth20TokenImpl(token) : token;
        this._expiryTime = new Date().getTime() + (long)lifetime * 1000L;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OAuth20Token CacheEntry:" + this._token + " will expire at:" + this._expiryTime));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean isExpired() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isExpired", (Object)new Object[0]);
        }
        Date now = new Date();
        long nowTime = now.getTime();
        if (nowTime >= this._expiryTime && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("token: " + this._token + " expired"));
        }
        boolean bl = nowTime >= this._expiryTime;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((TraceComponent)tc, (String)"isExpired", (Object)bl);
        }
        return bl;
    }
}

