/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsMessageFactory;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.MessageType;
import com.ibm.ws.sib.mfp.WebJsMessageEncoder;
import com.ibm.ws.sib.mfp.control.SubscriptionMessage;
import com.ibm.ws.sib.mfp.impl.JsHdrsImpl;
import com.ibm.ws.sib.mfp.impl.JsJmsMessageFactoryImpl;
import com.ibm.ws.sib.mfp.impl.JsJmsMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.impl.MFPUnsupportedEncodingRuntimeException;
import com.ibm.ws.sib.mfp.impl.SubscriptionMessageImpl;
import com.ibm.ws.sib.mfp.impl.TrmMessageFactoryImpl;
import com.ibm.ws.sib.mfp.impl.TrmMessageImpl;
import com.ibm.ws.sib.mfp.trm.TrmMessage;
import com.ibm.ws.sib.mfp.trm.TrmMessageFactory;
import com.ibm.ws.sib.mfp.util.HexUtil;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.UnsupportedEncodingException;
import java.util.List;

class JsMessageImpl
extends JsHdrsImpl
implements JsMessage,
MatchSpaceKey {
    private static final TraceComponent tc = SibTr.register(JsMessageImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final long serialVersionUID = 1L;
    private static final JsJmsMessageFactoryImpl jmsFactory = JsMessageImpl.getJmsFactory();
    private static final TrmMessageFactoryImpl trmFactory = JsMessageImpl.getTrmFactory();
    static final int FLUFFED_OBJECT_OVERHEAD;
    static final int FLUFFED_STRING_OVERHEAD;
    static final int FLUFFED_REF_SIZE;
    private static final int FLUFFED_MFP_MESSAGE_SIZE;
    static final int FLUFFED_JMF_MESSAGE_SIZE;
    static final int FLUFFED_JSMSGPART_SIZE;
    static final int FLUFFED_JMF_LIST_SIZE;
    static final int FLUFFED_MAP_OVERHEAD;
    static final int FLUFFED_MAP_ENTRY_SIZE;
    private static final int FLUFFED_HEADER_BASE_SIZE;
    private transient int approxLength = -1;
    private transient int fluffedSize = -1;

    private static JsJmsMessageFactoryImpl getJmsFactory() {
        try {
            return (JsJmsMessageFactoryImpl)JsJmsMessageFactory.getInstance();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMessageImpl.getJmsFactory", (String)"jsm101");
            return null;
        }
    }

    private static TrmMessageFactoryImpl getTrmFactory() {
        try {
            return (TrmMessageFactoryImpl)TrmMessageFactory.getInstance();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMessageImpl.getTrmFactory", (String)"jsm102");
            return null;
        }
    }

    static byte[] flattenClassName(String className) {
        byte[] flattened;
        try {
            flattened = className.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsSdoMessageImpl.<clinit>", (String)"50");
            flattened = className.getBytes();
        }
        return flattened;
    }

    JsMessageImpl() {
    }

    JsMessageImpl(int flag) throws MessageDecodeFailedException {
        super(flag);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    JsMessageImpl(JsMsgObject inJmo) {
        super(inJmo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>, inbound jmo ");
        }
        if (inJmo.getOriginalLength() != 0) {
            this.approxLength = inJmo.getOriginalLength();
        }
    }

    @Override
    public final JsJmsMessage makeInboundJmsMessage() throws IncorrectMessageTypeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"makeInboundJmsMessage");
        }
        JsJmsMessageImpl jmsMessage = null;
        if (this instanceof JsJmsMessageImpl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Incoming message is already a JsJmsMessage");
            }
            jmsMessage = (JsJmsMessageImpl)this;
        } else if (this.getJsMessageType() == MessageType.JMS) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Incoming message has MessageType of JMS");
            }
            this.updateDataFields(4);
            jmsMessage = (JsJmsMessageImpl)jmsFactory.createInboundJmsMessage(this.jmo, this.getSubtype());
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Not a JMS Message");
            }
            String exString = nls.getFormattedMessage("UNEXPECTED_MESSAGE_TYPE_CWSIF0102", new Object[]{this.getJsMessageType(), MessageType.JMS}, "The Message can not be represented as JMS Message");
            throw new IncorrectMessageTypeException(exString);
        }
        jmsMessage.setDerivedJmsFields();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"makeInboundJmsMessage");
        }
        return jmsMessage;
    }

    @Override
    public final TrmMessage makeInboundTrmMessage() throws IncorrectMessageTypeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"makeInboundTrmMessage");
        }
        TrmMessage trmMessage = null;
        if (this instanceof TrmMessageImpl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Incoming message is already a TrmMessage");
            }
            trmMessage = (TrmMessageImpl)this;
        } else if (this.getJsMessageType() == MessageType.TRM) {
            this.updateDataFields(5);
            trmMessage = trmFactory.createInboundTrmMessage(this.jmo, this.getSubtype());
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Not a TRM Message");
            }
            String exString = nls.getFormattedMessage("UNEXPECTED_MESSAGE_TYPE_CWSIF0102", new Object[]{this.getJsMessageType(), MessageType.TRM}, "The Message is not a TRM Message");
            throw new IncorrectMessageTypeException(exString);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"makeInboundTrmMessage");
        }
        return trmMessage;
    }

    @Override
    public final SubscriptionMessage makeInboundSubscriptionMessage() throws IncorrectMessageTypeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"makeInboundSubscriptionMessage");
        }
        SubscriptionMessageImpl subMessage = null;
        if (this instanceof SubscriptionMessageImpl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Incoming message is already a SubscriptionMessage");
            }
            subMessage = (SubscriptionMessageImpl)this;
        } else if (this.getJsMessageType() == MessageType.SUBSCRIPTION) {
            this.updateDataFields(5);
            subMessage = new SubscriptionMessageImpl(this.jmo);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Not a SUBSCRIPTION Message");
            }
            String exString = nls.getFormattedMessage("UNEXPECTED_MESSAGE_TYPE_CWSIF0102", new Object[]{this.getJsMessageType(), MessageType.SUBSCRIPTION}, "The Message is not a SUBSCRIPTION Message");
            throw new IncorrectMessageTypeException(exString);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"makeInboundSubscriptionMessage");
        }
        return subMessage;
    }

    @Override
    public JsMessage getSent(boolean copy) throws MessageCopyFailedException {
        JsMessageImpl newMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSent", (Object)copy);
        }
        if (copy) {
            newMsg = this.createNew();
            this.clearCachedLengths();
        } else {
            newMsg = this;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSent", (Object)newMsg);
        }
        return newMsg;
    }

    @Override
    public final JsMessage getReceived() throws MessageCopyFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReceived");
        }
        JsMessageImpl newMsg = this.createNew();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReceived", (Object)newMsg);
        }
        return newMsg;
    }

    @Override
    public final List<DataSlice> encodeFast(Object conn) throws MessageEncodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"encode");
        }
        return this.jmo.encodeFast(conn);
    }

    @Override
    public JsMessage transcribeToJmf() throws MessageCopyFailedException, IncorrectMessageTypeException, UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"transcribeToJmf");
        }
        JsMsgObject newJmo = null;
        try {
            if (this instanceof JsJmsMessageImpl) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Transcribing from JsJmsMessageImpl");
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Non-JMS Messages are not yet supported");
                }
                String exString = nls.getFormattedMessage("UNEXPECTED_MESSAGE_TYPE_CWSIF0102", new Object[]{this.getJsMessageType(), MessageType.JMS}, "The Message can not be represented as a pure JMF Message");
                throw new IncorrectMessageTypeException(exString);
            }
            newJmo = this.jmo.transcribeToJmf();
        }
        catch (MFPUnsupportedEncodingRuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMessageImpl.transcribeToJmf", (String)"721");
            throw (UnsupportedEncodingException)e.getCause();
        }
        JsMessageImpl newMsg = newJmo != this.jmo ? this.createNewGeneralized(newJmo) : this;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"transcribeToJmf", (Object)newMsg);
        }
        return newMsg;
    }

    @Override
    public final List<DataSlice> flatten(Object store) throws MessageEncodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"flatten");
        }
        List<DataSlice> slices = null;
        try {
            slices = this.jmo.flatten(store, this.getFlattenedClassName());
        }
        catch (MessageEncodeFailedException e) {
            Throwable e1;
            for (e1 = e.getCause(); e1 != null && !(e1 instanceof UnsupportedEncodingException); e1 = e1.getCause()) {
            }
            if (e1 != null) {
                try {
                    JsMessageImpl tempMsg = (JsMessageImpl)this.transcribeToJmf();
                    slices = tempMsg.jmo.flatten(store, this.getFlattenedClassName());
                }
                catch (Exception newe) {
                    if (newe instanceof MessageEncodeFailedException) {
                        throw (MessageEncodeFailedException)newe;
                    }
                    throw new MessageEncodeFailedException(newe);
                }
            }
            throw e;
        }
        int temp = 0;
        for (int i = 0; i < slices.size(); ++i) {
            temp += slices.get(i).getLength();
        }
        this.approxLength = temp;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"flatten");
        }
        return slices;
    }

    @Override
    public int getApproximateLength() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getApproximateLength");
        }
        if (this.approxLength == -1) {
            this.approxLength = this.guessApproxLength();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getApproximateLength", (Object)this.approxLength);
        }
        return this.approxLength;
    }

    @Override
    public int getInMemorySize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getInMemorySize");
        }
        if (this.fluffedSize == -1) {
            this.fluffedSize = this.guessFluffedSize();
        }
        int inMemorySize = this.getApproximateLength() + this.fluffedSize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getInMemorySize", (Object)inMemorySize);
        }
        return inMemorySize;
    }

    @Override
    public WebJsMessageEncoder getWebEncoder() {
        throw new UnsupportedOperationException();
    }

    void clearCachedLengths() {
        this.setApproximateLength(-1);
        this.setFluffedSize(-1);
    }

    final void setApproximateLength(int length) {
        this.approxLength = length;
    }

    final void setFluffedSize(int size) {
        this.fluffedSize = size;
    }

    int guessApproxLength() {
        List rrp;
        List frp;
        int total = 400;
        int size = 0;
        if (this.getHdr2().isNotEMPTYlist(0) && (frp = (List)this.getHdr2().getField(0)) != null) {
            size += frp.size();
        }
        if (this.getHdr2().isNotEMPTYlist(4) && (rrp = (List)this.getHdr2().getField(4)) != null) {
            size += rrp.size();
        }
        if (size > 0) {
            total += size * 50;
        }
        return total += 77;
    }

    int guessFluffedSize() {
        int total = FLUFFED_HEADER_BASE_SIZE;
        int listSize = this.getHdr2().estimateFieldValueSize(0);
        total += listSize * 3;
        listSize = this.getHdr2().estimateFieldValueSize(4);
        total += listSize * 3;
        if (this.getHdr2().getChoiceField(72) == 1) {
            total += 350;
        }
        if (this.getHdr2().getChoiceField(74) == 1) {
            total += 100;
        }
        if (this.getHdr2().getChoiceField(75) == 1) {
            total += 200;
        }
        if (this.getHdr2().getChoiceField(76) == 1) {
            total += 100;
        }
        if (this.getHdr2().getChoiceField(77) == 1) {
            total += 180;
        }
        return total;
    }

    @Override
    public Object getIdentifierValue(Identifier id, boolean ignoreType) throws BadMessageFormatMatchingException {
        throw new BadMessageFormatMatchingException(nls.getFormattedMessage("NOT_API_MESSAGE_CWSIF0101", new Object[]{this.getSystemMessageId()}, "Message selectors are not supported for message " + this.getSystemMessageId()));
    }

    @Override
    public Object getIdentifierValue(Identifier id, boolean ignoreType, Object contextValue, boolean returnList) throws BadMessageFormatMatchingException {
        throw new BadMessageFormatMatchingException(nls.getFormattedMessage("NOT_API_MESSAGE_CWSIF0101", new Object[]{this.getSystemMessageId()}, "Message selectors are not supported for message " + this.getSystemMessageId()));
    }

    @Override
    public Object getRootContext() throws BadMessageFormatMatchingException {
        throw new BadMessageFormatMatchingException(nls.getFormattedMessage("NOT_API_MESSAGE_CWSIF0101", new Object[]{this.getSystemMessageId()}, "Message selectors are not supported for message " + this.getSystemMessageId()));
    }

    public String toString() {
        return super.toString() + "{SysMsgId=" + this.getSystemMessageId() + "}";
    }

    byte[] getFlattenedClassName() {
        return JsMessageImpl.flattenClassName(this.getClass().getName());
    }

    private final JsMessageImpl createNew() throws MessageCopyFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createNew");
        }
        JsMessageImpl newMsg = null;
        Class<?> msgClass = this.getClass();
        try {
            newMsg = (JsMessageImpl)msgClass.newInstance();
            this.copyTransients(newMsg);
            JsMsgObject newJmo = this.jmo.getCopy();
            newMsg.setJmo(newJmo);
        }
        catch (IllegalAccessException e1) {
            FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.mfp.impl.JsMessageImpl.createNew", (String)"jsm1600");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("IllegalAccessException " + e1.getMessage() + " instantiating class " + msgClass.getName()));
            }
            throw new MessageCopyFailedException(e1);
        }
        catch (InstantiationException e2) {
            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.mfp.impl.JsMessageImpl.createNew", (String)"jsm1610");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("InstantiationException " + e2.getMessage() + " instantiating class " + msgClass.getName()));
            }
            throw new MessageCopyFailedException(e2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createNew", (Object)newMsg);
        }
        return newMsg;
    }

    private final JsMessageImpl createNewGeneralized(JsMsgObject newJmo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createNewGeneralized");
        }
        JsMessageImpl newMsg = null;
        newMsg = new JsMessageImpl(newJmo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createNewGeneralized", (Object)newMsg);
        }
        return newMsg;
    }

    void copyTransients(JsMessageImpl copy) {
        super.copyTransients(copy);
        copy.setApproximateLength(this.approxLength);
        copy.setFluffedSize(this.fluffedSize);
    }

    @Override
    public void getTraceSummaryLine(StringBuilder buff) {
        buff.append("MESSAGE:");
        buff.append("type=");
        buff.append(this.getJsMessageType());
        buff.append(",id=");
        buff.append(this.getSystemMessageId());
        buff.append(",proto=");
        buff.append(this.getGuaranteedProtocolType());
        buff.append(",tick=");
        buff.append(this.getGuaranteedValueValueTick());
    }

    protected void appendList(StringBuilder buff, String name, List list) {
        buff.append(',');
        buff.append(name);
        buff.append("=[");
        if (list != null) {
            Object[] items = list.toArray();
            for (int i = 0; i < items.length; ++i) {
                if (i != 0) {
                    buff.append(',');
                }
                if (items[i] instanceof byte[]) {
                    buff.append(HexUtil.toString((byte[])items[i]));
                    continue;
                }
                buff.append(items[i]);
            }
        }
        buff.append(']');
    }

    static {
        boolean is64bit = RuntimeInfo.is64bit();
        if (!is64bit) {
            FLUFFED_OBJECT_OVERHEAD = 12;
            FLUFFED_STRING_OVERHEAD = 32;
            FLUFFED_REF_SIZE = 4;
            FLUFFED_JMF_MESSAGE_SIZE = 72;
            FLUFFED_MFP_MESSAGE_SIZE = 96;
            FLUFFED_JSMSGPART_SIZE = 16;
            FLUFFED_JMF_LIST_SIZE = 72;
        } else {
            FLUFFED_OBJECT_OVERHEAD = 24;
            FLUFFED_STRING_OVERHEAD = 48;
            FLUFFED_REF_SIZE = 8;
            FLUFFED_JMF_MESSAGE_SIZE = 136;
            FLUFFED_MFP_MESSAGE_SIZE = 112;
            FLUFFED_JSMSGPART_SIZE = 32;
            FLUFFED_JMF_LIST_SIZE = 136;
        }
        FLUFFED_MAP_OVERHEAD = FLUFFED_OBJECT_OVERHEAD + FLUFFED_REF_SIZE * 2 + FLUFFED_JMF_LIST_SIZE * 2;
        FLUFFED_MAP_ENTRY_SIZE = FLUFFED_STRING_OVERHEAD + FLUFFED_OBJECT_OVERHEAD + 50;
        int size = FLUFFED_MFP_MESSAGE_SIZE + FLUFFED_OBJECT_OVERHEAD + FLUFFED_REF_SIZE * 3 + 4 + FLUFFED_JSMSGPART_SIZE * 3 + FLUFFED_JMF_MESSAGE_SIZE * 3;
        size += FLUFFED_REF_SIZE * 10;
        size += FLUFFED_OBJECT_OVERHEAD * 5 + 120;
        size += FLUFFED_REF_SIZE * 62;
        FLUFFED_HEADER_BASE_SIZE = size += FLUFFED_OBJECT_OVERHEAD * 13 + 300;
    }
}

