/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Date;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.ClassDesc;
import org.apache.yoko.rmi.impl.AbstractObjectDescriptor;
import org.apache.yoko.rmi.impl.AnyDescriptor;
import org.apache.yoko.rmi.impl.ArrayDescriptor;
import org.apache.yoko.rmi.impl.BooleanDescriptor;
import org.apache.yoko.rmi.impl.ByteDescriptor;
import org.apache.yoko.rmi.impl.CharDescriptor;
import org.apache.yoko.rmi.impl.ClassDescDescriptor;
import org.apache.yoko.rmi.impl.ClassDescriptor;
import org.apache.yoko.rmi.impl.DateValueDescriptor;
import org.apache.yoko.rmi.impl.DoubleDescriptor;
import org.apache.yoko.rmi.impl.EnumDescriptor;
import org.apache.yoko.rmi.impl.EnumSubclassDescriptor;
import org.apache.yoko.rmi.impl.ExceptionDescriptor;
import org.apache.yoko.rmi.impl.FVDEnumDescriptor;
import org.apache.yoko.rmi.impl.FVDEnumSubclassDescriptor;
import org.apache.yoko.rmi.impl.FVDValueDescriptor;
import org.apache.yoko.rmi.impl.FloatDescriptor;
import org.apache.yoko.rmi.impl.IDLEntityDescriptor;
import org.apache.yoko.rmi.impl.IntegerDescriptor;
import org.apache.yoko.rmi.impl.LongDescriptor;
import org.apache.yoko.rmi.impl.RemoteClassDescriptor;
import org.apache.yoko.rmi.impl.RemoteInterfaceDescriptor;
import org.apache.yoko.rmi.impl.ShortDescriptor;
import org.apache.yoko.rmi.impl.StringDescriptor;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.ValueDescriptor;
import org.apache.yoko.rmi.impl.VoidDescriptor;
import org.apache.yoko.rmi.util.SearchKey;
import org.apache.yoko.rmi.util.WeakKey;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.ValueDefPackage.FullValueDescription;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.SendingContext.CodeBase;
import org.omg.SendingContext.CodeBaseHelper;
import org.omg.SendingContext.RunTime;

public class TypeRepository {
    static final Logger logger = Logger.getLogger(TypeRepository.class.getName());
    private final TypeDescriptorCache repIdDescriptors;
    private final LocalDescriptors localDescriptors;
    private final FvdRepIdDescriptorMaps fvdDescMaps = new FvdRepIdDescriptorMaps();
    private final ConcurrentMap<String, ValueDescriptor> noTypeDescMap = new ConcurrentHashMap<String, ValueDescriptor>();
    private static final Set<Class<?>> initTypes = TypeRepository.createClassSet(java.lang.Object.class, String.class, ClassDesc.class, Date.class, Externalizable.class, Serializable.class, Remote.class);

    private static Set<Class<?>> createClassSet(Class<?> ... types) {
        return Collections.unmodifiableSet(new HashSet(Arrays.asList(types)));
    }

    private TypeRepository() {
        this.repIdDescriptors = new TypeDescriptorCache();
        this.localDescriptors = new LocalDescriptors(this, this.repIdDescriptors);
        for (Class<?> type : initTypes) {
            this.localDescriptors.get(type);
        }
    }

    public static TypeRepository get() {
        return RepoHolder.value;
    }

    public String getRepositoryID(Class<?> type) {
        return this.getDescriptor(type).getRepositoryID();
    }

    public RemoteInterfaceDescriptor getRemoteInterface(Class<?> type) {
        return this.getDescriptor(type).getRemoteInterface();
    }

    public TypeDescriptor getDescriptor(Class<?> type) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Requesting type descriptor for class \"%s\"", type.getName()));
        }
        TypeDescriptor desc = (TypeDescriptor)this.localDescriptors.get(type);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Class \"%s\" resolves to %s", type.getName(), desc));
        }
        return desc;
    }

    public TypeDescriptor getDescriptor(String repId) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Requesting type descriptor for repId \"%s\"", repId));
        }
        TypeDescriptor desc = this.repIdDescriptors.get(repId);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("RepId \"%s\" resolves to %s", repId, desc));
        }
        return desc;
    }

    public ValueDescriptor getDescriptor(Class<?> clz, String repid, RunTime runtime) throws ClassNotFoundException {
        ValueDescriptor newDesc;
        ConcurrentMap remoteDescMap;
        if (repid == null) {
            return (ValueDescriptor)this.getDescriptor(clz);
        }
        ValueDescriptor clzdesc = (ValueDescriptor)this.repIdDescriptors.get(repid, clz);
        if (clzdesc != null) {
            return clzdesc;
        }
        if (clz != null) {
            logger.fine("Requesting type descriptor for class " + clz.getName() + " with repid " + repid);
            if (clz.isArray()) {
                return (ValueDescriptor)this.localDescriptors.get(clz);
            }
            clzdesc = (ValueDescriptor)this.getDescriptor(clz);
            String localID = clzdesc.getRepositoryID();
            if (repid.equals(localID)) {
                return clzdesc;
            }
        }
        logger.fine("Requesting type descriptor for repid " + repid);
        CodeBase codebase = CodeBaseHelper.narrow((Object)runtime);
        if (codebase == null) {
            throw new MARSHAL("cannot locate RunTime CodeBase");
        }
        FullValueDescription fvd = codebase.meta(repid);
        ValueDescriptor super_desc = null;
        if (!"".equals(fvd.base_value)) {
            super_desc = this.getDescriptor(clz == null ? null : clz.getSuperclass(), fvd.base_value, (RunTime)codebase);
        }
        if ((clzdesc = (remoteDescMap = clz == null ? this.noTypeDescMap : (ConcurrentMap)this.fvdDescMaps.get(clz)).putIfAbsent((newDesc = super_desc != null && super_desc.isEnum() ? new FVDEnumSubclassDescriptor(fvd, clz, this, repid, super_desc) : (fvd.id.startsWith("RMI:java.lang.Enum:") ? new FVDEnumDescriptor(fvd, clz, this, repid, super_desc) : new FVDValueDescriptor(fvd, clz, this, repid, super_desc))).getRepositoryID(), newDesc)) == null) {
            clzdesc = newDesc;
            this.repIdDescriptors.put(clzdesc);
        }
        return clzdesc;
    }

    private static enum RepoHolder {

        static final TypeRepository value = new TypeRepository();
    }

    private static final class FvdRepIdDescriptorMaps
    extends ClassValue<ConcurrentMap<String, ValueDescriptor>> {
        private FvdRepIdDescriptorMaps() {
        }

        @Override
        protected ConcurrentMap<String, ValueDescriptor> computeValue(Class<?> type) {
            return new ConcurrentHashMap<String, ValueDescriptor>(1);
        }
    }

    private static final class LocalDescriptors
    extends ClassValue<TypeDescriptor> {
        private final Raw rawValues;
        private final TypeDescriptorCache repIdDescriptors;

        LocalDescriptors(TypeRepository repo, TypeDescriptorCache repIdDescriptors) {
            this.rawValues = new Raw(repo);
            this.repIdDescriptors = repIdDescriptors;
        }

        @Override
        protected synchronized TypeDescriptor computeValue(Class<?> type) {
            TypeDescriptor desc = (TypeDescriptor)this.rawValues.get(type);
            if (desc.doInitOnce()) {
                this.repIdDescriptors.put(desc);
            }
            return desc;
        }

        private static final class Raw
        extends ClassValue<TypeDescriptor> {
            private static final List<Class<?>> staticAnyTypes = Collections.unmodifiableList(Arrays.asList(java.lang.Object.class, Externalizable.class, Serializable.class, Remote.class));
            private final TypeRepository repo;

            Raw(TypeRepository repo) {
                this.repo = repo;
            }

            @Override
            protected TypeDescriptor computeValue(Class<?> type) {
                if (type.isPrimitive()) {
                    return this.primitiveDescriptor(type);
                }
                if (type == String.class) {
                    return new StringDescriptor(this.repo);
                }
                if (type == Class.class) {
                    return new ClassDescriptor(this.repo);
                }
                if (type == ClassDesc.class) {
                    return new ClassDescDescriptor(this.repo);
                }
                if (type == java.util.Date.class) {
                    return new DateValueDescriptor(this.repo);
                }
                if (staticAnyTypes.contains(type)) {
                    return new AnyDescriptor(type, this.repo);
                }
                if (IDLEntity.class.isAssignableFrom(type) && Raw.isIDLEntity(type)) {
                    return new IDLEntityDescriptor(type, this.repo);
                }
                if (Throwable.class.isAssignableFrom(type)) {
                    return new ExceptionDescriptor(type, this.repo);
                }
                if (Enum.class == type) {
                    return new EnumDescriptor(type, this.repo);
                }
                if (Enum.class.isAssignableFrom(type)) {
                    Class<?> enumType = EnumSubclassDescriptor.getEnumType(type);
                    return enumType == type ? new EnumSubclassDescriptor(type, this.repo) : (TypeDescriptor)this.get(enumType);
                }
                if (type.isArray()) {
                    return ArrayDescriptor.get(type, this.repo);
                }
                if (!type.isInterface() && Serializable.class.isAssignableFrom(type)) {
                    return new ValueDescriptor(type, this.repo);
                }
                if (Remote.class.isAssignableFrom(type)) {
                    if (type.isInterface()) {
                        return new RemoteInterfaceDescriptor(type, this.repo);
                    }
                    return new RemoteClassDescriptor(type, this.repo);
                }
                if (java.lang.Object.class.isAssignableFrom(type)) {
                    if (Raw.isAbstractInterface(type)) {
                        logger.finer("encoding " + type + " as abstract interface");
                        return new AbstractObjectDescriptor(type, this.repo);
                    }
                    logger.finer("encoding " + type + " as a abstract value");
                    return new ValueDescriptor(type, this.repo);
                }
                throw new RuntimeException("cannot handle class " + type.getName());
            }

            private TypeDescriptor primitiveDescriptor(Class<?> type) {
                if (type == Boolean.TYPE) {
                    return new BooleanDescriptor(this.repo);
                }
                if (type == Byte.TYPE) {
                    return new ByteDescriptor(this.repo);
                }
                if (type == Short.TYPE) {
                    return new ShortDescriptor(this.repo);
                }
                if (type == Character.TYPE) {
                    return new CharDescriptor(this.repo);
                }
                if (type == Integer.TYPE) {
                    return new IntegerDescriptor(this.repo);
                }
                if (type == Long.TYPE) {
                    return new LongDescriptor(this.repo);
                }
                if (type == Float.TYPE) {
                    return new FloatDescriptor(this.repo);
                }
                if (type == Double.TYPE) {
                    return new DoubleDescriptor(this.repo);
                }
                if (type == Void.TYPE) {
                    return new VoidDescriptor(this.repo);
                }
                throw new RuntimeException("internal error: " + type);
            }

            private static boolean isIDLEntity(Class<?> type) {
                for (Class<?> intf : type.getInterfaces()) {
                    if (!intf.equals(IDLEntity.class)) continue;
                    return true;
                }
                return false;
            }

            private static boolean isAbstractInterface(Class<?> type) {
                if (!type.isInterface()) {
                    return false;
                }
                for (Class<?> clazz : type.getInterfaces()) {
                    if (Raw.isAbstractInterface(clazz)) continue;
                    return false;
                }
                for (GenericDeclaration genericDeclaration : type.getDeclaredMethods()) {
                    if (Raw.isRemoteMethod((Method)genericDeclaration)) continue;
                    return false;
                }
                return true;
            }

            private static boolean isRemoteMethod(Method m) {
                for (Class<RemoteException> clazz : m.getExceptionTypes()) {
                    if (!clazz.isAssignableFrom(RemoteException.class)) continue;
                    return true;
                }
                return false;
            }
        }
    }

    private static final class TypeDescriptorCache {
        private final ConcurrentMap<WeakKey<TypeDescriptor.FullKey>, WeakReference<TypeDescriptor>> map = new ConcurrentHashMap<WeakKey<TypeDescriptor.FullKey>, WeakReference<TypeDescriptor>>();
        private final ReferenceQueue<TypeDescriptor.FullKey> staleKeys = new ReferenceQueue();

        private TypeDescriptorCache() {
        }

        public TypeDescriptor get(String repid) {
            this.cleanStaleKeys();
            WeakReference ref = (WeakReference)this.map.get(new SearchKey<TypeDescriptor.SimpleKey>(new TypeDescriptor.SimpleKey(repid)));
            return null == ref ? null : (TypeDescriptor)ref.get();
        }

        public TypeDescriptor get(String repid, Class<?> localType) {
            this.cleanStaleKeys();
            WeakReference ref = (WeakReference)this.map.get(new SearchKey<TypeDescriptor.FullKey>(new TypeDescriptor.FullKey(repid, localType)));
            return null == ref ? null : (TypeDescriptor)ref.get();
        }

        public void put(TypeDescriptor typeDesc) {
            this.cleanStaleKeys();
            WeakReference<TypeDescriptor> value = new WeakReference<TypeDescriptor>(typeDesc);
            this.map.putIfAbsent(new WeakKey<TypeDescriptor.FullKey>(typeDesc.getKey(), this.staleKeys), value);
        }

        private void cleanStaleKeys() {
            Reference<TypeDescriptor.FullKey> staleKey = this.staleKeys.poll();
            while (staleKey != null) {
                this.map.remove(staleKey);
                staleKey = this.staleKeys.poll();
            }
        }
    }
}

