/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import com.ibm.ws.sip.stack.transport.sip.SipInboundChannel;
import com.ibm.ws.sip.stack.transport.sip.SipUdpConnLink;
import com.ibm.ws.sip.stack.transport.sip.SipUdpConnection;
import com.ibm.ws.sip.stack.transport.sip.UdpSender;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.udpchannel.UDPContext;
import jain.protocol.ip.sip.ListeningPoint;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;

public class SipUdpInboundChannel
extends SipInboundChannel {
    private static final TraceComponent tc = Tr.register(SipUdpInboundChannel.class);
    private static HashMap s_instances = new HashMap();
    private UdpSender m_connLink = null;

    public static SipUdpInboundChannel instance(ChannelData config, ListeningPoint lp, String outboundChainName) {
        SipUdpInboundChannel channel = (SipUdpInboundChannel)s_instances.get(lp);
        if (channel == null) {
            channel = new SipUdpInboundChannel(config, lp, outboundChainName);
            s_instances.put(lp, channel);
        }
        return channel;
    }

    private SipUdpInboundChannel(ChannelData config, ListeningPoint lp, String outboundChainName) {
        super(config, lp, outboundChainName, UDPContext.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UdpSender getConnectionLink() {
        if (this.m_connLink == null) {
            SipUdpInboundChannel sipUdpInboundChannel = this;
            synchronized (sipUdpInboundChannel) {
                if (this.m_connLink == null) {
                    this.m_connLink = SipUdpConnLink.instance(this);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getConnectionLink", (Object[])new Object[]{this.m_connLink.toString()});
        }
        return this.m_connLink;
    }

    public ConnectionLink getConnectionLink(VirtualConnection vc) {
        return this.getConnectionLink();
    }

    void connectionClosed() {
        this.m_connLink = null;
    }

    @Override
    public SIPConnection createConnection(InetAddress remoteAddress, int remotePort) throws IOException {
        String remoteHost = SIPStackUtil.getHostAddress(remoteAddress);
        UdpSender connLink = this.getConnectionLink();
        return new SipUdpConnection(remoteHost, remotePort, this, connLink);
    }
}

