/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.servlets.ServletContextWrapper;
import com.ibm.ws.sip.container.servlets.SipServletUtilImpl;
import com.ibm.ws.sip.container.servlets.SipServletsFactoryImpl;
import com.ibm.ws.sip.container.servlets.SipSessionsUtilImpl;
import com.ibm.ws.sip.container.timer.ExternTimerService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.sip.SipFactory;

public class ServletConfigWrapper
implements ServletConfig,
Serializable {
    private static final LogMgr c_logger = Log.get(ServletConfigWrapper.class);
    private ServletConfig m_impl;
    private ServletContext m_servletContext;
    public static final String ATTRIBUTE_100_REL = "javax.servlet.sip.100rel";
    public static final String PARAM_100_REL = "100rel";
    public static final String PARAM_FROM_CHANGE = "from-change";
    public static final String SIP_SERVLET_UTIL = "javax.servlet.sip.SipServletUtil";
    public static final String ATTRIBUTE_SUPPORTED_RFCS = "javax.servlet.sip.supportedRfcs";
    private static final List<String> c_supported = Collections.unmodifiableList(ServletConfigWrapper.getListOfSupportedForContainer());
    private static final List<String> c_supportedRfcs = Collections.unmodifiableList(ServletConfigWrapper.getListOfSupportedRFCsForContainer());
    public static final String APP_NAME_ATTRIBUTE = "com.ibm.ws.sip.container.app.name";

    public ServletConfigWrapper(ServletConfig impl) {
        this.m_impl = impl;
    }

    public String getServletName() {
        return this.m_impl.getServletName();
    }

    public static void setContextAttributes(ServletContext ctx) {
        if (ctx.getAttribute("javax.servlet.sip.SipFactory") != null) {
            return;
        }
        String appName = ServletConfigWrapper.getAppName(ctx);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Got application: " + appName);
        }
        SipFactory factory = SipServletsFactoryImpl.getInstance(appName);
        ctx.setAttribute("javax.servlet.sip.SipFactory", (Object)factory);
        ctx.setAttribute("javax.servlet.sip.TimerService", (Object)ExternTimerService.getInstance());
        ctx.setAttribute("javax.servlet.sip.supported", c_supported);
        ctx.setAttribute(ATTRIBUTE_SUPPORTED_RFCS, c_supportedRfcs);
        ctx.setAttribute(ATTRIBUTE_100_REL, (Object)Boolean.TRUE);
        ctx.setAttribute(SIP_SERVLET_UTIL, (Object)new SipServletUtilImpl());
        ctx.setAttribute("javax.servlet.sip.SipSessionsUtil", (Object)new SipSessionsUtilImpl(appName));
        ctx.setAttribute("com.ibm.ws.sip.container.domain.resolver", (Object)SipContainerComponent.getDomainResolverService());
    }

    public ServletContext getServletContext() {
        if (this.m_servletContext == null) {
            ServletContext ctx = this.m_impl.getServletContext();
            if (ctx != null) {
                ServletConfigWrapper.setContextAttributes(ctx);
            }
            this.m_servletContext = new ServletContextWrapper(ctx);
        }
        return this.m_servletContext;
    }

    private static String getAppName(ServletContext ctx) {
        return ctx.getServletContextName();
    }

    public String getInitParameter(String arg0) {
        return this.m_impl.getInitParameter(arg0);
    }

    public Enumeration getInitParameterNames() {
        return this.m_impl.getInitParameterNames();
    }

    public static List<String> getSupportedList() {
        return c_supported;
    }

    private static final List<String> getListOfSupportedForContainer() {
        ArrayList<String> list = new ArrayList<String>(10);
        list.add(PARAM_100_REL);
        list.add("path");
        list.add(PARAM_100_REL);
        if (!PropertiesStore.getInstance().getProperties().getBoolean("jsr289SupportLegacyClient")) {
            list.add(PARAM_FROM_CHANGE);
        }
        return list;
    }

    private static final List<String> getListOfSupportedRFCsForContainer() {
        ArrayList<String> rfcList = new ArrayList<String>(100);
        rfcList.add("RFC2543");
        rfcList.add("RFC2848");
        rfcList.add("RFC2976");
        rfcList.add("RFC3050");
        rfcList.add("RFC3087");
        rfcList.add("RFC3261");
        rfcList.add("RFC3262");
        rfcList.add("RFC3264");
        rfcList.add("RFC3265");
        rfcList.add("RFC3266");
        rfcList.add("RFC3311");
        rfcList.add("RFC3312");
        rfcList.add("RFC3313");
        rfcList.add("RFC3319");
        rfcList.add("RFC3326");
        rfcList.add("RFC3327");
        rfcList.add("RFC3351");
        rfcList.add("RFC3372");
        rfcList.add("RFC3398");
        rfcList.add("RFC3428");
        rfcList.add("RFC3455");
        rfcList.add("RFC3487");
        rfcList.add("RFC3515");
        rfcList.add("RFC3578");
        rfcList.add("RFC3603");
        rfcList.add("RFC3608");
        rfcList.add("RFC3665");
        rfcList.add("RFC3666");
        rfcList.add("RFC3680");
        rfcList.add("RFC3702");
        rfcList.add("RFC3725");
        rfcList.add("RFC3764");
        rfcList.add("RFC3824");
        rfcList.add("RFC3840");
        rfcList.add("RFC3842");
        rfcList.add("RFC3856");
        rfcList.add("RFC3857");
        rfcList.add("RFC3903");
        rfcList.add("RFC3959");
        rfcList.add("RFC3960");
        rfcList.add("RFC3968");
        rfcList.add("RFC3969");
        rfcList.add("RFC3976");
        rfcList.add("RFC4032");
        rfcList.add("RFC4083");
        rfcList.add("RFC4092");
        rfcList.add("RFC4117");
        rfcList.add("RFC4123");
        rfcList.add("RFC4189");
        rfcList.add("RFC4235");
        rfcList.add("RFC4240");
        rfcList.add("RFC4245");
        rfcList.add("RFC4321");
        rfcList.add("RFC4353");
        rfcList.add("RFC4354");
        rfcList.add("RFC4411");
        rfcList.add("RFC4453");
        rfcList.add("RFC4457");
        rfcList.add("RFC4458");
        rfcList.add("RFC4483");
        rfcList.add("RFC4497");
        rfcList.add("RFC4504");
        rfcList.add("RFC4508");
        return rfcList;
    }
}

