/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.servlets.AddressImpl;
import com.ibm.ws.sip.container.servlets.ContactSystemSipURIImpl;
import com.ibm.ws.sip.container.servlets.SipURIImpl;
import com.ibm.ws.sip.container.servlets.SystemTelURLImpl;
import com.ibm.ws.sip.container.servlets.TelURLImpl;
import com.ibm.ws.sip.container.servlets.URIImpl;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.NameAddressHeader;

public class ContactSystemAddressImpl
extends AddressImpl {
    private static final long serialVersionUID = -205267488174013471L;
    private static final LogMgr c_logger = Log.get(ContactSystemAddressImpl.class);

    protected ContactSystemAddressImpl(NameAddressHeader nameAddressHeader) {
        super(nameAddressHeader);
    }

    @Override
    public javax.servlet.sip.URI getURI() {
        URIImpl rUri = null;
        if (null != this._parametersHeader && !this.isWildcard()) {
            URI jainUri = ((NameAddressHeader)this._parametersHeader).getNameAddress().getAddress();
            if (null != jainUri) {
                String scheme = jainUri.getScheme();
                rUri = SipURIImpl.isSchemeSupported(scheme) ? new ContactSystemSipURIImpl((SipURL)jainUri) : (TelURLImpl.isSchemeSupported(scheme) ? new SystemTelURLImpl(jainUri) : new URIImpl(jainUri));
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceExit((Object)ContactSystemAddressImpl.class.getName(), "getURI", rUri.getClass().getName() + "@" + Integer.toHexString(((Object)rUri).hashCode()));
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getURI", "jainUri is null");
            }
        }
        return rUri;
    }

    @Override
    public void setURI(javax.servlet.sip.URI uri) {
        SipURIImpl sipUri;
        String userPart;
        if (uri instanceof SipURIImpl && (userPart = (sipUri = (SipURIImpl)uri).getUser()) != null) {
            ((SipURIImpl)this.getURI()).setUser(userPart);
        }
    }

    @Override
    public void setDisplayName(String name) {
        if (PropertiesStore.getInstance().getProperties().getBoolean("allow.setting.system.contact.display.name")) {
            super.setDisplayName(name);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setDisplayName", "setting display name for contact header is allowed, display-name=" + name);
            }
        } else {
            throw new IllegalStateException("This Address is used in a Contact System header context where it cannot be modified");
        }
    }
}

