/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.proxy;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.message.RequestImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.ResponseImpl;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.proxy.BranchManager;
import com.ibm.ws.sip.container.proxy.ProxyBranchImpl;
import com.ibm.ws.sip.container.proxy.ProxyParent;
import com.ibm.ws.sip.container.proxy.ProxyTimer;
import com.ibm.ws.sip.container.proxy.SipProxyInfo;
import com.ibm.ws.sip.container.router.SipRouter;
import com.ibm.ws.sip.container.router.SipServletInvokerListener;
import com.ibm.ws.sip.container.servlets.IncomingSipServletRequest;
import com.ibm.ws.sip.container.servlets.IncomingSipServletResponse;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletResponse;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.servlets.SipServletsFactoryImpl;
import com.ibm.ws.sip.container.servlets.SipSessionSeqLog;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.SipUtil;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransactionHelper;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Response;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;

public class StatefullProxy
extends BranchManager
implements Proxy,
SipServletInvokerListener {
    private static final LogMgr c_logger = Log.get(StatefullProxy.class);
    private ProxyTimer _timer;
    private boolean _addPath = false;
    private boolean _isSupervised = true;
    private int _proxyTimeOut = 180;
    protected boolean _isParallel = true;
    private ProxyBranchImpl _virtualBranch = null;
    private boolean _isFinalResponseForwarded = false;
    private boolean _noCancelOfBranchesOnComplete = false;

    public StatefullProxy(SipServletRequestImpl originalReq) {
        super(originalReq);
        SipServletDesc siplet;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "StatefullProxy", this.getMyInfo() + "created " + originalReq.getMethod());
        }
        if ((siplet = originalReq.getTransactionUser().getSipServletDesc()) != null) {
            this._proxyTimeOut = siplet.getSipApp().getProxyTimeout();
        }
        if (SipSessionSeqLog.isEnabled()) {
            TransactionUserWrapper tu = this.getTransactionUser();
            tu.logToContext(269, this.getRecordRoute());
            tu.logToContext(271, this.getRecurse());
            tu.logToContext(270, this.getParallel());
        }
    }

    void setupTimeOut() {
        if (this._timer == null || this._timer.isCancelled()) {
            this._timer = new ProxyTimer(this);
            SipContainerComponent.getTimerService().schedule(this._timer, false, this.getProxyTimeout() * 1000);
        }
    }

    @Override
    public boolean getParallel() {
        return this._isParallel;
    }

    @Override
    public boolean getRecordRoute() {
        return this._isRecordRoute;
    }

    @Override
    SipURI getPathAddress(String transport) {
        block10: {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "getPathAddress");
            }
            if (null == this._pathUri) {
                try {
                    if (this.getTransactionUser() != null && this.getTransactionUser().getPreferedOutboundIface(transport) >= 0) {
                        this._pathUri = (SipURI)SipProxyInfo.getInstance().getOutboundInterface(this.getTransactionUser().getPreferedOutboundIface(transport), transport).clone();
                    } else if (this.getPreferedOutboundIface(transport) >= 0) {
                        this._pathUri = (SipURI)SipProxyInfo.getInstance().getOutboundInterface(this.getPreferedOutboundIface(transport), transport).clone();
                    } else {
                        SipServletsFactoryImpl f = SipServletsFactoryImpl.getInstance();
                        SipURI _pathUri = f.createSipURI("", this._host);
                        _pathUri.setPort(this._port);
                        _pathUri.setTransportParam(this._transport);
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "getPathAddress", this.getMyInfo() + "_pathUri = " + _pathUri);
                        }
                    }
                }
                catch (IllegalArgumentException e2) {
                    Object[] args = new Object[]{e2};
                    if (!c_logger.isErrorEnabled()) break block10;
                    c_logger.error("error.create.record.route.uri", "Request", args, (Throwable)e2);
                }
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "getPathAddress");
        }
        return this._pathUri;
    }

    @Override
    public boolean getRecurse() {
        return this._isRecurse;
    }

    @Override
    public boolean getStateful() {
        return true;
    }

    @Override
    public boolean getSupervised() {
        return this._isSupervised;
    }

    @Override
    public void setParallel(boolean parallel) {
        this._isParallel = parallel;
    }

    @Override
    public void setRecordRoute(boolean rr) {
        if (this._started) {
            throw new IllegalStateException("ProxyTo() was already executed");
        }
        if (this._isRecordRoute == rr) {
            return;
        }
        this._isRecordRoute = rr;
    }

    @Override
    public void setSequentialSearchTimeout(int seconds) {
        if (seconds <= 0 && c_logger.isWarnEnabled()) {
            Object[] args = new Object[]{Integer.toString(seconds)};
            c_logger.error("warn.invalid.timeout.value", "Create", args);
        }
        this._proxyTimeOut = seconds;
    }

    @Override
    public void setStateful(boolean stateful) {
    }

    @Override
    public void setSupervised(boolean supervised) {
        this._isSupervised = supervised;
    }

    private final TransactionUserWrapper getTransactionUser() {
        IncomingSipServletRequest origRequest = (IncomingSipServletRequest)this.getOriginalRequest();
        return origRequest.getTransactionUser();
    }

    @Override
    public void process1xxResponse(SipServletResponse response, ProxyBranchImpl branch) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "process1xxResponse", this.getMyInfo());
        }
        ((IncomingSipServletResponse)response).setIsCommited(false);
        if (response.getStatus() != 100) {
            IncomingSipServletRequest origRequest = (IncomingSipServletRequest)this.getOriginalRequest();
            this.associateResponseWithSipSession((SipServletResponseImpl)response, branch);
            this.forwardResponse(response, origRequest, ((IncomingSipServletResponse)response).getTransactionUser());
        }
    }

    @Override
    public synchronized void processResponse(ProxyBranchImpl branch, SipServletResponse response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "processResponse", branch, response);
        }
        IncomingSipServletResponse inResponse = (IncomingSipServletResponse)response;
        inResponse.setIsCommited(false);
        IncomingSipServletRequest origRequest = (IncomingSipServletRequest)this.getOriginalRequest();
        int status = inResponse.getStatus();
        if (this.isFinalResponse(status)) {
            this.associateResponseWithSipSession(inResponse, branch);
            inResponse.getTransactionUser().setProxyReceivedFinalResponse(true, status);
            this.updateBestResponse(inResponse, branch);
            this.cancelProxyTimer();
            if (!this._noCancelOfBranchesOnComplete) {
                this.cancellAllActiveBranches(null, null, null);
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processResponse", "no Cancel set, skipping canceling of completed branches.");
            }
            inResponse.getTransactionUser().setProxyReceivedFinalResponse(true, status);
            this.forwardResponse(inResponse, origRequest, inResponse.getTransactionUser());
            return;
        }
        if (!this.getParallel()) {
            this.cancelProxyTimer();
        }
        if (branch.isCompleted()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processResponse", this.getMyInfo() + "This branch is completed");
            }
            this.branchCompleted(branch, inResponse);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "processResponse");
        }
    }

    private void cancelProxyTimer() {
        if (this._timer != null && !this._timer.isCancelled()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "cancelProxyTimer", this.getMyInfo());
            }
            this._timer.cancel();
            this._timer = null;
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "cancelProxyTimer", this.getMyInfo() + "Timer is null or cancelled = " + this._timer);
        }
    }

    @Override
    public synchronized void cancel() {
        this.cancel(null, null, null);
    }

    public synchronized void cancel(String[] reasons) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "cancel", this.getMyInfo() + "Proxy operation is canceled by the server");
        }
        if (this._bestResponse.getBestResponse() != null && this.isFinalResponse(this._bestResponse.getBestResponse().getStatus())) {
            throw new IllegalStateException("Proxy completed");
        }
        for (int i = 0; i < this._proxyBranches.size(); ++i) {
            ProxyBranchImpl branch = (ProxyBranchImpl)this._proxyBranches.get(i);
            if (!branch.isActive()) continue;
            branch.cancel(reasons);
        }
    }

    @Override
    public void cancel(String[] protocol, int[] reasonCode, String[] reasonText) {
        if (this._bestResponse.getBestResponse() != null && this.isFinalResponse(this._bestResponse.getBestResponse().getStatus())) {
            throw new IllegalStateException("Proxy completed");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "cancel", this.getMyInfo() + "Proxy operation is canceled by the application");
        }
        if (protocol != null && reasonCode != null && reasonText != null) {
            HashSet<String> uniqueProtocols = new HashSet<String>();
            for (String prot : protocol) {
                if (uniqueProtocols.contains(prot)) {
                    throw new IllegalArgumentException("The Reason header includes more than one of the same protocol. Please use different protocols when there are multiple Reason headers.");
                }
                uniqueProtocols.add(prot);
            }
        }
        this.cancellAllActiveBranches(protocol, reasonCode, reasonText);
    }

    private void cancellAllActiveBranches(String[] protocol, int[] reasonCode, String[] reasonText) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "cancellAllActiveBranches", this.getMyInfo());
        }
        for (int i = 0; i < this._proxyBranches.size(); ++i) {
            ProxyBranchImpl branch = (ProxyBranchImpl)this._proxyBranches.get(i);
            if (!branch.isActive()) continue;
            branch.cancel(protocol, reasonCode, reasonText);
        }
    }

    protected void forwardResponse(SipServletResponse response, IncomingSipServletRequest origRequest, TransactionUserWrapper tu) {
        if (this._isFinalResponseForwarded && !SipUtil.is2xxResponse(response.getStatus())) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "forwardResponse", this.getMyInfo() + "Can not forward response - final response already forwarded. ");
            }
            return;
        }
        if (response instanceof OutgoingSipServletResponse && ((OutgoingSipServletResponse)response).isOfVirtualProxyBranch()) {
            origRequest.getTransactionUser().setIsProxying(false);
            this.sendAppResponseUpstream(response);
            return;
        }
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buffer = new StringBuffer(this.getMyInfo());
            buffer.append("response is ");
            buffer.append(response.getStatus());
            buffer.append(response.getReasonPhrase());
            c_logger.traceDebug(this, "forwardResponse", buffer.toString());
        }
        if (((SipServletResponseImpl)response).isReliableResponse()) {
            ((SipServletResponseImpl)response).getTransactionUser().updateWithProxyReliableResponse(response);
        }
        if (this.getSupervised()) {
            this.sendResponseToApplication(response, this, tu);
        } else {
            this.sendResponseUpstream(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponseUpstream(SipServletResponse response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "sendResponseUpstream", (Object)response);
        }
        OutgoingSipServletResponse outgoingResponse = null;
        IncomingSipServletRequest req = (IncomingSipServletRequest)this._originalReq;
        StatefullProxy statefullProxy = this;
        synchronized (statefullProxy) {
            if (!this._isFinalResponseForwarded) {
                outgoingResponse = StatefullProxy.createOutgoingResponse(req, response);
                if (SIPTransactionHelper.isFinalResponse(response.getStatus())) {
                    this._isFinalResponseForwarded = true;
                }
            }
        }
        if (outgoingResponse != null) {
            try {
                if (outgoingResponse.getStatus() >= 200 && outgoingResponse.getStatus() < 300 || outgoingResponse.getStatus() >= 400) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "sendResponseUpstream", "This response is final response on original request.");
                    }
                    this._originalReq.setIsCommited(true);
                }
                outgoingResponse.send();
            }
            catch (IOException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{response};
                    c_logger.error("error.forward.response", "Request", args, (Throwable)e2);
                }
            }
        } else {
            int status = response.getStatus();
            if (status >= 200 && status < 300) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "sendResponseUpstream", this.getMyInfo() + "Bypassing transaction layer sending response upstream, response already generated by application");
                }
                SipServletResponseImpl resImpl = (SipServletResponseImpl)response;
                resImpl.getTransactionUser().onSendingResponse(response);
                ResponseImpl jainRes = (ResponseImpl)resImpl.getResponse();
                RequestImpl jainOrigReq = (RequestImpl)this._originalReq.getRequest();
                jainRes.setLoopback(jainOrigReq.isLoopback());
                SipRouter.sendResponseDirectlyToTransport(resImpl.getSipProvider(), resImpl.getResponse(), true);
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "sendResponseUpstream", this.getMyInfo() + "Response NOT sent upstream, transaction already committed. " + response);
            }
        }
        if (response.getStatus() >= 200) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "sendResponseUpstream", this.getMyInfo() + response.getReasonPhrase() + response.getStatus() + " ,call-id=" + response.getCallId() + " Going to cancel proxy timer when forwarding final response upstream.");
            }
            this.cancelProxyTimer();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "sendResponseUpstream");
        }
    }

    @Override
    public boolean getAddToPath() {
        return this._addPath;
    }

    @Override
    public ProxyBranch getProxyBranch(URI uri) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getProxyBranch", this.getMyInfo() + "GetBranch by URI = " + uri);
        }
        ProxyBranchImpl foundBranch = null;
        for (int i = 0; i < this._proxyBranches.size() && foundBranch == null; ++i) {
            ProxyBranchImpl proxyBranch = (ProxyBranchImpl)this._proxyBranches.get(i);
            foundBranch = proxyBranch.getUri().equals(uri) ? proxyBranch : proxyBranch.findRecurseBranchByUri(uri);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getProxyBranch", this.getMyInfo() + "Found Branch " + foundBranch);
        }
        return foundBranch;
    }

    protected void sendResponseToApplication(SipServletResponse response, SipServletInvokerListener listener, TransactionUserWrapper tu) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, this.getMyInfo() + "sendResponseToApplication", response.getReasonPhrase() + " " + response.getStatus());
        }
        SipServletResponseImpl resImpl = (SipServletResponseImpl)response;
        resImpl.setTransactionUser(tu);
        if (tu == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "sendResponseToApplication", "We have best response without Tug - " + response);
            }
            throw new IllegalStateException("No TransactionUserFound");
        }
        tu.sendResponseToApplication(response, listener);
    }

    @Override
    public void servletInvoked(SipServletResponse response) {
        int status;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "servletInvoked", this.getMyInfo() + "call-id=[" + response.getCallId() + "],status=" + response.getStatus());
        }
        if ((status = response.getStatus()) > 299 && status < 600 && !this.areAllBranchesCompleted()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "servletInvoked", this.getMyInfo() + "added to target set");
            }
            return;
        }
        this.sendResponseUpstream(response);
    }

    @Override
    public void servletInvoked(SipServletRequest request) {
        if (c_logger.isErrorEnabled()) {
            c_logger.error("error.call.should.be.invoked", "Create", null);
        }
    }

    public synchronized void proxyTo(List uris) throws IllegalStateException {
        if (this._originalReq.isCommitted()) {
            throw new IllegalStateException("Transaction already completed can not proxy request");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "proxyTo", " " + uris);
        }
        this._started = true;
        for (URI target : uris) {
            if (target == null) {
                throw new NullPointerException("One of URIs is null null !!!");
            }
            this.createBranch(target, true, this);
        }
        this.startSending();
    }

    @Override
    public synchronized void proxyTo(URI nextHop) throws IllegalStateException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "proxyTo", nextHop, this._originalReq.isCommitted());
        }
        if (nextHop == null) {
            throw new NullPointerException("uri is null !!!");
        }
        if (this._originalReq.isCommitted()) {
            throw new IllegalStateException("Transaction already completed can not proxy request");
        }
        this._started = true;
        this.createBranch(nextHop, true, this);
        this.startSending();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "proxyTo");
        }
    }

    @Override
    public void setRecurse(boolean recurse) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setRecurse", this.getMyInfo() + "Set recurse " + recurse);
        }
        if (this._isRecurse == recurse) {
            return;
        }
        this._isRecurse = recurse;
        for (int i = 0; i < this._proxyBranches.size(); ++i) {
            ProxyBranch branch = (ProxyBranch)this._proxyBranches.get(i);
            branch.setRecurse(recurse);
        }
    }

    @Override
    public void setOutboundInterface(InetSocketAddress address) throws IllegalArgumentException {
        if (address != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setOutboundInterface", "Attempting to set outbound interface to: " + address);
            }
            boolean isSet = false;
            int index = SipProxyInfo.getInstance().getIndexOfIface(address, "udp");
            if (index != -1) {
                isSet = true;
                this._preferedOutBoundIfaceIdxUDP = index;
            }
            if ((index = SipProxyInfo.getInstance().getIndexOfIface(address, "tcp")) != -1) {
                isSet = true;
                this._preferedOutBoundIfaceIdxTCP = index;
            }
            if ((index = SipProxyInfo.getInstance().getIndexOfIface(address, "tls")) != -1) {
                isSet = true;
                this._preferedOutBoundIfaceIdxTLS = index;
            }
            if (!isSet) {
                throw new IllegalArgumentException("address:" + address + " is not listed as allowed outbound interface.");
            }
        } else {
            throw new NullPointerException("Invalid address = null");
        }
    }

    @Override
    public void setOutboundInterface(InetAddress address) throws IllegalArgumentException {
        if (address != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setOutboundInterface", "Attempting to set outbound interface to: " + address);
            }
            boolean isSet = false;
            int index = SipProxyInfo.getInstance().getIndexOfIface(address, "udp");
            if (index != -1) {
                isSet = true;
                this._preferedOutBoundIfaceIdxUDP = index;
            }
            if ((index = SipProxyInfo.getInstance().getIndexOfIface(address, "tcp")) != -1) {
                isSet = true;
                this._preferedOutBoundIfaceIdxTCP = index;
            }
            if ((index = SipProxyInfo.getInstance().getIndexOfIface(address, "tls")) != -1) {
                isSet = true;
                this._preferedOutBoundIfaceIdxTLS = index;
            }
            if (!isSet) {
                throw new IllegalArgumentException("address:" + address + " is not listed as allowed outbound interface.");
            }
        } else {
            throw new NullPointerException("Invalid address = null");
        }
    }

    @Override
    public int getPreferedOutboundIface(String transport) {
        if (SIPTransactionStack.instance().getConfiguration().getSentByHost() != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getPreferedOutboundIface", "Return OUTBOUND_INTERFACE_NOT_DEFINED since the sentByHost property is set");
            }
            return -1;
        }
        if (transport.equals("udp")) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getPreferedOutboundIface", "Index for udp: " + this._preferedOutBoundIfaceIdxUDP);
            }
            return this._preferedOutBoundIfaceIdxUDP;
        }
        if (transport.equals("tcp")) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getPreferedOutboundIface", "Index for tcp: " + this._preferedOutBoundIfaceIdxTCP);
            }
            return this._preferedOutBoundIfaceIdxTCP;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getPreferedOutboundIface", "Index for tls: " + this._preferedOutBoundIfaceIdxTLS);
        }
        return this._preferedOutBoundIfaceIdxTLS;
    }

    @Override
    public void setAddToPath(boolean addToPath) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setAddToPath", this.getMyInfo() + "addToPath" + addToPath);
        }
        if (this._addPath == addToPath) {
            return;
        }
        this._addPath = addToPath;
        for (int i = 0; i < this._proxyBranches.size(); ++i) {
            ProxyBranch branch = (ProxyBranch)this._proxyBranches.get(i);
            branch.setAddToPath(addToPath);
        }
    }

    @Override
    public void onSendingRequest(ProxyBranchImpl branch, SipServletRequest request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{branch, request};
            c_logger.traceEntry((Object)this, "onSendingRequest", params);
        }
        this.setupTimeOut();
        SipServletRequestImpl impl = ((SipServletRequestImpl)request).getTransactionUser() == null ? (SipServletRequestImpl)this.getOriginalRequest() : (SipServletRequestImpl)request;
        impl.getTransactionUser().onSendingRequest(impl);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "onSendingRequest");
        }
    }

    public synchronized boolean processApplicationRespone(OutgoingSipServletResponse response) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "processApplicationRespone", this.getMyInfo() + "response = " + response);
        }
        ProxyBranchImpl proxyBranch = this.createVirtualBranch(this, response);
        boolean continueSending = true;
        if (response.getStatus() < 200) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processApplicationRespone", "Associate the ApplicationResponse with original Session");
            }
            this.associateResponseWithSipSession(response, proxyBranch);
        } else if (response.getStatus() > 299) {
            this.updateBestResponse(response, proxyBranch);
            continueSending = false;
        } else if (this._originalReq.getMethod().equals(response.getMethod())) {
            this.cancel();
            this.associateResponseWithSipSession(response, proxyBranch);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processApplicationRespone", this.getMyInfo() + "Cancel all the branches and forward the response upstream");
            }
            continueSending = true;
        } else {
            continueSending = false;
        }
        if (!continueSending) {
            this.branchCompleted(proxyBranch, response);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "processApplicationResponse", "Exit code: " + continueSending);
        }
        return continueSending;
    }

    private void sendAppResponseUpstream(SipServletResponse response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{new Integer(response.getStatus()), response.getReasonPhrase()};
            c_logger.traceEntry((Object)this, "sendAppResponseUpstream", params);
        }
        try {
            if (response.getStatus() >= 200 && response.getStatus() < 300 || response.getStatus() >= 400) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "sendResponseUpstream", "This response is final response on original request.");
                }
                this._originalReq.setIsCommited(true);
            }
            response.send();
        }
        catch (IOException e2) {
            StatefullProxy.logException(e2);
        }
    }

    public void handleStrayInvite2xx(Response response, SipProvider provider, TransactionUserWrapper newTuw) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "handleStrayInvite2xx", response, provider, newTuw);
        }
        try {
            boolean foundMatchingBranch = false;
            ViaHeader via = (ViaHeader)response.getHeader("Via", true);
            String branch = via.getBranch();
            ProxyBranchImpl proxyBranch = null;
            for (int i = 0; i < this._proxyBranches.size() && !foundMatchingBranch; ++i) {
                proxyBranch = (ProxyBranchImpl)this._proxyBranches.get(i);
                if (proxyBranch.isRetransmission()) {
                    if (proxyBranch.getBranchId().equals(branch)) {
                        foundMatchingBranch = true;
                        continue;
                    }
                    if ((proxyBranch = proxyBranch.findRecurseBranch(branch)) == null) continue;
                    foundMatchingBranch = true;
                    continue;
                }
                if (!c_logger.isTraceDebugEnabled()) continue;
                c_logger.traceDebug(this, "handle2xxRetransmission", "Retransmission is not allowed for this branch state");
            }
            if (foundMatchingBranch) {
                TransactionUserWrapper origTU;
                SipServletRequestImpl branchRequest = (SipServletRequestImpl)proxyBranch.getRequest();
                if (branchRequest == null) {
                    branchRequest = (SipServletRequestImpl)proxyBranch.getOriginalRequest();
                }
                if ((origTU = branchRequest.getTransactionUser()) == null || origTU.isInvalidating()) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "handleStrayInvite2xx", "return because got stray response on invalidating transaction: " + branchRequest.getCallId());
                    }
                    return;
                }
                IncomingSipServletResponse servletResponse = new IncomingSipServletResponse(response, -1L, provider);
                servletResponse.setRequest((SipServletRequestImpl)proxyBranch.getRequestForInternalUse());
                servletResponse.setIsCommited(false);
                this.processResponse(proxyBranch, servletResponse);
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handle2xxRetransmission", this.getMyInfo() + "Error, Failed to find a matching branch");
            }
        }
        catch (HeaderParseException e2) {
            StatefullProxy.logException(e2);
        }
        catch (IllegalArgumentException e3) {
            StatefullProxy.logException(e3);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "handleStrayInvite2xx");
        }
    }

    @Override
    public void allBranchesCompleted() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "allBranchesCompleted");
        }
        SipServletResponse response = this._bestResponse.getBestResponse();
        ProxyBranchImpl pb = this._bestResponse.getProxyBranch();
        if (pb == null) {
            TransactionUserWrapper origTu;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "allBranchesCompleted", "No branch selected yet for best response");
            }
            if ((origTu = ((SipServletRequestImpl)this.getOriginalRequest()).getTransactionUser()).getRemoteTag_2() != null) {
                TransactionUserWrapper derived = origTu.createDerivedTU(((SipServletResponseImpl)response).getResponse(), " StatefullProxy - response with different tag received");
                ((SipServletResponseImpl)response).setTransactionUser(derived);
            } else {
                ((SipServletResponseImpl)response).setTransactionUser(origTu);
            }
        } else {
            this.associateResponseWithSipSession((SipServletResponseImpl)response, pb);
        }
        ((SipServletResponseImpl)response).getTransactionUser().setProxyReceivedFinalResponse(true, response.getStatus());
        this.forwardResponse(response, (IncomingSipServletRequest)this._originalReq, ((SipServletResponseImpl)response).getTransactionUser());
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "allBranchesCompleted");
        }
    }

    @Override
    public void setProxyTimeout(int seconds) {
        if (seconds < 1) {
            throw new IllegalArgumentException("TimeOut proxy interval should be higher than 0");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setProxyTimeout", this.getMyInfo() + "seconds = " + seconds);
        }
        this._proxyTimeOut = seconds;
        if (!this._started) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setProxyTimeout", this.getMyInfo() + "Will not start ProxyTimer as this proxy wasn't started yet");
            }
            return;
        }
        if (this._timer != null) {
            this._timer.cancel();
        }
        this._timer = new ProxyTimer(this);
        SipContainerComponent.getTimerService().schedule(this._timer, false, this._proxyTimeOut * 1000);
    }

    public synchronized void proxyTimeout() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "proxyTimeout", this.getMyInfo());
        }
        this.cancelProxyTimer();
        this.timeoutAllChildBranches(false);
    }

    @Override
    public List<ProxyBranch> getProxyBranches() {
        return this.getAllBranches();
    }

    @Override
    public int getProxyTimeout() {
        return this._proxyTimeOut;
    }

    @Override
    public int getSequentialSearchTimeout() {
        return this.getProxyTimeout();
    }

    @Override
    public synchronized List<ProxyBranch> createProxyBranches(List<? extends URI> targets) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{targets};
            c_logger.traceEntry((Object)this, "createProxyBranches", params);
        }
        if (targets == null || targets.isEmpty()) {
            return Collections.emptyList();
        }
        for (URI uRI : targets) {
            this.createBranch(uRI, false, this);
        }
        return this.getAllNewlyCreatedProxyBranches();
    }

    @Override
    public void startProxy() throws IllegalStateException {
        this._started = true;
        if (this._bestResponse.getBestResponse() != null && this.isFinalResponse(this._bestResponse.getBestResponse().getStatus())) {
            throw new IllegalStateException("Final Response was already forwarded to the application");
        }
        boolean foundAtLeastOneBranch = false;
        for (int i = 0; i < this._proxyBranches.size(); ++i) {
            ProxyBranchImpl branch = (ProxyBranchImpl)this._proxyBranches.get(i);
            if (branch.isInitial()) continue;
            branch.setStarted();
            foundAtLeastOneBranch = true;
        }
        if (!foundAtLeastOneBranch) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "startProxy", this.getMyInfo() + "No Branches were created for that proxy");
            }
            throw new IllegalStateException("No new created ProxyBranches which should be started");
        }
        this.startSending();
    }

    @Override
    protected StatefullProxy getStatefullProxy() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getProxy", this.getMyInfo() + "Warning!!! Shouldn't get here");
        }
        return null;
    }

    protected boolean getIsRecordRoute() {
        return this._isRecordRoute;
    }

    @Override
    protected boolean getIsParallel() {
        return this._isParallel;
    }

    @Override
    SipServletRequest getRequestForInternalUse() {
        return this._originalReq;
    }

    @Override
    boolean getAddToPathValue() {
        return this.getAddToPath();
    }

    @Override
    protected boolean proxyBranchExists(URI nextHop) {
        for (ProxyBranchImpl branch : this._proxyBranches) {
            if (!nextHop.equals(branch.getUri())) continue;
            return true;
        }
        return false;
    }

    protected boolean isVirtualBranchExists() {
        return this._virtualBranch != null;
    }

    protected ProxyBranchImpl getVirtualBranch() {
        return this._virtualBranch;
    }

    protected void setVirtualBranch(ProxyBranchImpl virtualBranch) {
        this._virtualBranch = virtualBranch;
    }

    @Override
    public SipURI getPathURI() throws IllegalStateException {
        if (!this.getAddToPath()) {
            throw new IllegalStateException("addToPath is not enabled");
        }
        return this.getPathAddress(this._originalReq.getTransport());
    }

    @Override
    public boolean getNoCancel() {
        return this._noCancelOfBranchesOnComplete;
    }

    @Override
    public void setNoCancel(boolean noCancel) {
        this._noCancelOfBranchesOnComplete = noCancel;
    }

    @Override
    public ProxyParent getParent() {
        return null;
    }

    public ProxyTimer getTimer() {
        return this._timer;
    }
}

