/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipSession;

public class DumpActivator
implements Runnable {
    private static final LogMgr c_logger = Log.get(DumpActivator.class);
    public File _file = null;
    public static final String FILE_METHOD = "FILE";
    public static final String TAB_SEPARATOR = "\t";
    public static final String SEMICOLON = "; ";
    public static final String NEW_LINE = "\n";
    public static final Integer DUMP_SAS_IDs = new Integer(0);
    public static final Integer DUMP_SAS_DETAILs = new Integer(1);
    public static final Integer DUMP_TU_IDs = new Integer(2);
    public static final Integer DUMP_TU_DETAILs = new Integer(3);
    private Object currentDumpAction;
    public static final String SAS_PREFIX = "SAS_";
    public static final String SS_PREFIX = "SS_";
    public static SimpleDateFormat _sdf = new SimpleDateFormat("MMM dd,yyyy HH:mm");

    public DumpActivator() {
    }

    public DumpActivator(Object currentDumpAction) {
        this.currentDumpAction = currentDumpAction;
    }

    @Override
    public void run() {
        StringBuilder strToPrint = new StringBuilder();
        if (this.currentDumpAction instanceof Integer) {
            Integer method = (Integer)this.currentDumpAction;
            this.startDumpingListOfSessions(method, strToPrint);
        } else if (this.currentDumpAction instanceof String) {
            String id = (String)this.currentDumpAction;
            this.startDumpingParticularSession(id, strToPrint);
        } else {
            throw new RuntimeException("Got unknown object running in DumpActivator thread");
        }
        this.print(strToPrint.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String setDumpMethod(String method, String description) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "setDumpMethod for " + method);
        }
        if (!FILE_METHOD.equalsIgnoreCase(method)) return method + " is not supported, check syntax.";
        try {
            this._file = new File(description);
            if (!this._file.getParentFile().exists()) {
                this._file.getParentFile().mkdirs();
            }
            if (!this._file.exists()) {
                this._file.createNewFile();
            }
        }
        catch (IOException e2) {
            if (!c_logger.isErrorEnabled()) return "Failed";
            c_logger.error("error.exception", "Create", null, (Throwable)e2);
            return "Failed";
        }
        if (!c_logger.isTraceEntryExitEnabled()) return "Success";
        c_logger.traceExit(this, "setDumpMethod");
        return "Success";
    }

    private StringBuilder getFirstLevelHeader(String appName, int count) {
        StringBuilder header = new StringBuilder();
        header.append(appName);
        header.append(TAB_SEPARATOR);
        header.append(count);
        header.append(NEW_LINE);
        return header;
    }

    private void printToFile(String s) {
        block2: {
            try {
                FileWriter fw = new FileWriter(this._file.getAbsoluteFile());
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(s);
                bw.close();
            }
            catch (IOException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                c_logger.error("error.exception", "Create", null, (Throwable)e2);
            }
        }
    }

    private boolean isDumpSASMethod(int method) {
        return method == DUMP_SAS_IDs || method == DUMP_SAS_DETAILs;
    }

    private boolean isDumpTUMethod(int method) {
        return method == DUMP_TU_IDs || method == DUMP_TU_DETAILs;
    }

    private boolean isDumpDetails(int method) {
        return method == DUMP_SAS_DETAILs || method == DUMP_TU_DETAILs;
    }

    private void print(String s) {
        if (this._file != null) {
            this.printToFile(s);
        } else {
            System.out.println(s);
        }
    }

    private void generateSASDetailsToPrint(int dumpMethod, SipApplicationSession appSession, StringBuilder str) {
        str.append(appSession.getId());
        if (!this.isDumpDetails(dumpMethod)) {
            return;
        }
        StringBuffer attrNames = new StringBuffer();
        Iterator itr = appSession.getAttributeNames();
        while (itr.hasNext()) {
            attrNames.append(itr.next()).append(SEMICOLON);
        }
        str.append(TAB_SEPARATOR).append(_sdf.format(new Date(appSession.getCreationTime()))).append(TAB_SEPARATOR).append(attrNames);
    }

    private void generateTUDetailsToPrint(int dumpMethod, TransactionUserWrapper tu, StringBuilder str) {
        str.append(tu.getId()).append(TAB_SEPARATOR);
        str.append(tu.hasSipSession() ? "  true  " : "  false ");
        str.append(TAB_SEPARATOR).append(tu.getSipSessionId());
        if (this.isDumpDetails(dumpMethod)) {
            str.append(TAB_SEPARATOR).append(tu.getCallId()).append(TAB_SEPARATOR).append(tu.getDialogState());
            str.append(TAB_SEPARATOR).append(tu.hasOngoingTransactions()).append(TAB_SEPARATOR).append(tu.getInitialDialogMethod());
        }
    }

    private void generateSSDetailsToPrint(SipSession sipSession, StringBuilder str, boolean printSSId) {
        if (!sipSession.isValid()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "generateSSDetailsToPrint", "SS <" + sipSession.getId() + "> is not valid, returning");
            }
            return;
        }
        StringBuffer attrNames = new StringBuffer();
        Enumeration attrs = sipSession.getAttributeNames();
        while (attrs.hasMoreElements()) {
            attrNames.append((String)attrs.nextElement());
            attrNames.append(SEMICOLON);
        }
        SipApplicationSession appSession = sipSession.getApplicationSession();
        if (printSSId) {
            str.append(sipSession.getId()).append(TAB_SEPARATOR);
        }
        str.append(appSession.getId()).append(TAB_SEPARATOR);
        str.append(_sdf.format(new Date(sipSession.getCreationTime()))).append(TAB_SEPARATOR).append(attrNames);
    }

    private void generateErrorMessageToPrint(String id, StringBuilder str) {
        str.append("ERROR: Requested session <" + id + "> does not exist.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preparePrintForSASs(int dumpMethod, Map<String, List<String>> sasPerApp, StringBuilder strToPrint) {
        for (String appName : sasPerApp.keySet()) {
            List<String> sasIds = sasPerApp.get(appName);
            strToPrint.append((CharSequence)this.getFirstLevelHeader(appName, sasIds.size()));
            for (String sasId : sasIds) {
                SipApplicationSessionImpl appSession = (SipApplicationSessionImpl)SessionRepository.getInstance().getAppSession(sasId);
                if (appSession == null) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "preparePrintForSASs", "SAS is null");
                    }
                    strToPrint.append("<<< " + sasId + " >>> has no SipApplicationSession");
                    strToPrint.append(NEW_LINE);
                    continue;
                }
                Object object = appSession.getSynchronizer();
                synchronized (object) {
                    if (!appSession.isValid() || appSession.isDuringInvalidate()) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "preparePrintForSASs", "SAS <" + appSession.getId() + "> is not valid or during invalidation");
                        }
                        continue;
                    }
                    this.generateSASDetailsToPrint(dumpMethod, appSession, strToPrint);
                }
                strToPrint.append(NEW_LINE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preparePrintForTUs(int dumpMethod, Map<String, List<String>> tuPerApp, StringBuilder strToPrint) {
        for (String appName : tuPerApp.keySet()) {
            List<String> tuIds = tuPerApp.get(appName);
            strToPrint.append((CharSequence)this.getFirstLevelHeader(appName, tuIds.size()));
            for (String tuId : tuIds) {
                TransactionUserWrapper tu = SessionRepository.getInstance().getTuWrapper(tuId);
                if (tu == null) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "preparePrintForTUs", "TU is null");
                    }
                    strToPrint.append("<<< " + tuId + " >>> has no transaction");
                    strToPrint.append(NEW_LINE);
                    continue;
                }
                Object object = tu.getSynchronizer();
                synchronized (object) {
                    this.generateTUDetailsToPrint(dumpMethod, tu, strToPrint);
                    if (!tu.isValid() || tu.isInvalidating()) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "preparePrintForTUs", "TU <" + tuId + "> is not valid or during invalidation");
                        }
                    } else if (this.isDumpDetails(dumpMethod) && tu.hasSipSession()) {
                        strToPrint.append(TAB_SEPARATOR);
                        this.generateSSDetailsToPrint(SessionRepository.getInstance().getSipSession(tu.getSipSessionId()), strToPrint, false);
                    }
                }
                strToPrint.append(NEW_LINE);
            }
        }
    }

    public void startDumpingListOfSessions(int dumpMethod, StringBuilder strToPrint) {
        Map<String, List<String>> objPerApp = this.sortObjectsPerApplication(dumpMethod);
        this.prepareForPrint(dumpMethod, objPerApp, strToPrint);
    }

    private Map<String, List<String>> sortObjectsPerApplication(int dumpMethod) {
        if (this.isDumpSASMethod(dumpMethod)) {
            return this.sortSASPerApp();
        }
        if (this.isDumpTUMethod(dumpMethod)) {
            return this.sortTUPerApp();
        }
        return null;
    }

    private void prepareForPrint(int dumpMethod, Map<String, List<String>> map, StringBuilder strToPrint) {
        if (this.isDumpSASMethod(dumpMethod)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug((Object)null, "run ", "DumpingActivator got request to dump SAS");
            }
            this.preparePrintForSASs(dumpMethod, map, strToPrint);
        } else if (this.isDumpTUMethod(dumpMethod)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "run ", "DumpingActivator got request to dump all TUImpl Ids");
            }
            this.preparePrintForTUs(dumpMethod, map, strToPrint);
        }
    }

    private void startDumpingParticularSession(String id, StringBuilder strToPrint) {
        if (id.startsWith(SAS_PREFIX)) {
            String sasId = id.substring(4);
            SipApplicationSession sas = SessionRepository.getInstance().getAppSession(sasId);
            if (sas == null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "run", "didnt find any SipApplicationSession on:" + id);
                }
                this.generateErrorMessageToPrint(sasId, strToPrint);
                return;
            }
            this.generateSASDetailsToPrint(DUMP_SAS_DETAILs, sas, strToPrint);
        } else if (id.startsWith(SS_PREFIX)) {
            String sId = id.substring(3);
            SipSession s = SessionRepository.getInstance().getSipSession(sId);
            if (s == null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "run", "didnt find any SipSession on:" + id);
                }
                this.generateErrorMessageToPrint(sId, strToPrint);
                return;
            }
            this.generateSSDetailsToPrint(s, strToPrint, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map sortSASPerApp() {
        List<SipApplicationSessionImpl> snapshot = SessionRepository.getInstance().getAllAppSessions();
        HashMap<String, ArrayList<String>> sasPerApp = new HashMap<String, ArrayList<String>>();
        for (SipApplicationSessionImpl saSession : snapshot) {
            if (saSession == null) {
                if (!c_logger.isTraceDebugEnabled()) continue;
                c_logger.traceDebug(this, "sortSASPerApp", "SAS is null");
                continue;
            }
            Object object = saSession.getSynchronizer();
            synchronized (object) {
                if (!saSession.isValid() || saSession.isDuringInvalidate()) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "sortSASPerApp", "SAS <" + saSession.getId() + "> is not valid, not sorted for dumping.");
                    }
                    continue;
                }
                String appName = saSession.getAppDescriptor().getApplicationName();
                ArrayList<String> sasIds = (ArrayList<String>)sasPerApp.get(appName);
                if (sasIds == null) {
                    sasIds = new ArrayList<String>();
                    sasPerApp.put(appName, sasIds);
                }
                sasIds.add(saSession.getId());
            }
        }
        return sasPerApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map sortTUPerApp() {
        List snapshot = SessionRepository.getInstance().getAllTuWrappers();
        HashMap<String, ArrayList<String>> tuPerApp = new HashMap<String, ArrayList<String>>();
        for (TransactionUserWrapper tuWrapper : snapshot) {
            if (tuWrapper == null) {
                if (!c_logger.isTraceDebugEnabled()) continue;
                c_logger.traceDebug(this, "sortTUPerApp", "TU is null");
                continue;
            }
            Object object = tuWrapper.getSynchronizer();
            synchronized (object) {
                if (!tuWrapper.isValid() || tuWrapper.isInvalidating()) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "sortTUPerApp", "TU <" + tuWrapper.getId() + "> is not valid, not sorted for dumping.");
                    }
                    continue;
                }
                String appName = tuWrapper.getSipServletDesc().getSipApp().getApplicationName();
                ArrayList<String> tuIds = (ArrayList<String>)tuPerApp.get(appName);
                if (tuIds == null) {
                    tuIds = new ArrayList<String>();
                    tuPerApp.put(appName, tuIds);
                }
                tuIds.add(tuWrapper.getId());
            }
        }
        return tuPerApp;
    }
}

