/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.ExpiresHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.RetryAfterHeader;

public class RetryAfterHeaderImpl
extends ExpiresHeaderImpl
implements RetryAfterHeader {
    private static final long serialVersionUID = -961806665217938113L;
    public static final String DURATION = "duration";
    private long m_duration = -1L;
    private String m_comment;
    private ParametersImpl m_params = null;

    @Override
    public String getComment() {
        return this.m_comment;
    }

    @Override
    public boolean hasComment() {
        return this.m_comment != null;
    }

    @Override
    public void removeComment() {
        this.m_comment = null;
    }

    @Override
    public void setComment(String comment) throws IllegalArgumentException, SipParseException {
        if (comment == null) {
            throw new IllegalArgumentException("RetryAfter: Null comment");
        }
        this.m_comment = comment;
    }

    @Override
    public long getDuration() {
        return this.m_duration;
    }

    @Override
    public boolean hasDuration() {
        return this.m_duration != -1L;
    }

    @Override
    public void removeDuration() {
        this.m_duration = -1L;
    }

    @Override
    public void setDuration(long duration) throws SipParseException {
        if (duration < 0L) {
            throw new SipParseException("Negative duration", "");
        }
        this.m_duration = duration;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        this.setDeltaSeconds(parser.longNumber());
        if (parser.LA(1) == '(') {
            parser.match('(');
            this.setComment(parser.nextToken(')'));
            parser.match(')');
        }
        if (parser.LA(1) == ';') {
            parser.match(';');
            parser.match(DURATION);
            parser.match('=');
            this.setDuration(parser.longNumber());
        }
        if (parser.LA(1) == ';') {
            parser.match(';');
            this.m_params = parser.parseParametersMap(';', true, false);
        }
    }

    @Override
    protected void encodeValue(CharsBuffer ret) {
        super.encodeValue(ret);
        if (this.hasComment()) {
            ret.append(' ');
            ret.append('(');
            ret.append(this.m_comment);
            ret.append(')');
        }
        if (this.hasDuration()) {
            ret.append(';');
            ret.append(DURATION);
            ret.append('=');
            ret.append(this.m_duration);
        }
        if (this.m_params != null) {
            ret.append(';');
            this.m_params.encode(ret, ';', true);
        }
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!super.valueEquals(other)) {
            return false;
        }
        if (!(other instanceof RetryAfterHeaderImpl)) {
            return false;
        }
        RetryAfterHeaderImpl o = (RetryAfterHeaderImpl)other;
        if (this.m_duration != o.m_duration) {
            return false;
        }
        if (this.m_comment == null || this.m_comment.length() == 0) {
            return o.m_comment == null || o.m_comment.length() == 0;
        }
        if (o.m_comment == null || o.m_comment.length() == 0) {
            return false;
        }
        return this.m_comment.equals(o.m_comment);
    }

    @Override
    public String getName() {
        return "Retry-After";
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isNested() {
        return false;
    }
}

