/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.header.AcceptEncodingHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.AcceptHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.AcceptLanguageHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.AllowHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.AuthorizationHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.CSeqHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.CallIdHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ContactHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ContentEncodingHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ContentLengthHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ContentTypeHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.DateHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.EncryptionHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ExpiresHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.FromHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.HideHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.MaxForwardsHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.OrganizationHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.PriorityHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ProxyAuthenticateHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ProxyAuthorizationHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ProxyRequireHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.RecordRouteHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.RequireHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ResponseKeyHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.RetryAfterHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.RouteHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ServerHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.SubjectHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.TimeStampHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ToHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.UnsupportedHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.UserAgentHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ViaHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.WWWAuthenticateHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.WarningHeaderImpl;
import com.ibm.ws.sip.parser.HeaderCreator;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.header.AcceptEncodingHeader;
import jain.protocol.ip.sip.header.AcceptHeader;
import jain.protocol.ip.sip.header.AcceptLanguageHeader;
import jain.protocol.ip.sip.header.AllowHeader;
import jain.protocol.ip.sip.header.AuthorizationHeader;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.header.CallIdHeader;
import jain.protocol.ip.sip.header.ContactHeader;
import jain.protocol.ip.sip.header.ContentEncodingHeader;
import jain.protocol.ip.sip.header.ContentLengthHeader;
import jain.protocol.ip.sip.header.ContentTypeHeader;
import jain.protocol.ip.sip.header.DateHeader;
import jain.protocol.ip.sip.header.EncryptionHeader;
import jain.protocol.ip.sip.header.ExpiresHeader;
import jain.protocol.ip.sip.header.FromHeader;
import jain.protocol.ip.sip.header.Header;
import jain.protocol.ip.sip.header.HeaderFactory;
import jain.protocol.ip.sip.header.HideHeader;
import jain.protocol.ip.sip.header.MaxForwardsHeader;
import jain.protocol.ip.sip.header.OrganizationHeader;
import jain.protocol.ip.sip.header.PriorityHeader;
import jain.protocol.ip.sip.header.ProxyAuthenticateHeader;
import jain.protocol.ip.sip.header.ProxyAuthorizationHeader;
import jain.protocol.ip.sip.header.ProxyRequireHeader;
import jain.protocol.ip.sip.header.RecordRouteHeader;
import jain.protocol.ip.sip.header.RequireHeader;
import jain.protocol.ip.sip.header.ResponseKeyHeader;
import jain.protocol.ip.sip.header.RetryAfterHeader;
import jain.protocol.ip.sip.header.RouteHeader;
import jain.protocol.ip.sip.header.ServerHeader;
import jain.protocol.ip.sip.header.SubjectHeader;
import jain.protocol.ip.sip.header.TimeStampHeader;
import jain.protocol.ip.sip.header.ToHeader;
import jain.protocol.ip.sip.header.UnsupportedHeader;
import jain.protocol.ip.sip.header.UserAgentHeader;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.header.WWWAuthenticateHeader;
import jain.protocol.ip.sip.header.WarningHeader;
import java.net.InetAddress;
import java.util.Date;
import java.util.List;

public class HeaderFactoryImpl
implements HeaderFactory {
    private static final LogMgr c_logger = Log.get(HeaderFactoryImpl.class);

    @Override
    public AcceptHeader createAcceptHeader(String contentType, String contentSubType) throws IllegalArgumentException, SipParseException {
        if (contentType == null) {
            throw new IllegalArgumentException("Null ContentType");
        }
        if (contentSubType == null) {
            throw new IllegalArgumentException("Null ContentSubType");
        }
        AcceptHeaderImpl acceptImpl = new AcceptHeaderImpl();
        acceptImpl.setContentType(contentType);
        acceptImpl.setContentSubType(contentSubType);
        return acceptImpl;
    }

    @Override
    public AcceptLanguageHeader createAcceptLanguageHeader(String languageRange) throws IllegalArgumentException, SipParseException {
        if (languageRange == null) {
            throw new IllegalArgumentException("Null LanguageRange");
        }
        AcceptLanguageHeaderImpl acceptLangImpl = new AcceptLanguageHeaderImpl();
        acceptLangImpl.setLanguageRange(languageRange);
        return acceptLangImpl;
    }

    @Override
    public AllowHeader createAllowHeader(String method) throws IllegalArgumentException, SipParseException {
        if (method == null) {
            throw new IllegalArgumentException("Null Method");
        }
        AllowHeaderImpl allowImpl = new AllowHeaderImpl();
        allowImpl.setMethod(method);
        return allowImpl;
    }

    @Override
    public TimeStampHeader createTimeStampHeader(float timeStamp) throws SipParseException {
        TimeStampHeaderImpl timeStampImpl = new TimeStampHeaderImpl();
        timeStampImpl.setTimeStamp(timeStamp);
        return timeStampImpl;
    }

    @Override
    public ViaHeader createViaHeader(String host) throws IllegalArgumentException, SipParseException {
        if (host == null) {
            throw new IllegalArgumentException("Null Host");
        }
        ViaHeaderImpl viaImpl = new ViaHeaderImpl();
        viaImpl.setHost(host);
        return viaImpl;
    }

    @Override
    public WarningHeader createWarningHeader(int code, String agent, String text) throws IllegalArgumentException, SipParseException {
        if (agent == null) {
            throw new IllegalArgumentException("Null agent");
        }
        if (text == null) {
            throw new IllegalArgumentException("Null text");
        }
        WarningHeaderImpl warningImpl = new WarningHeaderImpl();
        warningImpl.setText(text);
        warningImpl.setCode(code);
        warningImpl.setAgent(agent);
        return warningImpl;
    }

    @Override
    public RequireHeader createRequireHeader(String optionTag) throws IllegalArgumentException, SipParseException {
        if (optionTag == null) {
            throw new IllegalArgumentException("Null optionTag");
        }
        RequireHeaderImpl requireImpl = new RequireHeaderImpl();
        requireImpl.setOptionTag(optionTag);
        return requireImpl;
    }

    @Override
    public RetryAfterHeader createRetryAfterHeader(String date) throws IllegalArgumentException, SipParseException {
        if (date == null) {
            throw new IllegalArgumentException("Null date");
        }
        RetryAfterHeaderImpl retryAfterImpl = new RetryAfterHeaderImpl();
        retryAfterImpl.setDate(date);
        return retryAfterImpl;
    }

    @Override
    public AuthorizationHeader createAuthorizationHeader(String scheme) throws IllegalArgumentException, SipParseException {
        if (scheme == null) {
            throw new IllegalArgumentException("Null scheme");
        }
        AuthorizationHeaderImpl authImpl = new AuthorizationHeaderImpl();
        authImpl.setScheme(scheme);
        return authImpl;
    }

    @Override
    public ViaHeader createViaHeader(String host, String transport) throws IllegalArgumentException, SipParseException {
        if (host == null) {
            throw new IllegalArgumentException("Null Host");
        }
        if (transport == null) {
            throw new IllegalArgumentException("Null Transport");
        }
        ViaHeaderImpl viaImpl = new ViaHeaderImpl();
        viaImpl.setHost(host);
        viaImpl.setTransport(transport);
        return viaImpl;
    }

    @Override
    public CallIdHeader createCallIdHeader(String callId) throws IllegalArgumentException, SipParseException {
        if (callId == null) {
            throw new IllegalArgumentException("Null callId");
        }
        CallIdHeaderImpl callIdImpl = new CallIdHeaderImpl();
        callIdImpl.setCallId(callId);
        return callIdImpl;
    }

    @Override
    public ProxyRequireHeader createProxyRequireHeader(String optionTag) throws IllegalArgumentException, SipParseException {
        if (optionTag == null) {
            throw new IllegalArgumentException("Null optionTag is null");
        }
        ProxyRequireHeaderImpl proxyImpl = new ProxyRequireHeaderImpl();
        proxyImpl.setOptionTag(optionTag);
        return proxyImpl;
    }

    @Override
    public ContactHeader createContactHeader(NameAddress nameAddress) throws IllegalArgumentException, SipParseException {
        if (nameAddress == null) {
            throw new IllegalArgumentException("nameAddress is null ");
        }
        ContactHeaderImpl contactImpl = new ContactHeaderImpl();
        contactImpl.setNameAddress(nameAddress);
        return contactImpl;
    }

    @Override
    public RetryAfterHeader createRetryAfterHeader(long deltaSeconds) throws SipParseException {
        RetryAfterHeaderImpl retryImpl = new RetryAfterHeaderImpl();
        retryImpl.setDeltaSeconds(deltaSeconds);
        return retryImpl;
    }

    @Override
    public ContactHeader createContactHeader() {
        ContactHeaderImpl contactImpl = new ContactHeaderImpl();
        return contactImpl;
    }

    @Override
    public ServerHeader createServerHeader(List products) throws IllegalArgumentException, SipParseException {
        ServerHeaderImpl serverImpl = new ServerHeaderImpl();
        serverImpl.setProducts(products);
        return serverImpl;
    }

    @Override
    public ContentEncodingHeader createContentEncodingHeader(String contentEncoding) throws IllegalArgumentException, SipParseException {
        if (contentEncoding == null) {
            throw new IllegalArgumentException("Null ContentEncoding");
        }
        ContentEncodingHeaderImpl contentEncodingImpl = new ContentEncodingHeaderImpl();
        contentEncodingImpl.setEncoding(contentEncoding);
        return contentEncodingImpl;
    }

    @Override
    public UnsupportedHeader createUnsupportedHeader(String optionTag) throws IllegalArgumentException, SipParseException {
        if (optionTag == null) {
            throw new IllegalArgumentException("Null optionTag");
        }
        UnsupportedHeaderImpl unsupportedImpl = new UnsupportedHeaderImpl();
        unsupportedImpl.setOptionTag(optionTag);
        return unsupportedImpl;
    }

    @Override
    public ContentLengthHeader createContentLengthHeader(int contentLength) throws SipParseException {
        ContentLengthHeaderImpl contentLengthImpl = new ContentLengthHeaderImpl();
        contentLengthImpl.setContentLength(contentLength);
        return contentLengthImpl;
    }

    @Override
    public ViaHeader createViaHeader(int port, String host) throws IllegalArgumentException, SipParseException {
        if (host == null) {
            throw new IllegalArgumentException("Null host");
        }
        ViaHeaderImpl viaImpl = new ViaHeaderImpl();
        viaImpl.setPort(port);
        viaImpl.setHost(host);
        return viaImpl;
    }

    @Override
    public ContentTypeHeader createContentTypeHeader(String contentType, String contentSubType) throws IllegalArgumentException, SipParseException {
        if (contentType == null) {
            throw new IllegalArgumentException("Null contentType");
        }
        if (contentSubType == null) {
            throw new IllegalArgumentException("Null contentSubType");
        }
        ContentTypeHeaderImpl contentTypeImpl = new ContentTypeHeaderImpl();
        contentTypeImpl.setContentType(contentType);
        contentTypeImpl.setContentSubType(contentSubType);
        return contentTypeImpl;
    }

    @Override
    public ViaHeader createViaHeader(InetAddress host, int port, String transport) throws IllegalArgumentException, SipParseException {
        if (host == null) {
            throw new IllegalArgumentException("Null host");
        }
        if (transport == null) {
            throw new IllegalArgumentException("Null transport");
        }
        if (transport.compareToIgnoreCase("UDP") != 0 && transport.compareToIgnoreCase("TCP") != 0) {
            throw new SipParseException("Bad Transport: ", transport);
        }
        ViaHeaderImpl viaImpl = new ViaHeaderImpl();
        viaImpl.setHost(InetAddressCache.getHostAddress(host));
        viaImpl.setPort(port);
        viaImpl.setTransport(transport);
        return viaImpl;
    }

    @Override
    public CSeqHeader createCSeqHeader(long sequenceNumber, String method) throws IllegalArgumentException, SipParseException {
        if (method == null) {
            throw new IllegalArgumentException("Null method");
        }
        CSeqHeaderImpl cseqImpl = new CSeqHeaderImpl();
        cseqImpl.setSequenceNumber(sequenceNumber);
        cseqImpl.setMethod(method);
        return cseqImpl;
    }

    @Override
    public AcceptEncodingHeader createAcceptEncodingHeader(String contentEncoding) throws IllegalArgumentException, SipParseException {
        if (contentEncoding == null) {
            throw new IllegalArgumentException("Null contentEncoding");
        }
        AcceptEncodingHeaderImpl acceptImpl = new AcceptEncodingHeaderImpl();
        acceptImpl.setEncoding(contentEncoding);
        return acceptImpl;
    }

    @Override
    public DateHeader createDateHeader(String date) throws IllegalArgumentException, SipParseException {
        if (date == null) {
            throw new IllegalArgumentException("Null date");
        }
        DateHeaderImpl dateHeaderImpl = new DateHeaderImpl();
        dateHeaderImpl.setDate(date);
        return dateHeaderImpl;
    }

    @Override
    public RecordRouteHeader createRecordRouteHeader(NameAddress nameAddress) throws IllegalArgumentException, SipParseException {
        if (nameAddress == null) {
            throw new IllegalArgumentException("Null nameAddress");
        }
        RecordRouteHeaderImpl recordImpl = new RecordRouteHeaderImpl();
        recordImpl.setNameAddress(nameAddress);
        return recordImpl;
    }

    @Override
    public DateHeader createDateHeader(Date date) throws IllegalArgumentException, SipParseException {
        if (date == null) {
            throw new IllegalArgumentException("Null date");
        }
        DateHeaderImpl dateImpl = new DateHeaderImpl();
        dateImpl.setDate(date);
        return dateImpl;
    }

    @Override
    public ResponseKeyHeader createResponseKeyHeader(String scheme) throws IllegalArgumentException, SipParseException {
        if (scheme == null) {
            throw new IllegalArgumentException("Null scheme");
        }
        ResponseKeyHeaderImpl responseHeaderImpl = new ResponseKeyHeaderImpl();
        responseHeaderImpl.setScheme(scheme);
        return responseHeaderImpl;
    }

    @Override
    public EncryptionHeader createEncryptionHeader(String scheme) throws IllegalArgumentException, SipParseException {
        if (scheme == null) {
            throw new IllegalArgumentException("Null scheme");
        }
        EncryptionHeaderImpl encryptionImpl = new EncryptionHeaderImpl();
        encryptionImpl.setScheme(scheme);
        return encryptionImpl;
    }

    @Override
    public RetryAfterHeader createRetryAfterHeader(Date date) throws IllegalArgumentException, SipParseException {
        if (date == null) {
            throw new IllegalArgumentException("Null date");
        }
        RetryAfterHeaderImpl retryAfterImpl = new RetryAfterHeaderImpl();
        retryAfterImpl.setDate(date);
        return retryAfterImpl;
    }

    @Override
    public ExpiresHeader createExpiresHeader(long deltaSeconds) throws SipParseException {
        ExpiresHeaderImpl expiresImpl = new ExpiresHeaderImpl();
        expiresImpl.setDeltaSeconds(deltaSeconds);
        return expiresImpl;
    }

    @Override
    public RouteHeader createRouteHeader(NameAddress nameAddress) throws IllegalArgumentException, SipParseException {
        if (nameAddress == null) {
            throw new IllegalArgumentException("Null nameAddress");
        }
        RouteHeaderImpl routeImpl = new RouteHeaderImpl();
        routeImpl.setNameAddress(nameAddress);
        return routeImpl;
    }

    @Override
    public ExpiresHeader createExpiresHeader(Date date) throws IllegalArgumentException, SipParseException {
        if (date == null) {
            throw new IllegalArgumentException("Null date");
        }
        ExpiresHeaderImpl expiresImpl = new ExpiresHeaderImpl();
        expiresImpl.setDate(date);
        return expiresImpl;
    }

    @Override
    public SubjectHeader createSubjectHeader(String subject) throws IllegalArgumentException, SipParseException {
        if (subject == null) {
            throw new IllegalArgumentException("Null subject");
        }
        SubjectHeaderImpl subjectImpl = new SubjectHeaderImpl();
        subjectImpl.setSubject(subject);
        return subjectImpl;
    }

    @Override
    public ExpiresHeader createExpiresHeader(String date) throws IllegalArgumentException, SipParseException {
        if (date == null) {
            throw new IllegalArgumentException("JAIN-SIP EXCEPTION : date is null ");
        }
        ExpiresHeaderImpl expiresHeaderImpl = new ExpiresHeaderImpl();
        expiresHeaderImpl.setDate(date);
        return expiresHeaderImpl;
    }

    @Override
    public ToHeader createToHeader(NameAddress nameAddress) throws IllegalArgumentException, SipParseException {
        if (nameAddress == null) {
            throw new IllegalArgumentException("nameAddress is null ");
        }
        ToHeaderImpl toImpl = new ToHeaderImpl();
        toImpl.setNameAddress(nameAddress);
        return toImpl;
    }

    @Override
    public FromHeader createFromHeader(NameAddress nameAddress) throws IllegalArgumentException, SipParseException {
        if (nameAddress == null) {
            throw new IllegalArgumentException("nameAddress is null ");
        }
        FromHeaderImpl fromImpl = new FromHeaderImpl();
        fromImpl.setNameAddress(nameAddress);
        return fromImpl;
    }

    @Override
    public UserAgentHeader createUserAgentHeader(List products) throws IllegalArgumentException, SipParseException {
        UserAgentHeaderImpl userAgentImpl = new UserAgentHeaderImpl();
        userAgentImpl.setProducts(products);
        return userAgentImpl;
    }

    @Override
    public Header createHeader(String name, String value) throws IllegalArgumentException, SipParseException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (value == null) {
            throw new IllegalArgumentException("Null value");
        }
        HeaderImpl hdr = HeaderCreator.createHeader(name);
        hdr.setValue(value);
        try {
            hdr.parse();
        }
        catch (SipParseException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createHeader", "Failed to parse value = " + value + " for header = " + name);
            }
            throw e2;
        }
        return hdr;
    }

    @Override
    public ViaHeader createViaHeader(InetAddress host) throws IllegalArgumentException, SipParseException {
        if (host == null) {
            throw new IllegalArgumentException("Null host");
        }
        ViaHeaderImpl viaImpl = new ViaHeaderImpl();
        viaImpl.setHost(InetAddressCache.getHostAddress(host));
        viaImpl.setTransport("UDP");
        return viaImpl;
    }

    @Override
    public HideHeader createHideHeader(String hide) throws IllegalArgumentException, SipParseException {
        if (hide == null) {
            throw new IllegalArgumentException("Null hide");
        }
        HideHeaderImpl hideImpl = new HideHeaderImpl();
        hideImpl.setHide(hide);
        return hideImpl;
    }

    @Override
    public ViaHeader createViaHeader(int port, InetAddress host) throws IllegalArgumentException, SipParseException {
        if (host == null) {
            throw new IllegalArgumentException("Null host");
        }
        ViaHeaderImpl viaImpl = new ViaHeaderImpl();
        viaImpl.setHost(host);
        viaImpl.setPort(port);
        viaImpl.setTransport("TCP");
        return viaImpl;
    }

    @Override
    public MaxForwardsHeader createMaxForwardsHeader(int maxForwards) throws SipParseException {
        MaxForwardsHeaderImpl maxImpl = new MaxForwardsHeaderImpl();
        maxImpl.setMaxForwards(maxForwards);
        return maxImpl;
    }

    @Override
    public ViaHeader createViaHeader(InetAddress host, String transport) throws IllegalArgumentException, SipParseException {
        if (host == null) {
            throw new IllegalArgumentException("Null host");
        }
        if (transport == null) {
            throw new IllegalArgumentException("Null transport");
        }
        ViaHeaderImpl viaImpl = new ViaHeaderImpl();
        viaImpl.setHost(host);
        viaImpl.setTransport(transport);
        return viaImpl;
    }

    @Override
    public OrganizationHeader createOrganizationHeader(String organization) throws IllegalArgumentException, SipParseException {
        if (organization == null) {
            throw new IllegalArgumentException("Null organization");
        }
        OrganizationHeaderImpl orgImpl = new OrganizationHeaderImpl();
        orgImpl.setOrganization(organization);
        return orgImpl;
    }

    @Override
    public ViaHeader createViaHeader(String host, int port, String transport) throws IllegalArgumentException, SipParseException {
        if (host == null) {
            throw new IllegalArgumentException("Null host");
        }
        if (transport == null) {
            throw new IllegalArgumentException("Null transport");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Bad port");
        }
        ViaHeaderImpl viaImpl = new ViaHeaderImpl();
        viaImpl.setHost(host);
        viaImpl.setPort(port);
        viaImpl.setTransport(transport);
        return viaImpl;
    }

    @Override
    public PriorityHeader createPriorityHeader(String priority) throws IllegalArgumentException, SipParseException {
        if (priority == null) {
            throw new IllegalArgumentException("Null priority");
        }
        PriorityHeaderImpl priorityImpl = new PriorityHeaderImpl();
        priorityImpl.setPriority(priority);
        return priorityImpl;
    }

    @Override
    public WWWAuthenticateHeader createWWWAuthenticateHeader(String scheme) throws IllegalArgumentException, SipParseException {
        if (scheme == null) {
            throw new IllegalArgumentException("Null scheme");
        }
        WWWAuthenticateHeaderImpl wwwImpl = new WWWAuthenticateHeaderImpl();
        wwwImpl.setScheme(scheme);
        return wwwImpl;
    }

    @Override
    public ProxyAuthenticateHeader createProxyAuthenticateHeader(String scheme) throws IllegalArgumentException, SipParseException {
        if (scheme == null) {
            throw new IllegalArgumentException("Null scheme");
        }
        ProxyAuthenticateHeaderImpl proxyImpl = new ProxyAuthenticateHeaderImpl();
        proxyImpl.setScheme(scheme);
        return proxyImpl;
    }

    @Override
    public ProxyAuthorizationHeader createProxyAuthorizationHeader(String scheme) throws IllegalArgumentException, SipParseException {
        if (scheme == null) {
            throw new IllegalArgumentException("Null scheme");
        }
        ProxyAuthorizationHeaderImpl proxyImpl = new ProxyAuthorizationHeaderImpl();
        proxyImpl.setScheme(scheme);
        return proxyImpl;
    }
}

