/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sip.util.seqlog;

import com.ibm.sip.util.seqlog.SequenceLogger;
import com.ibm.ws.sip.parser.util.ObjectPool;
import java.util.Calendar;

public class LogEvent {
    public static final int NORMAL = 256;
    public static final int COMPLETED = 4096;
    public static final int WARNING = 65536;
    public static final int ERROR = 0x100000;
    public static final int ALL_LEVELS = 0x111100;
    protected int _state = -1;
    protected long _time;
    private static long c_baseTime;
    private static ObjectPool c_pool;

    protected void dump(StringBuffer buf, SequenceLogger contextLogger) {
        this.dumpTime(buf);
        buf.append("  ");
        LogEvent.dumpLevelAsString(buf, this._state);
        buf.append(", State:");
        contextLogger.dumpStateDesc(this._state, buf);
    }

    protected void dumpTime(StringBuffer buf) {
        int t = (int)(this._time - c_baseTime);
        int ms = t % 1000;
        int sec = (t /= 1000) % 60;
        int min = (t /= 60) % 60;
        int hrs = (t /= 60) % 60;
        buf.append(hrs);
        buf.append(':');
        buf.append(min);
        buf.append(':');
        buf.append(sec);
        buf.append(':');
        buf.append(ms);
    }

    public static void dumpLevelAsString(StringBuffer buf, int state) {
        if ((state & 0x100000) == 0x100000) {
            buf.append("Error");
        } else if ((state & 0x10000) == 65536) {
            buf.append("Warning");
        } else if ((state & 0x1000) == 4096) {
            buf.append("Completed");
        } else if ((state & 0x100) == 256) {
            buf.append("Normal");
        } else {
            buf.append(Integer.toHexString(state & 0x111100));
        }
    }

    protected static LogEvent getInstance() {
        return (LogEvent)c_pool.get();
    }

    protected void returnToPool() {
        this.clear();
        c_pool.putBack(this);
    }

    protected void clear() {
        this._state = -1;
        this._time = -1L;
    }

    protected void update(int state) {
        this._state = state;
        this._time = System.currentTimeMillis();
    }

    static {
        c_pool = new ObjectPool(LogEvent.class, null, -1);
        Calendar c = Calendar.getInstance();
        c.set(10, 0);
        c.set(13, 0);
        c.set(12, 0);
        c.set(14, 0);
        c_baseTime = c.getTimeInMillis();
    }
}

