/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.container;

import javax.faces.application.ApplicationFactory;

public class JSFContainer {
    public static final String MOJARRA_APP_FACTORY = "com.sun.faces.application.ApplicationFactoryImpl";
    public static final String MYFACES_APP_FACTORY = "org.apache.myfaces.application.ApplicationFactoryImpl";

    public static boolean isBeanValidationEnabled() {
        return JSFContainer.tryLoad("com.ibm.ws.beanvalidation.accessor.BeanValidationAccessor") != null;
    }

    public static void initializeBeanValidation() {
        try {
            Class<?> BvalJSFInitializer2 = Class.forName("com.ibm.ws.jsf.container.bval.BvalJSFInitializer");
            BvalJSFInitializer2.getMethod("initialize", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public static Class<?> tryLoad(String className) {
        try {
            return Class.forName(className, false, JSFContainer.class.getClassLoader());
        }
        catch (ClassNotFoundException notFound) {
            return null;
        }
    }

    public static JSF_PROVIDER getJSFProvider() throws ClassNotFoundException {
        String implTitle = ApplicationFactory.class.getPackage().getImplementationTitle();
        if (implTitle != null) {
            if (implTitle.toUpperCase().contains("MOJARRA")) {
                return JSF_PROVIDER.MOJARRA;
            }
            if (implTitle.toUpperCase().contains("MYFACES")) {
                return JSF_PROVIDER.MYFACES;
            }
        }
        if (JSFContainer.tryLoad(MOJARRA_APP_FACTORY) != null) {
            return JSF_PROVIDER.MOJARRA;
        }
        if (JSFContainer.tryLoad(MYFACES_APP_FACTORY) != null) {
            return JSF_PROVIDER.MYFACES;
        }
        throw new ClassNotFoundException();
    }

    public static String getJSFSpecLevel() {
        String jsfSpecLevel = System.getProperty("com.ibm.ws.jsfContainer.JSF_SPEC_LEVEL");
        if (jsfSpecLevel == null || jsfSpecLevel.isEmpty()) {
            throw new IllegalStateException("The system property 'com.ibm.ws.jsfContainer.JSF_SPEC_LEVEL' was null.");
        }
        return jsfSpecLevel;
    }

    public static enum JSF_PROVIDER {
        MOJARRA,
        MYFACES;

    }
}

