/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.ldap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.security.wim.adapter.ldap.LdapHelper;
import com.ibm.wsspi.security.wim.exception.MissingInitPropertyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class LdapEntity {
    private String iQEntityType = null;
    private String[][] iWIMRDNProps = null;
    private String[][] iWIMRDNAttrs = null;
    private String[][] iRDNAttrs = null;
    private String[][] iRDNObjectClass = null;
    private List<String> iObjectClasses = null;
    private Attribute[] iObjectClassAttrs = null;
    private String[] iSearchBases = null;
    private boolean iSearchBaseConfigured = false;
    private List<String> iSearchBaseList = null;
    private String iSearchFilter = null;
    private Set<String> iProps = null;
    private Map<String, String> iPropToAttrMap = null;
    private Map<String, Set<String>> iAttrToPropMap = null;
    private String iExtId = null;
    private boolean iTranslatedRDN = false;
    private Set<String> iAttrs = null;
    private static final TraceComponent tc = Tr.register(LdapEntity.class, (String)"ldapUtil", (String)"com.ibm.ws.security.wim.adapter.ldap.resources.LdapUtilMessages");
    static final long serialVersionUID = -1565937222138678729L;

    public LdapEntity(String entityType) {
        this.iQEntityType = entityType;
        this.iAttrToPropMap = new Hashtable<String, Set<String>>();
        this.iPropToAttrMap = new Hashtable<String, String>();
        this.iAttrs = new HashSet<String>();
        this.iProps = new HashSet<String>();
    }

    public LdapEntity(String entityType, String entityTypeSearchFilter, String[] objectClasses, List<Map<String, Object>> rdnConfigs) throws MissingInitPropertyException {
        this.iQEntityType = entityType;
        this.setRDNAttributes(rdnConfigs);
        if (objectClasses != null) {
            this.setObjectClasses(Arrays.asList(objectClasses));
        }
        if (objectClasses != null) {
            ArrayList<String> objClsCreate = new ArrayList<String>(objectClasses.length);
            for (int i = 0; i < objectClasses.length; ++i) {
                objClsCreate.add(objectClasses[i]);
            }
            this.setObjectClassesForCreate(objClsCreate);
        }
        this.iSearchBaseConfigured = this.getSearchBases() != null;
        this.setSearchFilter(entityTypeSearchFilter);
        this.iAttrToPropMap = new Hashtable<String, Set<String>>();
        this.iPropToAttrMap = new Hashtable<String, String>();
        this.iAttrs = new HashSet<String>();
        this.iProps = new HashSet<String>();
    }

    public Set<String> getAttributes() {
        return this.iAttrs;
    }

    public String[][] getWIMRDNProperties() {
        return (String[][])this.iWIMRDNProps.clone();
    }

    public String[][] getRDNAttributes() {
        if (this.iRDNAttrs == null) {
            if (this.iWIMRDNAttrs != null) {
                return (String[][])this.iWIMRDNAttrs.clone();
            }
            return null;
        }
        return (String[][])this.iRDNAttrs.clone();
    }

    public String[][] getRDNObjectclasses() {
        return (String[][])this.iRDNObjectClass.clone();
    }

    public String getName() {
        return this.iQEntityType;
    }

    public Collection<? extends String> getSearchBaseList() {
        return this.iSearchBaseList;
    }

    public String getSearchFilter() {
        return this.iSearchFilter;
    }

    public boolean startWithSameRDN(String dn) {
        dn = dn.toLowerCase();
        String[][] rdnAttrs = this.iRDNAttrs != null ? this.iRDNAttrs : this.iWIMRDNAttrs;
        for (int i = 0; i < rdnAttrs.length; ++i) {
            String[] attrs = rdnAttrs[i];
            for (int j = 0; j < attrs.length; ++j) {
                if (!dn.startsWith(attrs[j])) continue;
                return true;
            }
        }
        return false;
    }

    public String[][] getWIMRDNAttributes() {
        return this.iWIMRDNAttrs;
    }

    public boolean isSearchBaseConfigured() {
        return this.iSearchBaseConfigured;
    }

    public String getAttribute(String propName) {
        String attrName = this.iPropToAttrMap.get(propName);
        if (attrName != null) {
            return attrName;
        }
        return null;
    }

    public Set<String> getProperty(String attrName) {
        return this.iAttrToPropMap.get(attrName.toLowerCase());
    }

    public boolean needTranslateRDN() {
        return this.iTranslatedRDN;
    }

    public String getExtId() {
        return this.iExtId;
    }

    public List<String> getRDNAttributesList() {
        String[][] rdnAttrs = this.getRDNAttributes();
        ArrayList<String> rdnList = new ArrayList<String>();
        for (int i = 0; i < rdnAttrs.length; ++i) {
            for (int j = 0; j < rdnAttrs[i].length; ++j) {
                rdnList.add(rdnAttrs[i][j]);
            }
        }
        return rdnList;
    }

    public List<String> getObjectClasses() {
        return this.iObjectClasses;
    }

    public String[] getSearchBases() {
        return this.iSearchBases;
    }

    public void setSearchBases(String[] searchBases) {
        this.iSearchBases = searchBases;
        this.iSearchBaseList = new ArrayList<String>(this.iSearchBases.length);
        for (int i = 0; i < this.iSearchBases.length; ++i) {
            this.iSearchBaseList.add(this.iSearchBases[i]);
        }
        this.iSearchBaseConfigured = true;
    }

    public void setObjectClasses(List<String> objectClasses) {
        int size = objectClasses.size();
        this.iObjectClasses = new ArrayList<String>(objectClasses.size());
        for (int i = 0; i < size; ++i) {
            String objectClass = objectClasses.get(i).toLowerCase();
            if (this.iObjectClasses.contains(objectClass)) continue;
            this.iObjectClasses.add(objectClass);
        }
    }

    public void setObjectClassesForCreate(List<String> objectClasses) {
        if (this.iRDNObjectClass != null && this.iRDNObjectClass.length > 1) {
            int i;
            this.iObjectClassAttrs = new Attribute[this.iRDNObjectClass.length];
            for (i = 0; i < this.iRDNObjectClass.length; ++i) {
                this.iObjectClassAttrs[i] = new BasicAttribute("objectClass", this.iRDNObjectClass[i][0]);
                objectClasses.remove(this.iRDNObjectClass[i][0]);
            }
            for (i = 0; i < this.iObjectClassAttrs.length; ++i) {
                for (int j = 0; j < objectClasses.size(); ++j) {
                    this.iObjectClassAttrs[i].add(objectClasses.get(j));
                }
            }
        } else {
            this.iObjectClassAttrs = new Attribute[1];
            this.iObjectClassAttrs[0] = new BasicAttribute("objectClass");
            if (objectClasses.size() > 0) {
                for (int i = 0; i < objectClasses.size(); ++i) {
                    this.iObjectClassAttrs[0].add(objectClasses.get(i));
                }
            } else {
                for (int i = 0; i < this.iObjectClasses.size(); ++i) {
                    this.iObjectClassAttrs[0].add(this.iObjectClasses.get(i));
                }
            }
        }
    }

    public void setSearchFilter(String filter) {
        if (filter != null && filter.trim().length() > 0) {
            if ((filter = filter.trim()).length() > 0) {
                if (filter.charAt(0) != '(' || filter.charAt(filter.length() - 1) != ')') {
                    filter = "(" + filter + ")";
                }
                this.iSearchFilter = filter;
            }
        } else if (this.iObjectClasses != null) {
            int n = this.iObjectClasses.size();
            StringBuffer filterBuffer = new StringBuffer(n * 20);
            if (n > 1) {
                filterBuffer.append("(|");
            }
            for (int i = 0; i < n; ++i) {
                filterBuffer.append("(").append("objectClass").append("=").append(this.iObjectClasses.get(i)).append(")");
            }
            if (n > 1) {
                filterBuffer.append(")");
            }
            this.iSearchFilter = filterBuffer.toString();
        }
    }

    public void setRDNAttributes(String[][] RDNAttrs, String[][] RDNObjCls) {
        this.iRDNAttrs = RDNAttrs;
        this.iRDNObjectClass = RDNObjCls;
    }

    public void addPropertyAttributeMap(String propName, String attrName) {
        String realPropName = propName;
        if (propName.equalsIgnoreCase("ibm-primaryEmail")) {
            realPropName = "ibmPrimaryEmail";
        } else if (propName.equalsIgnoreCase("ibm-jobTitle")) {
            realPropName = "ibmJobTitle";
        }
        if (propName.equalsIgnoreCase("ibmPrimaryEmail") && attrName.equalsIgnoreCase("ibmPrimaryEmail")) {
            attrName = "ibm-primaryEmail";
        }
        if (propName.equalsIgnoreCase("ibmJobTitle") && attrName.equalsIgnoreCase("ibmJobTitle")) {
            attrName = "ibm-jobTitle";
        }
        if (propName.equalsIgnoreCase("ibm-primaryEmail") || propName.equalsIgnoreCase("ibm-jobTitle")) {
            this.iPropToAttrMap.put(realPropName, attrName);
            this.iPropToAttrMap.put(propName, attrName);
        } else {
            this.iPropToAttrMap.put(realPropName, attrName);
        }
        String attrKey = attrName.toLowerCase();
        Set<String> propSet = this.iAttrToPropMap.get(attrKey);
        if (propSet == null) {
            propSet = new HashSet<String>();
            this.iAttrToPropMap.put(attrKey, propSet);
        }
        if (propName.equalsIgnoreCase("ibm-primaryEmail") || propName.equalsIgnoreCase("ibm-jobTitle")) {
            propSet.add(realPropName);
            propSet.add(propName);
            this.addProperty(propName);
            this.addProperty(realPropName);
        } else {
            propSet.add(realPropName);
            this.addProperty(realPropName);
        }
        this.addAttribute(attrName);
    }

    private void addProperty(String propName) {
        this.iProps.add(propName);
    }

    private void addAttribute(String attrName) {
        this.iAttrs.add(attrName);
    }

    public void setExtId(String attrName) {
        this.iExtId = attrName;
    }

    public void addObjectClass(String objectClass) {
        if (!this.iObjectClasses.contains(objectClass = objectClass.toLowerCase())) {
            this.iObjectClasses.add(objectClass);
        }
    }

    public void setRDNProperties(String[][] rdnProps, String[][] rdnAttrs) {
        this.iWIMRDNAttrs = rdnAttrs;
        this.iWIMRDNProps = rdnProps;
        if (this.iRDNAttrs != null) {
            if (this.iRDNAttrs.length != this.iWIMRDNAttrs.length) {
                this.iTranslatedRDN = true;
                return;
            }
            for (int i = 0; i < this.iRDNAttrs.length; ++i) {
                if (Arrays.equals(this.iRDNAttrs[i], this.iWIMRDNAttrs[i])) continue;
                this.iTranslatedRDN = true;
                return;
            }
        } else {
            for (int i = 0; i < this.iWIMRDNAttrs.length; ++i) {
                if (Arrays.equals(this.iWIMRDNAttrs[i], this.iWIMRDNProps[i])) continue;
                this.iTranslatedRDN = true;
                return;
            }
        }
    }

    public void setRDNAttributes(List<Map<String, Object>> rdnAttrList) throws MissingInitPropertyException {
        int size = rdnAttrList.size();
        if (size > 0) {
            this.iRDNAttrs = new String[size][];
            this.iRDNObjectClass = new String[size][];
            if (size == 1) {
                Map<String, Object> rdnAttr = rdnAttrList.get(0);
                String[] rdns = LdapHelper.getRDNs((String)rdnAttr.get("name"));
                this.iRDNAttrs[0] = rdns;
            } else {
                int i = 0;
                for (Map<String, Object> rdnAttr : rdnAttrList) {
                    String name = (String)rdnAttr.get("name");
                    String[] rdns = LdapHelper.getRDNs(name);
                    this.iRDNAttrs[i] = rdns;
                    String[] objCls = (String[])rdnAttr.get("objectClass");
                    if (objCls == null) {
                        throw new MissingInitPropertyException("MISSING_INI_PROPERTY", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_INI_PROPERTY", (Object[])WIMMessageHelper.generateMsgParms((Object)"objectClass")));
                    }
                    this.iRDNObjectClass[i] = objCls;
                    ++i;
                }
            }
        }
    }

    public Attribute getObjectClassAttribute(String dn) {
        if (this.iObjectClassAttrs.length == 1 || dn == null) {
            return this.iObjectClassAttrs[0];
        }
        String[] rdns = LdapHelper.getRDNAttributes(dn);
        for (int i = 0; i < this.iRDNAttrs.length; ++i) {
            String[] attrs = this.iRDNAttrs[i];
            for (int j = 0; j < attrs.length; ++j) {
                for (int k = 0; k < attrs.length; ++k) {
                    if (!attrs[j].equals(rdns[k])) continue;
                    return this.iObjectClassAttrs[i];
                }
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append(":{");
        sb.append("EntityType=").append(this.iQEntityType);
        if (this.iExtId != null) {
            sb.append(", ExternalID=").append(this.iExtId);
        }
        if (this.iAttrs != null && !this.iAttrs.isEmpty()) {
            sb.append(", Attributes=").append(this.iAttrs);
        }
        if (this.iAttrToPropMap != null && !this.iAttrToPropMap.isEmpty()) {
            sb.append(", AttributeToPropertyMap=").append(this.iAttrToPropMap);
        }
        if (this.iProps != null && !this.iProps.isEmpty()) {
            sb.append(", Properties=").append(this.iProps);
        }
        if (this.iPropToAttrMap != null && !this.iPropToAttrMap.isEmpty()) {
            sb.append(", PropertyToAttributeMap=").append(this.iPropToAttrMap);
        }
        if (this.iObjectClassAttrs != null && this.iObjectClassAttrs.length != 0) {
            sb.append(", ObjectClassAttributes=").append(Arrays.toString(this.iObjectClassAttrs));
        }
        if (this.iObjectClasses != null && !this.iObjectClasses.isEmpty()) {
            sb.append(", ObjectClasses=").append(this.iObjectClasses);
        }
        sb.append(", iSearchBaseConfigured=").append(this.iSearchBaseConfigured);
        if (this.iSearchBaseList != null && !this.iSearchBaseList.isEmpty()) {
            sb.append(", SearchBases=").append(this.iSearchBaseList);
        }
        if (this.iSearchFilter != null) {
            sb.append(", SearchFilter=").append(this.iSearchFilter);
        }
        sb.append(", iTranslatedRDN=").append(this.iTranslatedRDN);
        if (this.iRDNAttrs != null && this.iRDNAttrs.length != 0) {
            sb.append(", RDNAttributes=").append(Arrays.deepToString((Object[])this.iRDNAttrs));
        }
        if (this.iRDNObjectClass != null && this.iRDNObjectClass.length != 0) {
            sb.append(", RDNObjectClass=").append(Arrays.deepToString((Object[])this.iRDNObjectClass));
        }
        if (this.iWIMRDNAttrs != null && this.iWIMRDNAttrs.length != 0) {
            sb.append(", WIMRDNAttrs=").append(Arrays.deepToString((Object[])this.iWIMRDNAttrs));
        }
        if (this.iWIMRDNProps != null && this.iWIMRDNProps.length != 0) {
            sb.append(", WIMRDNProps=").append(Arrays.deepToString((Object[])this.iWIMRDNProps));
        }
        sb.append("}");
        return sb.toString();
    }
}

