/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.directives;

import graphql.Internal;
import graphql.execution.ValuesResolver;
import graphql.language.Directive;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLSchema;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public class DirectivesResolver {
    private final ValuesResolver valuesResolver = new ValuesResolver();

    public Map<String, GraphQLDirective> resolveDirectives(List<Directive> directives, GraphQLSchema schema, Map<String, Object> variables) {
        GraphQLCodeRegistry codeRegistry = schema.getCodeRegistry();
        LinkedHashMap<String, GraphQLDirective> directiveMap = new LinkedHashMap<String, GraphQLDirective>();
        directives.forEach(directive -> {
            GraphQLDirective protoType = schema.getDirective(directive.getName());
            if (protoType != null) {
                GraphQLDirective newDirective = protoType.transform(builder -> this.buildArguments((GraphQLDirective.Builder)builder, codeRegistry, protoType, (Directive)directive, variables));
                directiveMap.put(newDirective.getName(), newDirective);
            }
        });
        return directiveMap;
    }

    private void buildArguments(GraphQLDirective.Builder directiveBuilder, GraphQLCodeRegistry codeRegistry, GraphQLDirective protoType, Directive fieldDirective, Map<String, Object> variables) {
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(codeRegistry, protoType.getArguments(), fieldDirective.getArguments(), variables);
        directiveBuilder.clearArguments();
        protoType.getArguments().forEach(protoArg -> {
            if (argumentValues.containsKey(protoArg.getName())) {
                Object argValue = argumentValues.get(protoArg.getName());
                GraphQLArgument newArgument = protoArg.transform(argBuilder -> argBuilder.value(argValue));
                directiveBuilder.argument(newArgument);
            } else {
                GraphQLArgument newArgument = protoArg.transform(argBuilder -> argBuilder.value(null));
                directiveBuilder.argument(newArgument);
            }
        });
    }
}

