/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.impl.DatabaseHelper;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.util.Collections;
import java.util.HashSet;
import javax.resource.ResourceException;

public class DerbyHelper
extends DatabaseHelper {
    protected static final com.ibm.ejs.ras.TraceComponent derbyTc = Tr.register((String)"com.ibm.ws.derby.logwriter", (String)"WAS.database", null);
    private transient PrintWriter derbyPw = null;

    DerbyHelper(WSManagedConnectionFactoryImpl mcf) {
        super(mcf);
        mcf.supportsGetTypeMap = false;
    }

    @Override
    void customizeStaleStates() {
        super.customizeStaleStates();
        Collections.addAll(this.staleErrorCodes, 40000, 45000, 50000);
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        stmt.setCursorName(null);
        stmt.setFetchDirection(1000);
        stmt.setMaxFieldSize(0);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }

    @Override
    public int getDefaultIsolationLevel() {
        return 4;
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return derbyTc;
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.derbyPw == null) {
            this.derbyPw = new PrintWriter((Writer)new TraceWriter(derbyTc), true);
        }
        com.ibm.websphere.ras.Tr.debug((TraceComponent)derbyTc, (String)"returning", (Object[])new Object[]{this.derbyPw});
        return this.derbyPw;
    }

    @Override
    boolean isAuthException(SQLException x) {
        return x instanceof SQLInvalidAuthorizationSpecException || "08004".equals(x.getSQLState()) || "04501".equals(x.getSQLState());
    }

    @Override
    public boolean isStaleStatement(SQLException x) {
        HashSet<SQLException> chain = new HashSet<SQLException>();
        for (Throwable t = x; t != null && chain.add((SQLException)t); t = t.getCause()) {
            String ss;
            if (!(t instanceof SQLException) || !"XCL10".equals(ss = t.getSQLState())) continue;
            return true;
        }
        return super.isStaleStatement(x);
    }

    @Override
    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl mcf) {
        return TraceComponent.isAnyTracingEnabled() && derbyTc.isDebugEnabled() && !mcf.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return this.shouldTraceBeEnabled(mc.mcf);
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return TraceComponent.isAnyTracingEnabled() && !derbyTc.isDebugEnabled() && mc.mcf.loggingEnabled;
    }
}

