/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.config.internal.serverxml;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.application.Application;
import io.openliberty.microprofile.config.internal.serverxml.AppPropertiesComponent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class AppPropertiesTrackingComponent {
    private static volatile AppPropertiesTrackingComponent instance;
    private final Map<String, AppPropertiesComponent> propertiesComponentByPid = new HashMap<String, AppPropertiesComponent>();
    private final Map<String, List<String>> propertyPidByApp = new HashMap<String, List<String>>();
    private final Map<String, Map<String, String>> propertiesByApp = new ConcurrentHashMap<String, Map<String, String>>();
    static final long serialVersionUID = -3970155880349103465L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate() {
        instance = this;
    }

    @Deactivate
    protected void deactivate() {
        if (instance == this) {
            instance = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addAppPropertiesComponent(AppPropertiesComponent apc) {
        this.propertiesComponentByPid.put(apc.getPid(), apc);
        this.updateAppsUsingProperties(apc.getPid());
    }

    protected void updatedAppPropertiesComponent(AppPropertiesComponent apc) {
        this.updateAppsUsingProperties(apc.getPid());
    }

    protected void removeAppPropertiesComponent(AppPropertiesComponent apc) {
        this.propertiesComponentByPid.remove(apc.getPid(), apc);
        this.updateAppsUsingProperties(apc.getPid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, service=Application.class)
    protected void addApp(Map<String, Object> appProps) {
        String appPid = (String)appProps.get("service.pid");
        String[] appPropertiesPids = (String[])appProps.get("appProperties");
        if (appPid != null && appPropertiesPids != null) {
            AppPropertiesTrackingComponent appPropertiesTrackingComponent = this;
            synchronized (appPropertiesTrackingComponent) {
                this.propertyPidByApp.put(appPid, Arrays.asList(appPropertiesPids));
                this.updateAppProperties(appPid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedApp(Map<String, Object> appProps) {
        String appPid = (String)appProps.get("service.pid");
        String[] appPropertiesPids = (String[])appProps.get("appProperties");
        if (appPid != null && appPropertiesPids != null) {
            AppPropertiesTrackingComponent appPropertiesTrackingComponent = this;
            synchronized (appPropertiesTrackingComponent) {
                this.propertyPidByApp.put(appPid, Arrays.asList(appPropertiesPids));
                this.updateAppProperties(appPid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeApp(Map<String, Object> appProps) {
        String appPid = (String)appProps.get("service.pid");
        if (appPid != null) {
            AppPropertiesTrackingComponent appPropertiesTrackingComponent = this;
            synchronized (appPropertiesTrackingComponent) {
                this.propertyPidByApp.remove(appPid);
                this.updateAppProperties(appPid);
            }
        }
    }

    private void updateAppsUsingProperties(String appPropertiesPid) {
        for (Map.Entry<String, List<String>> entry : this.propertyPidByApp.entrySet()) {
            if (!entry.getValue().contains(appPropertiesPid)) continue;
            this.updateAppProperties(entry.getKey());
        }
    }

    private void updateAppProperties(String appPid) {
        HashMap<String, String> newProperties = new HashMap<String, String>();
        List<String> properitesPids = this.propertyPidByApp.get(appPid);
        if (properitesPids != null) {
            for (String propertiesPid : properitesPids) {
                AppPropertiesComponent propertiesComponent = this.propertiesComponentByPid.get(propertiesPid);
                if (propertiesComponent == null) continue;
                newProperties.putAll(propertiesComponent.getProperties());
            }
        }
        if (newProperties.isEmpty()) {
            this.propertiesByApp.remove(appPid);
        } else {
            this.propertiesByApp.put(appPid, Collections.unmodifiableMap(newProperties));
        }
    }

    public static Map<String, String> getAppProperties(String appPid) {
        AppPropertiesTrackingComponent instance = AppPropertiesTrackingComponent.instance;
        if (instance == null) {
            return Collections.emptyMap();
        }
        Map<String, String> properties = instance.propertiesByApp.get(appPid);
        if (properties == null) {
            return Collections.emptyMap();
        }
        return properties;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.config.internal.serverxml.AppPropertiesTrackingComponent", AppPropertiesTrackingComponent.class, (String)"APPCONFIG", (String)"io.openliberty.microprofile.config.internal.serverxml");
    }
}

