/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.service;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.internal.BootstrapContextImpl;
import com.ibm.ws.jca.internal.ResourceAdapterMetaData;
import com.ibm.ws.jca.internal.Utils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AdminObjectService
implements ResourceFactory,
ApplicationRecycleComponent {
    private static final TraceComponent tc = Tr.register(AdminObjectService.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.internal.resources.J2CAMessages");
    public static final String JNDI_NAME = "jndiName";
    public static final String ADMIN_OBJECT_PID = "com.ibm.ws.jca.adminObject.supertype";
    public static final String ADMIN_OBJECT = "adminObject";
    private static final String CONFIG_PROPS_PREFIX = "properties.0.";
    private static final int CONFIG_PROPS_PREFIX_LENGTH = "properties.0.".length();
    private String adminObjectImplClassName;
    private final Set<String> applications = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicServiceReference<BootstrapContextImpl> bootstrapContextRef = new AtomicServiceReference("bootstrapContext");
    private String name;
    private String id;
    private String jndiName;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    static final long serialVersionUID = -2826150750689914359L;

    @Trivial
    @ManualTrace
    protected void activate(ComponentContext context) throws Exception {
        Dictionary props = context.getProperties();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{props});
        }
        this.adminObjectImplClassName = (String)props.get("properties.0.adminobject-class");
        this.name = (String)props.get("config.id");
        this.id = (String)props.get("id");
        this.jndiName = (String)props.get(JNDI_NAME);
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            String propName;
            String key = (String)keys.nextElement();
            if (key.length() <= CONFIG_PROPS_PREFIX_LENGTH || key.charAt(CONFIG_PROPS_PREFIX_LENGTH - 1) != '.' || !key.startsWith(CONFIG_PROPS_PREFIX) || (propName = key.substring(CONFIG_PROPS_PREFIX_LENGTH)).indexOf(46) >= 0 || propName.indexOf(45) >= 0) continue;
            this.properties.put(propName, props.get(key));
        }
        this.bootstrapContextRef.activate(context);
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"activate");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public Object createResource(ResourceInfo refInfo) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"createResource", (Object[])new Object[]{refInfo});
        }
        try {
            BootstrapContextImpl bootstrapContext = (BootstrapContextImpl)this.bootstrapContextRef.getServiceWithException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"loading", (Object[])new Object[]{this.adminObjectImplClassName});
            }
            Class<?> adminObjectClass = bootstrapContext.loadClass(this.adminObjectImplClassName);
            ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            String currentApp = null;
            ResourceAdapterMetaData metadata = bootstrapContext.getResourceAdapterMetaData();
            if (cData != null && cData != metadata) {
                currentApp = cData.getJ2EEName().getApplication();
                this.applications.add(cData.getJ2EEName().getApplication());
            }
            String adapterName = bootstrapContext.getResourceAdapterName();
            if (metadata != null && metadata.isEmbedded() && cData != metadata) {
                String embeddedApp = metadata.getJ2EEName().getApplication();
                Utils.checkAccessibility(this.name, adapterName, embeddedApp, currentApp, false);
            }
            Object adminObject = adminObjectClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            bootstrapContext.configure(adminObject, this.name, this.properties, null, null, null);
            Object obj = adminObject;
            return obj;
        }
        catch (Exception bootstrapContext) {
            void x;
            FFDCFilter.processException((Throwable)bootstrapContext, (String)"com.ibm.ws.jca.service.AdminObjectService", (String)"153", (Object)this, (Object[])new Object[]{refInfo});
            throw x;
        }
        catch (Error x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.jca.service.AdminObjectService", (String)"155", (Object)this, (Object[])new Object[]{refInfo});
            throw x;
        }
        finally {
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createResource");
            }
        }
    }

    protected void deactivate(ComponentContext context) {
        this.bootstrapContextRef.deactivate(context);
    }

    public ApplicationRecycleContext getContext() {
        ApplicationRecycleContext context = (ApplicationRecycleContext)this.bootstrapContextRef.getService();
        if (context != null) {
            return context;
        }
        return null;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>(this.applications);
        this.applications.removeAll(members);
        return members;
    }

    protected void setBootstrapContext(ServiceReference<BootstrapContextImpl> ref) {
        this.bootstrapContextRef.setReference(ref);
    }

    protected void unsetBootstrapContext(ServiceReference<BootstrapContextImpl> ref) {
        this.bootstrapContextRef.unsetReference(ref);
    }

    public String getId() {
        return this.id;
    }

    public String getJndiName() {
        return this.jndiName;
    }
}

