/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.Trivial;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;

public class StaxInEndingInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(StaxInEndingInterceptor.class);
    public static final String STAX_IN_NOCLOSE = StaxInEndingInterceptor.class.getName() + ".dontClose";
    public static final StaxInEndingInterceptor INSTANCE = new StaxInEndingInterceptor();

    @Trivial
    public StaxInEndingInterceptor() {
        super("post-invoke");
    }

    @Override
    public void handleMessage(@Sensitive Message message) throws Fault {
        LOG.entering("StaxInEndingInterceptor", "handleMessage");
        XMLStreamReader xtr = message.getContent(XMLStreamReader.class);
        if (xtr != null && !MessageUtils.getContextualBoolean(message, STAX_IN_NOCLOSE, false)) {
            StaxUtils.close(xtr);
            message.removeContent(XMLStreamReader.class);
        }
        LOG.exiting("StaxInEndingInterceptor", "handleMessage");
    }
}

