/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebTrustAssociationException;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.filter.AuthenticationFilter;
import com.ibm.ws.security.common.jwk.utils.JsonUtils;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import com.ibm.ws.security.jwt.config.MpConfigProperties;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import com.ibm.ws.security.mp.jwt.MicroProfileJwtConfig;
import com.ibm.ws.security.mp.jwt.MpConfigProxyService;
import com.ibm.ws.security.mp.jwt.config.MpConfigUtil;
import com.ibm.ws.security.mp.jwt.error.ErrorHandlerImpl;
import com.ibm.ws.security.mp.jwt.error.MpJwtProcessingException;
import com.ibm.ws.security.mp.jwt.impl.utils.MicroProfileJwtTaiRequest;
import com.ibm.ws.security.mp.jwt.tai.TAIJwtUtils;
import com.ibm.ws.security.mp.jwt.tai.TAIMappingHelper;
import com.ibm.ws.security.mp.jwt.tai.TAIRequestHelper;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TAIResult;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={TrustAssociationInterceptor.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, name="microProfileJwtTAI", property={"service.vendor=IBM", "type=microProfileJwtTAI", "id=MPJwtTAI", "TAIName=MPJwtTAI", "invokeBeforeSSO:Boolean=true", "disableLtpaCookie:Boolean=true"})
public class MicroProfileJwtTAI
implements TrustAssociationInterceptor {
    private static TraceComponent tc = Tr.register(MicroProfileJwtTAI.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    public static final String KEY_SERVICE_PID = "service.pid";
    public static final String KEY_PROVIDER_ID = "id";
    public static final String KEY_ID = "id";
    private static final String KEY_MPJWT_CONFIG = "microProfileJwtConfig";
    public static final String KEY_LOCATION_ADMIN = "locationAdmin";
    public static final String KEY_AUTH_CACHE_SERVICE = "authCacheService";
    public static final String KEY_SECURITY_SERVICE = "securityService";
    public static final String KEY_FILTER = "authFilter";
    public static final String KEY_MP_JWT_CONFIG = "microProfileJwtConfig";
    public static final String ATTRIBUTE_TAI_REQUEST = "MPJwtTaiRequest";
    public static final String JTI_CLAIM = "jti";
    public static final String KEY_AUTHORIZATION_HEADER_SCHEME = "authorizationHeaderScheme";
    public static final String KEY_MP_JWT_EXTENSION_SERVICE = "mpJwtExtensionService";
    static final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    protected static final ConcurrentServiceReferenceMap<String, AuthenticationFilter> authFilterServiceRef = new ConcurrentServiceReferenceMap("authFilter");
    static final ConcurrentServiceReferenceMap<String, MicroProfileJwtConfig> mpJwtConfigRef = new ConcurrentServiceReferenceMap("microProfileJwtConfig");
    static final AtomicServiceReference<MpConfigProxyService> mpConfigProxyServiceRef = new AtomicServiceReference("mpJwtExtensionService");
    TAIJwtUtils taiJwtUtils = new TAIJwtUtils();
    ReferrerURLCookieHandler referrerURLCookieHandler = null;
    TAIRequestHelper taiRequestHelper = new TAIRequestHelper();
    MpConfigUtil mpConfigUtil = new MpConfigUtil(mpConfigProxyServiceRef);
    static final long serialVersionUID = -7862597616163678393L;

    @Reference(service=SecurityService.class, name="securityService", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setSecurityService(ServiceReference<SecurityService> reference) {
        securityServiceRef.setReference(reference);
    }

    public void unsetSecurityService(ServiceReference<SecurityService> reference) {
        securityServiceRef.unsetReference(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=AuthenticationFilter.class, name="authFilter", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.RELUCTANT)
    protected void setAuthFilter(ServiceReference<AuthenticationFilter> ref) {
        String pid = (String)ref.getProperty(KEY_SERVICE_PID);
        ConcurrentServiceReferenceMap<String, AuthenticationFilter> concurrentServiceReferenceMap = authFilterServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            authFilterServiceRef.putReference((Object)pid, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" setAuthFilter pid:" + pid), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("@AV999 setAuthFilter service ref:" + MicroProfileJwtTAI.getAuthFilter(pid)), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedAuthFilter(ServiceReference<AuthenticationFilter> ref) {
        String pid = (String)ref.getProperty(KEY_SERVICE_PID);
        ConcurrentServiceReferenceMap<String, AuthenticationFilter> concurrentServiceReferenceMap = authFilterServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            authFilterServiceRef.putReference((Object)pid, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" setAuthFilter pid:" + pid), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetAuthFilter(ServiceReference<AuthenticationFilter> ref) {
        String pid = (String)ref.getProperty(KEY_SERVICE_PID);
        ConcurrentServiceReferenceMap<String, AuthenticationFilter> concurrentServiceReferenceMap = authFilterServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            authFilterServiceRef.removeReference((Object)pid, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" unsetAuthFilter pid:" + pid), (Object[])new Object[0]);
        }
    }

    public static AuthenticationFilter getAuthFilter(String pid) {
        return (AuthenticationFilter)authFilterServiceRef.getService((Object)pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=MicroProfileJwtConfig.class, name="microProfileJwtConfig", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.RELUCTANT)
    protected void setMicroProfileJwtConfig(ServiceReference<MicroProfileJwtConfig> ref) {
        String id = (String)ref.getProperty("id");
        ConcurrentServiceReferenceMap<String, MicroProfileJwtConfig> concurrentServiceReferenceMap = mpJwtConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            mpJwtConfigRef.putReference((Object)id, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" setMicroProfileJwtConfig id:" + id + " Number of references is now: " + mpJwtConfigRef.size() + "service = " + mpJwtConfigRef.getService((Object)id)), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedMicroProfileJwtConfig(ServiceReference<MicroProfileJwtConfig> ref) {
        String id = (String)ref.getProperty("id");
        ConcurrentServiceReferenceMap<String, MicroProfileJwtConfig> concurrentServiceReferenceMap = mpJwtConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            mpJwtConfigRef.putReference((Object)id, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" updateMicroProfileJwtConfig id:" + id), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetMicroProfileJwtConfig(ServiceReference<MicroProfileJwtConfig> ref) {
        String id = (String)ref.getProperty("id");
        ConcurrentServiceReferenceMap<String, MicroProfileJwtConfig> concurrentServiceReferenceMap = mpJwtConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            mpJwtConfigRef.removeReference((Object)id, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" unsetMicroProfileJwtConfig id:" + id), (Object[])new Object[0]);
        }
    }

    public static MicroProfileJwtConfig getMicroProfileJwtConfig(String key) {
        return (MicroProfileJwtConfig)mpJwtConfigRef.getService((Object)key);
    }

    public static Iterator<MicroProfileJwtConfig> getServices() {
        return mpJwtConfigRef.getServices();
    }

    @Reference(service=MpConfigProxyService.class, name="mpJwtExtensionService", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setMpConfigProxyService(ServiceReference<MpConfigProxyService> reference) {
        mpConfigProxyServiceRef.setReference(reference);
    }

    protected void unsetMpConfigProxyService(ServiceReference<MpConfigProxyService> reference) {
        mpConfigProxyServiceRef.unsetReference(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
        Object object = authFilterServiceRef;
        synchronized (object) {
            authFilterServiceRef.activate(cc);
        }
        object = mpJwtConfigRef;
        synchronized (object) {
            mpJwtConfigRef.activate(cc);
        }
        securityServiceRef.activate(cc);
        mpConfigProxyServiceRef.activate(cc);
    }

    @Modified
    protected void modified(ComponentContext cc, Map<String, Object> props) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext cc) {
        Object object = authFilterServiceRef;
        synchronized (object) {
            authFilterServiceRef.deactivate(cc);
        }
        object = mpJwtConfigRef;
        synchronized (object) {
            for (String key : mpJwtConfigRef.keySet()) {
                ServiceReference configref = mpJwtConfigRef.getReference((Object)key);
                mpJwtConfigRef.removeReference((Object)key, configref);
            }
            mpJwtConfigRef.deactivate(cc);
        }
        securityServiceRef.deactivate(cc);
        mpConfigProxyServiceRef.deactivate(cc);
    }

    @ManualTrace
    public boolean isTargetInterceptor(HttpServletRequest request) throws WebTrustAssociationException {
        String methodName = "isTargetInterceptor";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request});
        }
        MicroProfileJwtTaiRequest mpJwtTaiRequest = this.taiRequestHelper.createMicroProfileJwtTaiRequestAndSetRequestAttribute(request);
        this.updateTaiRequestWithMpConfigProps(request, mpJwtTaiRequest);
        boolean result = this.taiRequestHelper.requestShouldBeHandledByTAI(request, mpJwtTaiRequest);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
        }
        return result;
    }

    void updateTaiRequestWithMpConfigProps(HttpServletRequest request, MicroProfileJwtTaiRequest mpJwtTaiRequest) {
        mpJwtTaiRequest.setMpConfigProps(this.mpConfigUtil.getMpConfig(request));
        request.setAttribute(ATTRIBUTE_TAI_REQUEST, (Object)mpJwtTaiRequest);
    }

    @ManualTrace
    public TAIResult negotiateValidateandEstablishTrust(HttpServletRequest request, HttpServletResponse response) throws WebTrustAssociationFailedException {
        String methodName = "negotiateValidateandEstablishTrust";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request, response});
        }
        TAIResult taiResult = TAIResult.create((int)403);
        MicroProfileJwtTaiRequest mpJwtTaiRequest = (MicroProfileJwtTaiRequest)request.getAttribute(ATTRIBUTE_TAI_REQUEST);
        TAIResult result = this.getAssociatedConfigAndHandleRequest(request, response, mpJwtTaiRequest, taiResult);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
        }
        return result;
    }

    @ManualTrace
    @FFDCIgnore(value={MpJwtProcessingException.class})
    TAIResult getAssociatedConfigAndHandleRequest(HttpServletRequest request, HttpServletResponse response, MicroProfileJwtTaiRequest mpJwtTaiRequest, TAIResult defaultTaiResult) throws WebTrustAssociationFailedException {
        String methodName = "getAssociatedConfigAndHandleRequest";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request, response, mpJwtTaiRequest, defaultTaiResult});
        }
        MicroProfileJwtConfig clientConfig = null;
        try {
            clientConfig = mpJwtTaiRequest.getOnlyMatchingConfig();
        }
        catch (MpJwtProcessingException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("A unique mpJwt config wasn't found for this request. Exception was " + e), (Object[])new Object[0]);
            }
            TAIResult result = this.sendToErrorPage(response, defaultTaiResult);
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
            }
            return result;
        }
        TAIResult result = this.handleRequestBasedOnJwtConfig(request, response, clientConfig, defaultTaiResult);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
        }
        return result;
    }

    @ManualTrace
    TAIResult handleRequestBasedOnJwtConfig(HttpServletRequest request, HttpServletResponse response, MicroProfileJwtConfig config, TAIResult defaultTaiResult) throws WebTrustAssociationFailedException {
        String methodName = "handleRequestBasedOnJwtConfig";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request, response, config, defaultTaiResult});
        }
        if (config == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Client config for request could not be found. An error must have occurred initializing this request.", (Object[])new Object[0]);
            }
            TAIResult result = this.sendToErrorPage(response, defaultTaiResult);
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
            }
            return result;
        }
        TAIResult result = this.getAndValidateMicroProfileJwt(request, response, config);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
        }
        return result;
    }

    public int initialize(Properties props) throws WebTrustAssociationFailedException {
        return 0;
    }

    public String getVersion() {
        return null;
    }

    public String getType() {
        return null;
    }

    public void cleanup() {
    }

    @ManualTrace
    TAIResult getAndValidateMicroProfileJwt(HttpServletRequest request, HttpServletResponse response, MicroProfileJwtConfig mpJwtConfig) throws WebTrustAssociationFailedException {
        String token;
        String methodName = "getAndValidateMicroProfileJwt";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request, response, mpJwtConfig});
        }
        if ((token = this.taiRequestHelper.getBearerToken(request, mpJwtConfig)) == null) {
            Tr.error((TraceComponent)tc, (String)"JWT_NOT_FOUND_IN_REQUEST", (Object[])new Object[0]);
            TAIResult result = this.sendToErrorPage(response, TAIResult.create((int)401));
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
            }
            return result;
        }
        if (TAIJwtUtils.isJwtPreviouslyLoggedOut(token)) {
            Tr.error((TraceComponent)tc, (String)"JWT_PREVIOUSLY_LOGGED_OUT", (Object[])new Object[0]);
            TAIResult result = this.sendToErrorPage(response, TAIResult.create((int)401));
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
            }
            return result;
        }
        TAIResult result = this.handleMicroProfileJwtValidation(request, response, mpJwtConfig, token, false);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
        }
        return result;
    }

    @ManualTrace
    @FFDCIgnore(value={Exception.class})
    public TAIResult handleMicroProfileJwtValidation(HttpServletRequest req, HttpServletResponse res, MicroProfileJwtConfig clientConfig, String token, boolean addJwtPrincipal) throws WebTrustAssociationFailedException {
        String methodName = "handleMicroProfileJwtValidation";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{req, res, clientConfig, token});
        }
        JwtToken jwtToken = null;
        String decodedPayload = null;
        if (token != null) {
            try {
                MpConfigProperties mpCfg = this.taiRequestHelper.getMpConfigPropsFromRequestObject(req);
                jwtToken = !mpCfg.isEmpty() ? clientConfig.getConsumerUtils().parseJwt(token, (JwtConsumerConfig)clientConfig, mpCfg) : this.taiJwtUtils.createJwt(token, clientConfig.getUniqueId());
            }
            catch (Exception e) {
                if (!JwtUtils.isJwtSsoValidationExpiredTokenCodePath()) {
                    Tr.error((TraceComponent)tc, (String)"ERROR_CREATING_JWT_USING_TOKEN_IN_REQ", (Object[])new Object[]{e.getLocalizedMessage()});
                } else {
                    Tr.debug((TraceComponent)tc, (String)"ERROR_CREATING_JWT_USING_TOKEN_IN_REQ", (Object[])new Object[]{e.getLocalizedMessage()});
                }
                return this.sendToErrorPage(res, TAIResult.create((int)401));
            }
            String payload = JsonUtils.getPayload((String)jwtToken.compact());
            decodedPayload = JsonUtils.decodeFromBase64String((String)payload);
        }
        TAIResult authnResult = null;
        try {
            authnResult = this.createResult(res, clientConfig, jwtToken, decodedPayload, addJwtPrincipal);
        }
        catch (Exception e) {
            if (e instanceof MpJwtProcessingException) {
                FFDCFilter.processException((Throwable)e, (String)MicroProfileJwtTAI.class.getName(), (String)"387");
            }
            Tr.error((TraceComponent)tc, (String)"ERROR_CREATING_RESULT", (Object[])new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
            return this.sendToErrorPage(res, TAIResult.create((int)401));
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)authnResult);
        }
        return authnResult;
    }

    @ManualTrace
    TAIResult createResult(HttpServletResponse res, MicroProfileJwtConfig clientConfig, @Sensitive JwtToken jwtToken, @Sensitive String decodedPayload, boolean addJwtPrincipal) throws WebTrustAssociationFailedException, MpJwtProcessingException {
        String methodName = "createResult";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{res, clientConfig, jwtToken, decodedPayload});
        }
        TAIMappingHelper mappingHelper = new TAIMappingHelper(decodedPayload, clientConfig);
        mappingHelper.createJwtPrincipalAndPopulateCustomProperties(jwtToken, addJwtPrincipal);
        mappingHelper.addDisableSsoLtpaCacheProp();
        Subject subject = mappingHelper.createSubjectFromCustomProperties(addJwtPrincipal);
        TAIResult result = TAIResult.create((int)200, (String)mappingHelper.getUsername(), (Subject)subject);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
        }
        return result;
    }

    TAIResult sendToErrorPage(HttpServletResponse response, TAIResult taiResult) {
        if (response != null) {
            return ErrorHandlerImpl.getInstance().handleErrorResponse(response, taiResult);
        }
        return taiResult;
    }
}

