/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.task;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.impl.CachedPersistableImpl;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.TransactionState;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class PersistRedeliveredCount
extends Task {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register(PersistRedeliveredCount.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private Persistable _cachedPersistable = null;
    private Persistable _masterPersistable;

    public PersistRedeliveredCount(AbstractItemLink link) throws SevereMessageStoreException {
        super(link);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)link);
        }
        this._masterPersistable = super.getPersistable();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Override
    public final void abort(PersistentTransaction transaction) throws SevereMessageStoreException {
    }

    @Override
    public final void commitExternal(PersistentTransaction transaction) throws SevereMessageStoreException {
    }

    @Override
    public final void commitInternal(PersistentTransaction transaction) {
    }

    @Override
    public final void copyDataIfVulnerable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"copyDataIfVulnerable");
        }
        if (this._cachedPersistable == null) {
            this._cachedPersistable = new CachedPersistable(this._masterPersistable);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"copyDataIfVulnerable");
        }
    }

    @Override
    public final Persistable getPersistable() {
        if (this._cachedPersistable != null) {
            return this._cachedPersistable;
        }
        return this._masterPersistable;
    }

    @Override
    public final int getPersistableInMemorySizeApproximation(TransactionState tranState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistableInMemorySizeApproximation", (Object)tranState);
        }
        if (tranState != TransactionState.STATE_COMMITTED && tranState != TransactionState.STATE_COMMITTING_1PC) {
            throw new IllegalStateException(nls.getFormattedMessage("INVALID_TASK_OPERATION_SIMS1520", new Object[]{tranState}, null));
        }
        int size = 500;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistableInMemorySizeApproximation", (Object)size);
        }
        return size;
    }

    @Override
    public final Task.Type getTaskType() {
        return Task.Type.PERSIST_REDELIVERED_COUNT;
    }

    @Override
    public final void persist(BatchingContext batchingContext, TransactionState tranState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persist", (Object)new Object[]{batchingContext, tranState});
        }
        if (tranState != TransactionState.STATE_COMMITTED && tranState != TransactionState.STATE_COMMITTING_1PC) {
            throw new IllegalStateException(nls.getFormattedMessage("INVALID_TASK_OPERATION_SIMS1520", new Object[]{tranState}, null));
        }
        batchingContext.updateRedeliveredCountOnly(this.getPersistable());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persist");
        }
    }

    @Override
    public final void postAbort(PersistentTransaction transaction) {
    }

    @Override
    public final void postCommit(PersistentTransaction transaction) {
    }

    @Override
    public final void preCommit(PersistentTransaction transaction) {
    }

    private final class CachedPersistable
    extends CachedPersistableImpl {
        private int _cachedRedeliveredCount;

        public CachedPersistable(Persistable masterPersistable) {
            super(masterPersistable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>$CachedPersistable");
            }
            this._cachedRedeliveredCount = PersistRedeliveredCount.this._masterPersistable.getRedeliveredCount();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>$CachedPersistable");
            }
        }

        @Override
        public int getRedeliveredCount() {
            return this._cachedRedeliveredCount;
        }

        @Override
        public void setRedeliveredCount(int l) {
            throw new UnsupportedOperationException();
        }
    }
}

