/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.grpc.ExperimentalApi;
import io.grpc.internal.ConscryptLoader;
import io.grpc.netty.JettyTlsUtil;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.File;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1784")
public class GrpcSslContexts {
    private static final Logger logger = Logger.getLogger(GrpcSslContexts.class.getName());
    private static final String HTTP2_VERSION = "h2";
    private static final List<String> NEXT_PROTOCOL_VERSIONS = Collections.unmodifiableList(Arrays.asList("h2"));
    private static final ApplicationProtocolConfig ALPN = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (Iterable<String>)NEXT_PROTOCOL_VERSIONS);
    private static final ApplicationProtocolConfig NPN = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (Iterable<String>)NEXT_PROTOCOL_VERSIONS);
    private static final ApplicationProtocolConfig NPN_AND_ALPN = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NPN_AND_ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (Iterable<String>)NEXT_PROTOCOL_VERSIONS);
    private static final String SUN_PROVIDER_NAME = "SunJSSE";
    private static final String IBM_PROVIDER_NAME = "IBMJSSE2";
    static final long serialVersionUID = -4364946054807577039L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private GrpcSslContexts() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.grpc.netty.GrpcSslContexts", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.grpc.netty.GrpcSslContexts", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SslContextBuilder forClient() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.grpc.netty.GrpcSslContexts", "forClient", new Object[0]);
        }
        SslContextBuilder sslContextBuilder = GrpcSslContexts.configure(SslContextBuilder.forClient());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            sslContextBuilder = sslContextBuilder;
            logger.exiting("io.grpc.netty.GrpcSslContexts", "forClient", sslContextBuilder);
        }
        return sslContextBuilder;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SslContextBuilder forServer(File keyCertChainFile, File keyFile) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.grpc.netty.GrpcSslContexts", "forServer", new Object[]{keyCertChainFile, keyFile});
        }
        SslContextBuilder sslContextBuilder = GrpcSslContexts.configure(SslContextBuilder.forServer(keyCertChainFile, keyFile));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            sslContextBuilder = sslContextBuilder;
            logger.exiting("io.grpc.netty.GrpcSslContexts", "forServer", sslContextBuilder);
        }
        return sslContextBuilder;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SslContextBuilder forServer(File keyCertChainFile, File keyFile, String keyPassword) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.grpc.netty.GrpcSslContexts", "forServer", new Object[]{keyCertChainFile, keyFile, keyPassword});
        }
        SslContextBuilder sslContextBuilder = GrpcSslContexts.configure(SslContextBuilder.forServer(keyCertChainFile, keyFile, keyPassword));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            sslContextBuilder = sslContextBuilder;
            logger.exiting("io.grpc.netty.GrpcSslContexts", "forServer", sslContextBuilder);
        }
        return sslContextBuilder;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SslContextBuilder forServer(InputStream keyCertChain, InputStream key) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.grpc.netty.GrpcSslContexts", "forServer", new Object[]{keyCertChain, key});
        }
        SslContextBuilder sslContextBuilder = GrpcSslContexts.configure(SslContextBuilder.forServer(keyCertChain, key));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            sslContextBuilder = sslContextBuilder;
            logger.exiting("io.grpc.netty.GrpcSslContexts", "forServer", sslContextBuilder);
        }
        return sslContextBuilder;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SslContextBuilder forServer(InputStream keyCertChain, InputStream key, String keyPassword) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.grpc.netty.GrpcSslContexts", "forServer", new Object[]{keyCertChain, key, keyPassword});
        }
        SslContextBuilder sslContextBuilder = GrpcSslContexts.configure(SslContextBuilder.forServer(keyCertChain, key, keyPassword));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            sslContextBuilder = sslContextBuilder;
            logger.exiting("io.grpc.netty.GrpcSslContexts", "forServer", sslContextBuilder);
        }
        return sslContextBuilder;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @CanIgnoreReturnValue
    public static SslContextBuilder configure(SslContextBuilder builder) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.grpc.netty.GrpcSslContexts", "configure", new Object[]{builder});
        }
        SslContextBuilder sslContextBuilder = GrpcSslContexts.configure(builder, GrpcSslContexts.defaultSslProvider());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            sslContextBuilder = sslContextBuilder;
            logger.exiting("io.grpc.netty.GrpcSslContexts", "configure", sslContextBuilder);
        }
        return sslContextBuilder;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1784")
    @CanIgnoreReturnValue
    public static SslContextBuilder configure(SslContextBuilder builder, SslProvider provider) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.grpc.netty.GrpcSslContexts", "configure", new Object[]{builder, provider});
        }
        switch (provider) {
            case JDK: {
                Provider jdkProvider = GrpcSslContexts.findJdkProvider();
                if (jdkProvider == null) {
                    throw new IllegalArgumentException("Could not find Jetty NPN/ALPN or Conscrypt as installed JDK providers");
                }
                SslContextBuilder sslContextBuilder = GrpcSslContexts.configure(builder, jdkProvider);
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    sslContextBuilder = sslContextBuilder;
                    logger.exiting("io.grpc.netty.GrpcSslContexts", "configure", sslContextBuilder);
                }
                return sslContextBuilder;
            }
            case OPENSSL: {
                ApplicationProtocolConfig apc = OpenSsl.isAlpnSupported() ? NPN_AND_ALPN : NPN;
                SslContextBuilder sslContextBuilder = builder.sslProvider(SslProvider.OPENSSL).ciphers(Http2SecurityUtil.CIPHERS, SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(apc);
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    sslContextBuilder = sslContextBuilder;
                    logger.exiting("io.grpc.netty.GrpcSslContexts", "configure", sslContextBuilder);
                }
                return sslContextBuilder;
            }
        }
        throw new IllegalArgumentException("Unsupported provider: " + (Object)((Object)provider));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @CanIgnoreReturnValue
    public static SslContextBuilder configure(SslContextBuilder builder, Provider jdkProvider) {
        ApplicationProtocolConfig apc;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.grpc.netty.GrpcSslContexts", "configure", new Object[]{builder, jdkProvider});
        }
        if (SUN_PROVIDER_NAME.equals(jdkProvider.getName())) {
            if (JettyTlsUtil.isJettyAlpnConfigured()) {
                apc = ALPN;
            } else if (JettyTlsUtil.isJettyNpnConfigured()) {
                apc = NPN;
            } else {
                if (!JettyTlsUtil.isJava9AlpnAvailable()) throw new IllegalArgumentException(jdkProvider.getName() + " selected, but Java 9+ and Jetty NPN/ALPN unavailable");
                apc = ALPN;
            }
        } else if (IBM_PROVIDER_NAME.equals(jdkProvider.getName())) {
            if (!JettyTlsUtil.isJava9AlpnAvailable()) throw new IllegalArgumentException(jdkProvider.getName() + " selected, but Java 9+ ALPN unavailable");
            apc = ALPN;
        } else {
            if (!ConscryptLoader.isConscrypt((Provider)jdkProvider)) throw new IllegalArgumentException("Unknown provider; can't configure: " + jdkProvider);
            apc = ALPN;
        }
        SslContextBuilder sslContextBuilder = builder.sslProvider(SslProvider.JDK).ciphers(Http2SecurityUtil.CIPHERS, SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(apc).sslContextProvider(jdkProvider);
        if (logger == null || !logger.isLoggable(Level.FINER)) return sslContextBuilder;
        sslContextBuilder = sslContextBuilder;
        logger.exiting("io.grpc.netty.GrpcSslContexts", "configure", sslContextBuilder);
        return sslContextBuilder;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static SslProvider defaultSslProvider() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.grpc.netty.GrpcSslContexts", "defaultSslProvider", new Object[0]);
        }
        if (OpenSsl.isAvailable()) {
            logger.log(Level.FINE, "Selecting OPENSSL");
            SslProvider sslProvider = SslProvider.OPENSSL;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                sslProvider = sslProvider;
                logger.exiting("io.grpc.netty.GrpcSslContexts", "defaultSslProvider", (Object)sslProvider);
            }
            return sslProvider;
        }
        Provider provider = GrpcSslContexts.findJdkProvider();
        if (provider != null) {
            logger.log(Level.FINE, "Selecting JDK with provider {0}", provider);
            SslProvider sslProvider = SslProvider.JDK;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                sslProvider = sslProvider;
                logger.exiting("io.grpc.netty.GrpcSslContexts", "defaultSslProvider", (Object)sslProvider);
            }
            return sslProvider;
        }
        logger.log(Level.INFO, "Java 9 ALPN API unavailable (this may be normal)");
        logger.log(Level.INFO, "netty-tcnative unavailable (this may be normal)", OpenSsl.unavailabilityCause());
        logger.log(Level.INFO, "Conscrypt not found (this may be normal)", ConscryptHolder.UNAVAILABILITY_CAUSE);
        logger.log(Level.INFO, "Jetty ALPN unavailable (this may be normal)", JettyTlsUtil.getJettyAlpnUnavailabilityCause());
        throw new IllegalStateException("Could not find TLS ALPN provider; no working netty-tcnative, Conscrypt, or Jetty NPN/ALPN available");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Provider findJdkProvider() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.grpc.netty.GrpcSslContexts", "findJdkProvider", new Object[0]);
        }
        for (Provider provider : Security.getProviders("SSLContext.TLS")) {
            if (SUN_PROVIDER_NAME.equals(provider.getName())) {
                if (!JettyTlsUtil.isJettyAlpnConfigured() && !JettyTlsUtil.isJettyNpnConfigured() && !JettyTlsUtil.isJava9AlpnAvailable()) continue;
                Provider provider2 = provider;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    provider2 = provider2;
                    logger.exiting("io.grpc.netty.GrpcSslContexts", "findJdkProvider", provider2);
                }
                return provider2;
            }
            if (IBM_PROVIDER_NAME.equals(provider.getName())) {
                if (!JettyTlsUtil.isJava9AlpnAvailable()) continue;
                Provider provider3 = provider;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    provider3 = provider3;
                    logger.exiting("io.grpc.netty.GrpcSslContexts", "findJdkProvider", provider3);
                }
                return provider3;
            }
            if (!ConscryptLoader.isConscrypt((Provider)provider)) continue;
            Provider provider4 = provider;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                provider4 = provider4;
                logger.exiting("io.grpc.netty.GrpcSslContexts", "findJdkProvider", provider4);
            }
            return provider4;
        }
        if (ConscryptHolder.PROVIDER != null) {
            Provider provider = ConscryptHolder.PROVIDER;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                provider = provider;
                logger.exiting("io.grpc.netty.GrpcSslContexts", "findJdkProvider", provider);
            }
            return provider;
        }
        Provider provider = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            provider = provider;
            logger.exiting("io.grpc.netty.GrpcSslContexts", "findJdkProvider", provider);
        }
        return provider;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static void ensureAlpnAndH2Enabled(ApplicationProtocolNegotiator alpnNegotiator) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.grpc.netty.GrpcSslContexts", "ensureAlpnAndH2Enabled", new Object[]{alpnNegotiator});
        }
        Preconditions.checkArgument((alpnNegotiator != null ? 1 : 0) != 0, (Object)"ALPN must be configured");
        Preconditions.checkArgument((alpnNegotiator.protocols() != null && !alpnNegotiator.protocols().isEmpty() ? 1 : 0) != 0, (Object)"ALPN must be enabled and list HTTP/2 as a supported protocol.");
        Preconditions.checkArgument((boolean)alpnNegotiator.protocols().contains(HTTP2_VERSION), (String)"This ALPN config does not support HTTP/2. Expected %s, but got %s'.", (Object)HTTP2_VERSION, alpnNegotiator.protocols());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.grpc.netty.GrpcSslContexts", "ensureAlpnAndH2Enabled");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ConscryptHolder {
        static final Provider PROVIDER;
        static final Throwable UNAVAILABILITY_CAUSE;
        static final long serialVersionUID = 1910072835574717116L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ConscryptHolder() {
        }

        /*
         * WARNING - void declaration
         */
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            Object cause;
            Provider provider;
            $$$tc$$$ = Tr.register((String)"io.grpc.netty.GrpcSslContexts$ConscryptHolder", ConscryptHolder.class, null, null);
            try {
                provider = ConscryptLoader.newProvider();
                cause = null;
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"io.grpc.netty.GrpcSslContexts$ConscryptHolder", (String)"291", null, (Object[])new Object[0]);
                provider = null;
                cause = t;
            }
            PROVIDER = provider;
            UNAVAILABILITY_CAUSE = cause;
        }
    }
}

