/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.persistent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.application.Application;
import com.ibm.wsspi.application.ApplicationState;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationTracker.class}, configurationPolicy=ConfigurationPolicy.IGNORE)
public class ApplicationTracker {
    private static final TraceComponent tc = Tr.register(ApplicationTracker.class, (String)"persistentExecutor", (String)"com.ibm.ws.concurrent.persistent.resources.CWWKCMessages");
    private static final String NAME = "name";
    private final Map<String, ApplicationState> appStates = new HashMap<String, ApplicationState>();
    private final Map<String, Set<Runnable>> deferredTasks = new HashMap<String, Set<Runnable>>();
    private ExecutorService executor;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    static final long serialVersionUID = -376962287360629709L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=Application.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(application.state=STARTED)")
    protected void addStartedApplication(ServiceReference<Application> ref) {
        Set<Runnable> tasks;
        ExecutorService executor;
        String appName = (String)ref.getProperty(NAME);
        this.lock.writeLock().lock();
        try {
            executor = this.executor;
            this.appStates.put(appName, ApplicationState.STARTED);
            tasks = this.deferredTasks.remove(appName);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (tasks != null) {
            for (Runnable task : tasks) {
                executor.submit(task);
            }
        }
    }

    @Reference(service=Application.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(application.state=STARTING)")
    protected void addStartingApplication(ServiceReference<Application> ref) {
        String appName = (String)ref.getProperty(NAME);
        this.lock.writeLock().lock();
        try {
            if (!this.appStates.containsKey(appName)) {
                this.appStates.put(appName, ApplicationState.STARTING);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deferTask(Runnable task, String appName, PersistentExecutorImpl persistentExecutor) {
        ApplicationState state;
        ExecutorService executor;
        this.lock.writeLock().lock();
        try {
            executor = this.executor;
            state = this.appStates.get(appName);
            if (state != ApplicationState.STARTED) {
                Set<Runnable> taskSet = this.deferredTasks.get(appName);
                if (taskSet == null) {
                    taskSet = new HashSet<Runnable>();
                    this.deferredTasks.put(appName, taskSet);
                    if (state != ApplicationState.STARTING && !persistentExecutor.deactivated) {
                        Tr.warning((TraceComponent)tc, (String)"CWWKC1556.task.exec.deferred", (Object[])new Object[]{appName});
                    }
                }
                taskSet.add(task);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (state == ApplicationState.STARTED) {
            executor.submit(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void introspect(PrintWriter out) {
        if (this.lock.readLock().tryLock()) {
            try {
                for (Map.Entry<String, Set<Runnable>> entry : this.deferredTasks.entrySet()) {
                    out.print("Deferred tasks for ");
                    out.print(entry.getKey());
                    out.print(": ");
                    out.println(entry.getValue());
                }
                for (Map.Entry<String, Set<Runnable>> entry : this.appStates.entrySet()) {
                    out.print(entry.getKey());
                    out.print(" is ");
                    out.println(entry.getValue());
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    boolean isStarted(String appName) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.appStates.get(appName) == ApplicationState.STARTED;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void removeStartedApplication(ServiceReference<Application> ref) {
        String appName = (String)ref.getProperty(NAME);
        this.lock.writeLock().lock();
        try {
            this.appStates.remove(appName);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void removeStartingApplication(ServiceReference<Application> ref) {
    }

    @Reference(target="(component.name=com.ibm.ws.threading)")
    protected void setExecutor(ExecutorService svc) {
        this.executor = svc;
    }

    protected void unsetExecutor(ExecutorService svc) {
        this.executor = null;
    }
}

