/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl;

import io.smallrye.graphql.client.typesafe.api.Header;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.ParameterInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.util.List;
import java.util.stream.Collectors;

class RequestBuilder {
    private final MethodInfo method;
    private final StringBuilder request = new StringBuilder();

    public RequestBuilder(MethodInfo method) {
        this.method = method;
    }

    String build() {
        this.request.append(this.method.getName());
        List parameters = this.method.parameters().filter(parameterInfo -> !parameterInfo.isAnnotated(Header.class)).collect(Collectors.toList());
        if (parameters.size() > 0) {
            this.request.append("(");
            Repeated repeated = new Repeated(", ");
            for (ParameterInfo parameterInfo2 : parameters) {
                this.request.append(repeated);
                this.appendParam(parameterInfo2);
            }
            this.request.append(")");
        }
        return this.request.toString();
    }

    private void appendParam(ParameterInfo parameter) {
        this.request.append(parameter.getName()).append(": ");
        this.buildParam(parameter.getType(), parameter.getValue());
    }

    private void buildParam(TypeInfo type, Object value) {
        if (value == null) {
            this.request.append("null");
        } else if (type.isScalar()) {
            this.buildScalarParam(type, value);
        } else if (type.isCollection()) {
            this.buildArrayParam(type.getItemType(), (List)value);
        } else {
            this.buildObjectParam(type, value);
        }
    }

    private void buildScalarParam(TypeInfo type, Object value) {
        boolean quoted;
        boolean bl = quoted = !this.unquoted(type);
        if (quoted) {
            this.request.append("\"");
        }
        this.request.append(type.stringValue(value));
        if (quoted) {
            this.request.append("\"");
        }
    }

    public boolean unquoted(TypeInfo type) {
        return type.isPrimitive() || Number.class.isAssignableFrom(type.getRawType()) || type.isEnum();
    }

    private void buildArrayParam(TypeInfo itemType, List<?> values) {
        this.request.append("[");
        Repeated repeated = new Repeated(", ");
        values.forEach(value -> {
            this.request.append(repeated);
            this.buildParam(itemType, value);
        });
        this.request.append("]");
    }

    private void buildObjectParam(TypeInfo type, Object value) {
        this.request.append("{");
        Repeated repeated = new Repeated(", ");
        type.fields().forEach(field -> {
            this.request.append(repeated);
            this.request.append(field.getName()).append(": ");
            this.buildParam(field.getType(), field.get(value));
        });
        this.request.append("}");
    }

    private static class Repeated {
        private final String text;
        private boolean first = true;

        public Repeated(String text) {
            this.text = text;
        }

        public String toString() {
            if (this.first) {
                this.first = false;
                return "";
            }
            return this.text;
        }
    }
}

