/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.pool.impl;

import java.util.concurrent.atomic.AtomicLong;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.pool.PoolableStore;
import net.sf.ehcache.pool.SizeOfEngine;
import net.sf.ehcache.pool.impl.AbstractPoolAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AtomicPoolAccessor
extends AbstractPoolAccessor<PoolableStore> {
    private final AtomicLong size;

    AtomicPoolAccessor(Pool<PoolableStore> pool, PoolableStore store, SizeOfEngine sizeOfEngine, long currentSize) {
        super(pool, store, sizeOfEngine);
        this.size = new AtomicLong(currentSize);
    }

    @Override
    protected long add(long sizeOf, boolean force) {
        long newSize = this.getPool().getSize() + sizeOf;
        if (newSize <= this.getPool().getMaxSize()) {
            this.size.addAndGet(sizeOf);
            return sizeOf;
        }
        if (!force && sizeOf > this.getPool().getMaxSize()) {
            return -1L;
        }
        long missingSize = newSize - this.getPool().getMaxSize();
        if (this.getPool().getEvictor().freeSpace(this.getPool().getPoolableStores(), missingSize) || force) {
            this.size.addAndGet(sizeOf);
            return sizeOf;
        }
        return -1L;
    }

    @Override
    protected boolean canAddWithoutEvicting(long sizeOf) {
        long newSize = this.getPool().getSize() + sizeOf;
        return newSize <= this.getPool().getMaxSize();
    }

    @Override
    public long delete(long sizeOf) {
        this.checkLinked();
        this.size.addAndGet(-sizeOf);
        return sizeOf;
    }

    @Override
    public long getSize() {
        return this.size.get();
    }

    @Override
    protected void doClear() {
        this.size.set(0L);
    }
}

