/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.cache.CacheEvictionListener;
import java.util.ArrayList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Cache {
    private static final TraceComponent tc = Tr.register(Cache.class, (String)"Authentication");
    private static long defaultTimeout;
    private ConcurrentHashMap<Object, Object> primaryTable;
    private ConcurrentHashMap<Object, Object> secondaryTable;
    private ConcurrentHashMap<Object, Object> tertiaryTable;
    private int minSize = 0;
    private int entryLimit = 500;
    private final Set<CacheEvictionListener> cacheEvictionListenerSet;
    private Timer timer;
    static final long serialVersionUID = 4724440007045828590L;

    public Cache(int initialSize, int entryLimit, long timeoutInMilliSeconds) {
        this(initialSize, entryLimit, timeoutInMilliSeconds, null);
    }

    public Cache(int initialSize, int entryLimit, long timeoutInMilliSeconds, Set<CacheEvictionListener> callbackSet) {
        this.primaryTable = new ConcurrentHashMap(initialSize);
        this.secondaryTable = new ConcurrentHashMap(initialSize);
        this.tertiaryTable = new ConcurrentHashMap(initialSize);
        this.minSize = initialSize;
        this.entryLimit = entryLimit;
        this.cacheEvictionListenerSet = callbackSet;
        if (timeoutInMilliSeconds > 0L) {
            this.scheduleEvictionTask(timeoutInMilliSeconds);
        }
    }

    private void scheduleEvictionTask(long timeoutInMilliSeconds) {
        long period;
        EvictionTask evictionTask = new EvictionTask();
        this.timer = new Timer(true);
        long delay = period = timeoutInMilliSeconds / 2L;
        this.timer.schedule((TimerTask)evictionTask, delay, period);
    }

    public synchronized void remove(Object key) {
        Object victim = null;
        if (!this.cacheEvictionListenerSet.isEmpty()) {
            victim = this.get(key);
        }
        this.primaryTable.remove(key);
        this.secondaryTable.remove(key);
        this.tertiaryTable.remove(key);
        if (victim != null) {
            ArrayList<Object> evictedValues = new ArrayList<Object>();
            evictedValues.add(victim);
            for (CacheEvictionListener evictionCallback : this.cacheEvictionListenerSet) {
                evictionCallback.evicted(evictedValues);
            }
        }
    }

    public synchronized Object get(Object key) {
        Entry prevEntry;
        ConcurrentHashMap<Object, Object> tableRef = this.primaryTable;
        Entry curEntry = (Entry)this.primaryTable.get(key);
        if (curEntry == null) {
            tableRef = this.secondaryTable;
            curEntry = (Entry)this.secondaryTable.get(key);
            if (curEntry == null) {
                tableRef = this.tertiaryTable;
                curEntry = (Entry)this.tertiaryTable.get(key);
            }
            if (curEntry == null) {
                tableRef = null;
            }
        }
        if (tableRef != null && tableRef != this.primaryTable) {
            this.primaryTable.put(key, curEntry);
            tableRef.remove(key);
        }
        if (tableRef == null && (curEntry = (Entry)this.primaryTable.get(key)) == null && (prevEntry = (Entry)this.primaryTable.putIfAbsent(key, curEntry = new Entry())) != null) {
            curEntry = prevEntry;
        }
        return curEntry.value;
    }

    public synchronized void insert(Object key, Object value) {
        while (this.isEvictionRequired() && this.entryLimit > 0 && this.entryLimit < Integer.MAX_VALUE) {
            this.evictStaleEntries();
        }
        Entry curEntry = new Entry(value);
        Entry oldEntry = (Entry)this.primaryTable.put(key, curEntry);
        if (oldEntry != null && oldEntry.value != null) {
            ArrayList<Object> evictedValues = new ArrayList<Object>();
            evictedValues.add(oldEntry.value);
            for (CacheEvictionListener evictionCallback : this.cacheEvictionListenerSet) {
                evictionCallback.evicted(evictedValues);
            }
        }
    }

    protected boolean isEvictionRequired() {
        int size;
        boolean evictionRequired = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            size = this.primaryTable.size() + this.secondaryTable.size() + this.tertiaryTable.size();
            Tr.debug((TraceComponent)tc, (String)("The current cache size is " + size + "( " + this.primaryTable.size() + ", " + this.secondaryTable.size() + ", " + this.tertiaryTable.size() + ")"), (Object[])new Object[0]);
        }
        if (this.entryLimit != 0 && this.entryLimit != Integer.MAX_VALUE && (size = this.primaryTable.size() + this.secondaryTable.size() + this.tertiaryTable.size()) > this.entryLimit) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The cache size is " + size + "( " + this.primaryTable.size() + ", " + this.secondaryTable.size() + ", " + this.tertiaryTable.size() + ") which is greater than the cache limit of " + this.entryLimit + "."), (Object[])new Object[0]);
            }
            evictionRequired = true;
        }
        return evictionRequired;
    }

    protected synchronized void evictStaleEntries() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            int size = this.primaryTable.size() + this.secondaryTable.size() + this.tertiaryTable.size();
            Tr.debug((TraceComponent)tc, (String)("The current cache size is " + size + "( " + this.primaryTable.size() + ", " + this.secondaryTable.size() + ", " + this.tertiaryTable.size() + ")"), (Object[])new Object[0]);
        }
        ConcurrentHashMap<Object, Object> victims = this.tertiaryTable;
        this.tertiaryTable = this.secondaryTable;
        this.secondaryTable = this.primaryTable;
        this.primaryTable = new ConcurrentHashMap(this.minSize > this.secondaryTable.size() ? this.minSize : this.secondaryTable.size());
        if (!victims.isEmpty()) {
            ArrayList<Object> evictedValues = new ArrayList<Object>();
            for (Entry entry : victims.values()) {
                if (entry.value == null) continue;
                evictedValues.add(entry.value);
            }
            for (CacheEvictionListener evictionCallback : this.cacheEvictionListenerSet) {
                evictionCallback.evicted(evictedValues);
            }
        }
    }

    protected synchronized void clearAllEntries() {
        this.tertiaryTable.putAll(this.primaryTable);
        this.tertiaryTable.putAll(this.secondaryTable);
        this.primaryTable.clear();
        this.secondaryTable.clear();
        this.evictStaleEntries();
    }

    public static long getDefaultTimeout() {
        return defaultTimeout;
    }

    public static void setDefaultTimeout(long timeout) {
        defaultTimeout = timeout;
    }

    int getEntryLimit() {
        return this.entryLimit;
    }

    protected void stopEvictionTask() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class EvictionTask
    extends TimerTask {
        static final long serialVersionUID = -5528558335121546422L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private EvictionTask() {
        }

        @Override
        public void run() {
            Cache.this.evictStaleEntries();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EvictionTask.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class Entry {
        public Object value;
        public int timesAccessed;
        static final long serialVersionUID = -6927412618601750912L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Entry() {
        }

        public Entry(Object value) {
            this.value = value;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Entry.class);
        }
    }
}

