/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.internal.WSUtilService;
import com.ibm.ws.util.ThreadContextAccessor;
import java.security.AccessController;
import org.apache.yoko.rmi.impl.UtilImpl;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.OutputStream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSUtilImpl
extends UtilImpl {
    private static final TraceComponent tc = Tr.register(WSUtilImpl.class);
    private static final ThreadContextAccessor threadContextAccessor = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());
    static final long serialVersionUID = 2658196748743841870L;

    @FFDCIgnore(value={ClassNotFoundException.class})
    public Class loadClass(String name, String codebase, ClassLoader loader) throws ClassNotFoundException {
        try {
            return super.loadClass(name, codebase, loader);
        }
        catch (ClassNotFoundException e) {
            ClassLoader contextClassLoader = threadContextAccessor.getContextClassLoaderForUnprivileged(Thread.currentThread());
            if (contextClassLoader != loader && name.endsWith("_Stub")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("retrying with " + contextClassLoader), (Object[])new Object[0]);
                }
                try {
                    return contextClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public void writeRemoteObject(OutputStream out, @Sensitive Object obj) throws SystemException {
        WSUtilService service = WSUtilService.getInstance();
        if (service != null) {
            obj = service.replaceObject(obj);
        }
        super.writeRemoteObject(out, obj);
    }

    public String getCodebase(Class arg0) {
        return null;
    }
}

