/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.metrics.impl.CounterImpl;
import com.ibm.ws.microprofile.metrics.impl.SharedMetricRegistries;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BaseMetrics {
    private static BaseMetrics baseMetrics;
    private static String BASE;
    MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private static Set<String> gcObjectNames;
    private static SharedMetricRegistries SHARED_METRIC_REGISTRY;
    static final long serialVersionUID = -6196655065527816198L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static synchronized BaseMetrics getInstance(SharedMetricRegistries sharedMetricRegistry) {
        SHARED_METRIC_REGISTRY = sharedMetricRegistry;
        if (baseMetrics == null) {
            baseMetrics = new BaseMetrics();
        }
        return baseMetrics;
    }

    protected BaseMetrics() {
        Set<ObjectInstance> mBeanObjectInstanceSet = this.mbs.queryMBeans(null, null);
        this.populateGcNames(mBeanObjectInstanceSet);
        this.createBaseMetrics();
    }

    private void populateGcNames(Set<ObjectInstance> mBeanObjectInstanceSet) {
        for (ObjectInstance objInstance : mBeanObjectInstanceSet) {
            String objectName = objInstance.getObjectName().toString();
            if (!objectName.matches("java.lang:.*type=GarbageCollector.*")) continue;
            for (String subString : objectName.split(",")) {
                if (!(subString = subString.trim()).contains("name=")) continue;
                String name = subString.split("=")[1];
                gcObjectNames.add(name);
            }
        }
    }

    public void createBaseMetrics() {
        MetricRegistry registry = SHARED_METRIC_REGISTRY.getOrCreate(BASE);
        registry.register("memory.usedHeap", new BMGauge("java.lang:type=Memory", "HeapMemoryUsage", "used"), new Metadata("memory.usedHeap", "Used Heap Memory", "memory.usedHeap.description", MetricType.GAUGE, "bytes"));
        registry.register("memory.committedHeap", new BMGauge("java.lang:type=Memory", "HeapMemoryUsage", "committed"), new Metadata("memory.committedHeap", "Committed Heap Memory", "memory.committedHeap.description", MetricType.GAUGE, "bytes"));
        registry.register("memory.maxHeap", new BMGauge("java.lang:type=Memory", "HeapMemoryUsage", "max"), new Metadata("memory.maxHeap", "Max Heap Memory", "memory.maxHeap.description", MetricType.GAUGE, "bytes"));
        registry.register("jvm.uptime", new BMGauge("java.lang:type=Runtime", "Uptime"), new Metadata("jvm.uptime", "JVM Uptime", "jvm.uptime.description", MetricType.GAUGE, "milliseconds"));
        registry.register("thread.count", (Metric)new BMCounter("java.lang:type=Threading", "ThreadCount"), new Metadata("thread.count", "Thread Count", "thread.count.description", MetricType.COUNTER, "none"));
        registry.register("thread.daemon.count", (Metric)new BMCounter("java.lang:type=Threading", "DaemonThreadCount"), new Metadata("thread.daemon.count", "Daemon Thread Count", "thread.daemon.count.description", MetricType.COUNTER, "none"));
        registry.register("thread.max.count", (Metric)new BMCounter("java.lang:type=Threading", "PeakThreadCount"), new Metadata("thread.max.count", "Peak Thread Count", "thread.max.count.description", MetricType.COUNTER, "none"));
        registry.register("classloader.currentLoadedClass.count", (Metric)new BMCounter("java.lang:type=ClassLoading", "LoadedClassCount"), new Metadata("classloader.currentLoadedClass.count", "Current Loaded Class Count", "classloader.currentLoadedClass.count.description", MetricType.COUNTER, "none"));
        registry.register("classloader.totalLoadedClass.count", (Metric)new BMCounter("java.lang:type=ClassLoading", "TotalLoadedClassCount"), new Metadata("classloader.totalLoadedClass.count", "Total Loaded Class Count", "classloader.totalLoadedClass.count.description", MetricType.COUNTER, "none"));
        registry.register("classloader.totalUnloadedClass.count", (Metric)new BMCounter("java.lang:type=ClassLoading", "UnloadedClassCount"), new Metadata("classloader.totalUnloadedClass.count", "Total Unloaded Class Count", "classloader.totalUnloadedClass.count.description", MetricType.COUNTER, "none"));
        registry.register("cpu.availableProcessors", new BMGauge("java.lang:type=OperatingSystem", "AvailableProcessors"), new Metadata("cpu.availableProcessors", "Available Processors", "cpu.availableProcessors.description", MetricType.GAUGE, "none"));
        registry.register("cpu.systemLoadAverage", new BMGauge("java.lang:type=OperatingSystem", "SystemLoadAverage"), new Metadata("cpu.systemLoadAverage", "System Load Average", "cpu.systemLoadAverage.description", MetricType.GAUGE, "none"));
        registry.register("cpu.processCpuLoad", new BMGauge("java.lang:type=OperatingSystem", "ProcessCpuLoad"), new Metadata("cpu.processCpuLoad", "Process CPU Load", "cpu.processCpuLoad.description", MetricType.GAUGE, "percent"));
        for (String gcName : gcObjectNames) {
            String gcNameNoSpace = this.removeSpaces(gcName);
            String nameToRegister = "gc." + gcNameNoSpace + ".count";
            registry.register(nameToRegister, (Metric)new BMCounter("java.lang:type=GarbageCollector,name=" + gcName, "CollectionCount"), new Metadata(nameToRegister, "Garbage Collection Count", "garbageCollectionCount.description", MetricType.COUNTER, "none"));
            nameToRegister = "gc." + gcNameNoSpace + ".time";
            registry.register(nameToRegister, new BMGauge("java.lang:type=GarbageCollector,name=" + gcName, "CollectionTime"), new Metadata(nameToRegister, "Garbage Collection Time", "garbageCollectionTime.description", MetricType.GAUGE, "milliseconds"));
        }
    }

    private String removeSpaces(String aString) {
        return aString.replaceAll("\\s+", "");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BaseMetrics.class);
        baseMetrics = null;
        BASE = MetricRegistry.Type.BASE.getName();
        gcObjectNames = new HashSet<String>();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class BMCounter
    extends CounterImpl {
        String objectName;
        String attribute;
        static final long serialVersionUID = 879823269078749467L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public BMCounter(String objectName, String attribute) {
            this.objectName = objectName;
            this.attribute = attribute;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getCount() {
            try {
                Number value = (Number)BaseMetrics.this.mbs.getAttribute(new ObjectName(this.objectName), this.attribute);
                return value.longValue();
            }
            catch (Exception value) {
                void e;
                FFDCFilter.processException((Throwable)value, (String)"com.ibm.ws.microprofile.metrics.BaseMetrics$BMCounter", (String)"182", (Object)this, (Object[])new Object[0]);
                e.printStackTrace();
                return 0L;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BMCounter.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class BMGauge<T>
    implements Gauge<T> {
        String objectName;
        String attribute;
        String subAttribute;
        boolean isComposite = false;
        static final long serialVersionUID = -2426175065504428914L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public BMGauge(String objectName, String attribute) {
            this.objectName = objectName;
            this.attribute = attribute;
        }

        public BMGauge(String objectName, String attribute, String subAttribute) {
            this.objectName = objectName;
            this.attribute = attribute;
            this.subAttribute = subAttribute;
            this.isComposite = true;
        }

        /*
         * WARNING - void declaration
         */
        public T getValue() {
            try {
                if (this.isComposite) {
                    CompositeData value = (CompositeData)BaseMetrics.this.mbs.getAttribute(new ObjectName(this.objectName), this.attribute);
                    return (T)value.get(this.subAttribute);
                }
                Object value = BaseMetrics.this.mbs.getAttribute(new ObjectName(this.objectName), this.attribute);
                return (T)value;
            }
            catch (Exception value) {
                void e;
                FFDCFilter.processException((Throwable)value, (String)"com.ibm.ws.microprofile.metrics.BaseMetrics$BMGauge", (String)"162", (Object)this, (Object[])new Object[0]);
                e.printStackTrace();
                return null;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BMGauge.class);
        }
    }
}

