/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.interfaces.ConfigException;
import com.ibm.ws.microprofile.config.interfaces.WebSphereConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.config.Config;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigWrapper {
    private static final TraceComponent tc = Tr.register(ConfigWrapper.class);
    private final WebSphereConfig config;
    private final Set<String> applications = new HashSet<String>();
    static final long serialVersionUID = 5993055272243569981L;

    ConfigWrapper(WebSphereConfig config) {
        this.config = config;
    }

    void addApplication(String appName) {
        this.applications.add(appName);
    }

    boolean removeApplication(String appName) {
        boolean close = false;
        boolean removed = this.applications.remove(appName);
        if (removed && this.applications.size() == 0) {
            close = true;
        }
        return close;
    }

    /*
     * WARNING - void declaration
     */
    void close() {
        this.applications.clear();
        try {
            this.config.close();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.microprofile.config.impl.ConfigWrapper", (String)"57", (Object)this, (Object[])new Object[0]);
            throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"could.not.close.CWMCG0004E", (Object[])new Object[]{e}));
        }
    }

    Set<String> getApplications() {
        return this.applications;
    }

    Config getConfig() {
        return this.config;
    }
}

