/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.archaius.composite;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.microprofile.config.archaius.composite.ConfigListener;
import com.ibm.ws.microprofile.config.archaius.composite.PollingDynamicConfig;
import com.ibm.ws.microprofile.config.impl.ConversionManager;
import com.ibm.ws.microprofile.config.impl.SortedSources;
import com.ibm.ws.microprofile.config.impl.SourcedValueImpl;
import com.ibm.ws.microprofile.config.interfaces.SourcedValue;
import com.ibm.ws.microprofile.config.sources.StaticConfigSource;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Closeable;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.microprofile.config.spi.ConfigSource;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CompositeConfig
implements Closeable,
ConfigListener {
    private final CopyOnWriteArrayList<PollingDynamicConfig> children = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ConfigListener> listeners = new CopyOnWriteArrayList();
    private final ConversionManager conversionManager;
    static final long serialVersionUID = 9150111704179708381L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public CompositeConfig(ConversionManager conversionManager, SortedSources sources, ScheduledExecutorService executor, long refreshInterval) {
        this.conversionManager = conversionManager;
        for (ConfigSource source : sources) {
            this.addConfig(source, executor, refreshInterval);
        }
    }

    @Override
    public void onConfigAdded() {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigAdded();
        }
    }

    @Override
    public void onConfigUpdated() {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigUpdated();
        }
    }

    private PollingDynamicConfig addConfig(ConfigSource source, ScheduledExecutorService executor, long refreshInterval) {
        if (source instanceof StaticConfigSource) {
            refreshInterval = 0L;
        }
        PollingDynamicConfig archaiusConfig = new PollingDynamicConfig(source, executor, refreshInterval);
        this.children.add(archaiusConfig);
        this.onConfigAdded();
        archaiusConfig.addListener(this);
        return archaiusConfig;
    }

    public void addListener(ConfigListener listener) {
        this.listeners.add(listener);
    }

    public Set<String> getKeySet() {
        HashSet<String> result = new HashSet<String>();
        for (PollingDynamicConfig config : this.children) {
            Iterator<String> iter = config.getKeys();
            while (iter.hasNext()) {
                String key = iter.next();
                result.add(key);
            }
        }
        return result;
    }

    @Trivial
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompositeConfig[");
        sb.append(this.hashCode());
        sb.append("](");
        sb.append(this.children.size());
        sb.append(" children");
        sb.append(")");
        return sb.toString();
    }

    @Trivial
    public String dump() {
        StringBuilder sb = new StringBuilder();
        Set<String> keys = this.getKeySet();
        keys = new TreeSet<String>(keys);
        Iterator<String> keyItr = keys.iterator();
        while (keyItr.hasNext()) {
            String key = keyItr.next();
            SourcedValue rawCompositeValue = this.getRawCompositeValue(key);
            if (rawCompositeValue == null) {
                sb.append("null");
            } else {
                sb.append(rawCompositeValue);
            }
            if (!keyItr.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void close() {
        for (PollingDynamicConfig child : this.children) {
            child.close();
        }
    }

    public SourcedValue getSourcedValue(Type type, String key) {
        SourcedValueImpl sourcedValue = null;
        SourcedValue rawProp = this.getRawCompositeValue(key);
        if (rawProp != null) {
            Object value = this.conversionManager.convert((String)rawProp.getValue(), type);
            sourcedValue = new SourcedValueImpl(key, value, type, rawProp.getSource());
        }
        return sourcedValue;
    }

    @Trivial
    private SourcedValue getRawCompositeValue(String key) {
        SourcedValueImpl raw = null;
        for (PollingDynamicConfig child : this.children) {
            String value = child.getRawProperty(key);
            if (value == null && !child.containsKey(key)) continue;
            String source = child.getSourceID();
            raw = new SourcedValueImpl(key, value, (Type)((Object)String.class), source);
            break;
        }
        return raw;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CompositeConfig.class);
    }
}

