/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.archaius.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.microprofile.config.archaius.cache.TypeContainer;
import com.ibm.ws.microprofile.config.archaius.composite.CompositeConfig;
import com.ibm.ws.microprofile.config.interfaces.SourcedValue;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicStampedReference;

@Trivial
public class StampedValue {
    private static final TraceComponent tc = Tr.register(StampedValue.class);
    private final AtomicStampedReference<SourcedValue> stampedValue = new AtomicStampedReference<Object>(null, -1);
    private final Type type;
    private final TypeContainer parentContainer;
    private final CompositeConfig config;

    StampedValue(Type type, TypeContainer parentContainer, CompositeConfig config) {
        this.type = type;
        this.parentContainer = parentContainer;
        this.config = config;
    }

    public SourcedValue getSourced() {
        SourcedValue newValue;
        SourcedValue currentValue;
        boolean fromCache = true;
        int cacheVersion = this.stampedValue.getStamp();
        int latestVersion = this.parentContainer.getMasterVersion();
        String key = this.parentContainer.getKey();
        SourcedValue sourcedValue = null;
        if (cacheVersion != latestVersion && this.stampedValue.compareAndSet(currentValue = this.stampedValue.getReference(), newValue = this.config.getSourcedValue(this.type, key), cacheVersion, latestVersion)) {
            sourcedValue = newValue;
            fromCache = false;
        }
        if (fromCache) {
            sourcedValue = this.stampedValue.getReference();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (sourcedValue != null) {
                Tr.debug((TraceComponent)tc, (String)"get: Key={0}, Value={1}", (Object[])new Object[]{key, sourcedValue});
            } else {
                Tr.debug((TraceComponent)tc, (String)"get: Key={0} not found", (Object[])new Object[]{key});
            }
        }
        return sourcedValue;
    }

    protected Type getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StampedValue other = (StampedValue)obj;
        return this.type == other.type;
    }

    @Trivial
    public String toString() {
        return this.stampedValue.getReference() + "[version:" + this.stampedValue.getStamp() + "]";
    }
}

