/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils.xml.ra;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jca.utils.xml.ra.RaDescription;
import com.ibm.ws.jca.utils.xml.ra.v10.Ra10AuthenticationMechanism;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;

@Trivial
@XmlType(propOrder={"description", "authenticationMechanismType", "credentialInterface"})
public class RaAuthenticationMechanism {
    private static final String PasswordCredential = "javax.resource.spi.security.PasswordCredential";
    private static final String GSSCredential = "org.ietf.jgss.GSSCredential";
    private static final String GenericCredential = "javax.resource.spi.security.GenericCredential";
    private static final Set<String> credentialInterfaceTypes;
    @XmlElement(name="description")
    private final List<RaDescription> description = new LinkedList<RaDescription>();
    private String credentialInterface;
    private String authenticationMechanismType;
    private String id;

    public List<RaDescription> getDescription() {
        return this.description;
    }

    public String getCredentialInterface() {
        return this.credentialInterface;
    }

    @XmlElement(name="credential-interface", required=true)
    public void setCredentialInterface(String credType) {
        if (credType == null || !credentialInterfaceTypes.contains(credType)) {
            throw new IllegalArgumentException("credential-interface: " + this.credentialInterface);
        }
        this.credentialInterface = credType;
    }

    public String getAuthenticationMechanismType() {
        return this.authenticationMechanismType;
    }

    @XmlElement(name="authentication-mechanism-type", required=true)
    public void setAuthenticationMechanismType(String authMech) {
        AuthenticationMechanismType type = AuthenticationMechanismType.valueOf(authMech);
        this.authenticationMechanismType = type.name();
    }

    public String getId() {
        return this.id;
    }

    @XmlID
    @XmlAttribute(name="id")
    public void setId(String id) {
        this.id = id;
    }

    public void copyRa10Settings(Ra10AuthenticationMechanism mechanism) {
        if (mechanism.getDescription() != null) {
            RaDescription desc = new RaDescription();
            desc.setValue(mechanism.getDescription());
            this.description.add(desc);
        }
        this.authenticationMechanismType = mechanism.getAuthMechType();
        this.credentialInterface = mechanism.getCredentialInterface();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RaAuthenticationMechanism{");
        sb.append("credential-interface='");
        if (this.credentialInterface != null) {
            sb.append(this.credentialInterface);
        }
        sb.append("'}");
        return sb.toString();
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add(PasswordCredential);
        types.add(GSSCredential);
        types.add(GenericCredential);
        credentialInterfaceTypes = Collections.unmodifiableSet(types);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class AuthenticationMechanismType
    extends Enum<AuthenticationMechanismType> {
        public static final /* enum */ AuthenticationMechanismType BasicPassword;
        public static final /* enum */ AuthenticationMechanismType Kerbv5;
        private static final /* synthetic */ AuthenticationMechanismType[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static AuthenticationMechanismType[] values() {
            return (AuthenticationMechanismType[])$VALUES.clone();
        }

        public static AuthenticationMechanismType valueOf(String name) {
            return Enum.valueOf(AuthenticationMechanismType.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AuthenticationMechanismType.class);
            BasicPassword = new AuthenticationMechanismType();
            Kerbv5 = new AuthenticationMechanismType();
            $VALUES = new AuthenticationMechanismType[]{BasicPassword, Kerbv5};
        }
    }
}

