/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.introspect;

import com.ibm.ws.ras.instrument.internal.model.TraceOptionsData;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;

public class TraceOptionsAnnotationVisitor
extends AnnotationVisitor {
    protected List<String> traceGroups = new ArrayList<String>();
    protected String messageBundle;
    protected boolean traceExceptionThrow;
    protected boolean traceExceptionHandling;

    public TraceOptionsAnnotationVisitor() {
        super(458752);
    }

    public TraceOptionsAnnotationVisitor(AnnotationVisitor av) {
        super(458752, av);
    }

    public void visit(String name, Object value) {
        if ("traceGroup".equals(name)) {
            String traceGroup = (String)String.class.cast(value);
            if (!this.traceGroups.contains(traceGroup)) {
                this.traceGroups.add(traceGroup);
            }
        } else if ("messageBundle".equals(name)) {
            this.messageBundle = (String)String.class.cast(value);
        } else if ("traceExceptionThrow".equals(name)) {
            this.traceExceptionThrow = (Boolean)Boolean.class.cast(value);
        } else if ("traceExceptionHandling".equals(name)) {
            this.traceExceptionHandling = (Boolean)Boolean.class.cast(value);
        }
        super.visit(name, value);
    }

    public AnnotationVisitor visitArray(String name) {
        AnnotationVisitor av = super.visitArray(name);
        if ("traceGroups".equals(name)) {
            av = new TraceGroupsValueArrayVisitor(av);
        }
        return av;
    }

    public TraceOptionsData getTraceOptionsData() {
        return new TraceOptionsData(this.traceGroups, this.messageBundle, this.traceExceptionThrow, this.traceExceptionHandling);
    }

    private final class TraceGroupsValueArrayVisitor
    extends AnnotationVisitor {
        private TraceGroupsValueArrayVisitor(AnnotationVisitor av) {
            super(458752, av);
        }

        public void visit(String name, Object value) {
            String traceGroup = (String)String.class.cast(value);
            if (!"".equals(traceGroup) && !TraceOptionsAnnotationVisitor.this.traceGroups.contains(traceGroup)) {
                TraceOptionsAnnotationVisitor.this.traceGroups.add(traceGroup);
            }
            super.visit(name, value);
        }
    }
}

