/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.bci;

import org.objectweb.asm.ClassVisitor;

public class CheckInstrumentableClassAdapter
extends ClassVisitor {
    private String classInternalName;
    private boolean isInterface;
    private boolean isSynthetic;

    public CheckInstrumentableClassAdapter(ClassVisitor visitor) {
        super(458752, visitor);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classInternalName = name;
        this.isInterface = (access & 0x200) != 0;
        this.isSynthetic = (access & 0x1000) != 0;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public boolean isInstrumentableClass() {
        if (this.isInterface) {
            return false;
        }
        if (this.isSynthetic) {
            return false;
        }
        if (this.classInternalName.equals("java/lang/Object")) {
            return false;
        }
        if (this.classInternalName.startsWith("$Proxy")) {
            return false;
        }
        return !this.classInternalName.endsWith("/package-info");
    }

    public boolean isInstrumentableMethod(int access, String methodName, String descriptor) {
        if ((access & 0x1000) != 0) {
            return false;
        }
        if ((access & 0x100) != 0) {
            return false;
        }
        if ((access & 0x400) != 0) {
            return false;
        }
        if (methodName.equals("toString") && descriptor.equals("()Ljava/lang/String;")) {
            return false;
        }
        return !methodName.equals("hashCode") || !descriptor.equals("()I");
    }
}

