/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.rest.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class ConfigBasedRESTHandler
implements RESTHandler {
    private static final TraceComponent tc = Tr.register(ConfigBasedRESTHandler.class);
    static final long serialVersionUID = -2848720602537459973L;

    public boolean filterBy(String name) {
        return false;
    }

    public String getAPIRoot() {
        return "/validator";
    }

    private static String getDeepestNestedElementName(String configDisplayId) {
        int end;
        int start = configDisplayId.lastIndexOf("]/");
        if (start > 1 && (end = configDisplayId.indexOf(91, start += 2)) > start) {
            return configDisplayId.substring(start, end);
        }
        return null;
    }

    @Trivial
    private static String getUID(String configDisplayId, String id) {
        return id == null || configDisplayId.matches(".*/.*\\[.*\\].*") ? configDisplayId : id;
    }

    public abstract Object handleError(RESTRequest var1, String var2, String var3);

    @Override
    @ManualTrace
    public final void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        Object result;
        Configuration[] configurations;
        String path = request.getPath();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"handleRequest", (Object[])new Object[]{path});
        }
        String apiRoot = this.getAPIRoot();
        String uid = null;
        int endElementName = path.indexOf(47, apiRoot.length() + 1);
        if (endElementName < 0) {
            endElementName = path.length();
        } else {
            uid = URLDecoder.decode(path.substring(endElementName + 1), "UTF-8");
            if (uid.length() == 0) {
                uid = null;
            }
        }
        String elementName = URLDecoder.decode(path.substring(apiRoot.length() + 1, endElementName), "UTF-8");
        StringBuilder filter = new StringBuilder("(&");
        if (uid != null && (uid.startsWith(elementName + "[default-") || uid.matches(".*/.*\\[.*\\].*"))) {
            filter.append(FilterUtils.createPropertyFilter((String)"config.displayId", (String)uid));
        } else if (elementName.length() > 0) {
            filter.append("(|(config.displayId=*" + elementName + "[*)(config.displayId=*" + elementName + "))");
            if (uid != null) {
                filter.append(FilterUtils.createPropertyFilter((String)"id", (String)uid));
            }
        } else {
            filter.append("(config.displayId=*)");
            if (uid != null) {
                filter.append(FilterUtils.createPropertyFilter((String)"id", (String)uid));
            }
        }
        for (Map.Entry<String, String[]> param : request.getParameterMap().entrySet()) {
            String key = param.getKey();
            if (!this.filterBy(key) || "_".equals(key)) continue;
            String[] values = param.getValue();
            if (values.length > 1) {
                filter.append("(|");
            }
            for (String value : values) {
                filter.append(FilterUtils.createPropertyFilter((String)key, (String)value));
            }
            if (values.length <= 1) continue;
            filter.append(')');
        }
        filter.append(')');
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"filter", (Object[])new Object[]{filter});
        }
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference configAdminRef = bundleContext.getServiceReference(ConfigurationAdmin.class);
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)bundleContext.getService(configAdminRef);
        try {
            configurations = configAdmin.listConfigurations(filter.toString());
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.wsspi.rest.config.ConfigBasedRESTHandler", (String)"189", (Object)this, (Object[])new Object[]{request, response});
            configurations = null;
        }
        TreeMap<String, Dictionary> configMap = new TreeMap<String, Dictionary>();
        if (configurations != null) {
            for (Configuration c : configurations) {
                String servicePid;
                Dictionary props = c.getProperties();
                String configDisplayId = (String)props.get("config.displayId");
                Dictionary previousProps = configMap.put(configDisplayId, props);
                if (previousProps == null || ((servicePid = (String)previousProps.get("service.pid")) == null || servicePid.contains(elementName)) && previousProps.get("ibm.extends.source.factoryPid") == null) continue;
                configMap.put(configDisplayId, previousProps);
            }
        }
        if (uid == null) {
            ArrayList<Object> results = new ArrayList<Object>();
            for (Map.Entry entry : configMap.entrySet()) {
                String id;
                String configDisplayId = (String)entry.getKey();
                String nestedElementName = ConfigBasedRESTHandler.getDeepestNestedElementName(configDisplayId);
                if (nestedElementName != null && !nestedElementName.equals(elementName)) continue;
                Dictionary configProps = (Dictionary)entry.getValue();
                String uniqueId = configDisplayId.endsWith("]") ? ConfigBasedRESTHandler.getUID(configDisplayId, (String)configProps.get("id")) : null;
                Object r = this.handleSingleInstance(request, uniqueId, (id = (String)configProps.get("id")) == null || ConfigBasedRESTHandler.isGenerated(id) ? null : id, configProps);
                if (r == null) continue;
                results.add(r);
            }
            result = results;
        } else {
            String id;
            Dictionary configProps;
            Map.Entry entry;
            String configDisplayId;
            String uniqueId;
            result = configMap.isEmpty() ? null : (configMap.size() == 1 ? (uid.equals(uniqueId = ConfigBasedRESTHandler.getUID(configDisplayId = (String)(entry = configMap.firstEntry()).getKey(), (String)(configProps = (Dictionary)entry.getValue()).get("id"))) ? this.handleSingleInstance(request, uid, (id = (String)configProps.get("id")) == null || ConfigBasedRESTHandler.isGenerated(id) ? null : id, (Dictionary)entry.getValue()) : this.handleError(request, null, "Unique identifier " + uid + " is not valid. Expected: " + uniqueId)) : this.handleError(request, null, "multiple found"));
        }
        if (result == null) {
            result = this.handleError(request, uid, "Did not find any configured instances of " + elementName + " matching the request");
        }
        this.populateResponse(response, result);
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"handleRequest");
        }
    }

    public abstract Object handleSingleInstance(RESTRequest var1, String var2, String var3, Dictionary<String, Object> var4) throws IOException;

    private static boolean isGenerated(String id) {
        return id.matches(".*//.*\\[.*\\].*");
    }

    public abstract void populateResponse(RESTResponse var1, Object var2) throws IOException;
}

