/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import com.ibm.ws.logging.collector.BurstDateFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class DateFormatHelper {
    private static ThreadLocal<BurstDateFormat[]> dateformats = new ThreadLocal();
    private static final String localeDatePattern;

    public static final String formatTime(long timestamp, boolean useIsoDateFormat) {
        BurstDateFormat[] dfs = dateformats.get();
        if (dfs == null) {
            dfs = new BurstDateFormat[useIsoDateFormat ? 2 : 1];
            dateformats.set(dfs);
        } else if (useIsoDateFormat && dfs.length == 1) {
            BurstDateFormat[] newDfs = new BurstDateFormat[2];
            newDfs[0] = dfs[0];
            dfs = newDfs;
            dateformats.set(dfs);
        }
        int index = useIsoDateFormat ? 1 : 0;
        BurstDateFormat df = dfs[index];
        if (df == null) {
            df = dfs[index] = new BurstDateFormat(new SimpleDateFormat(useIsoDateFormat ? "yyyy-MM-dd'T'HH:mm:ss.SSSZ" : localeDatePattern));
        }
        return df.format(timestamp);
    }

    static {
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
        if (formatter instanceof SimpleDateFormat) {
            SimpleDateFormat sdFormatter = (SimpleDateFormat)formatter;
            String pattern = sdFormatter.toPattern();
            int patternLength = pattern.length();
            int endOfSecsIndex = pattern.lastIndexOf(115) + 1;
            String newPattern = pattern.substring(0, endOfSecsIndex) + ":SSS z";
            if (endOfSecsIndex < patternLength) {
                newPattern = newPattern + pattern.substring(endOfSecsIndex, patternLength);
            }
            newPattern = newPattern.replace('h', 'H');
            newPattern = newPattern.replace('K', 'H');
            newPattern = newPattern.replace('k', 'H');
            newPattern = newPattern.replace('a', ' ');
            localeDatePattern = newPattern = newPattern.trim();
        } else {
            localeDatePattern = "dd/MMM/yyyy HH:mm:ss:SSS z";
        }
    }
}

