/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.adaptable.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.adaptable.module.NotifierExtension;
import com.ibm.ws.artifact.ArtifactNotifierExtension;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.DefaultNotification;
import com.ibm.wsspi.adaptable.module.Notifier;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactNotifier;
import com.ibm.wsspi.artifact.DefaultArtifactNotification;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NotifierImpl
implements Notifier {
    private final Container root;
    private final ArtifactNotifier delegateNotifier;
    private final ArtifactContainer delegateRoot;
    private final Map<Notifier.NotificationListener, DelegateListener> listenerDelegates = new HashMap<Notifier.NotificationListener, DelegateListener>();
    static final long serialVersionUID = 6839382523957017880L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public NotifierImpl(ArtifactContainer delegateRoot, Container root) {
        this.delegateRoot = delegateRoot;
        this.delegateNotifier = delegateRoot.getArtifactNotifier();
        this.root = root;
    }

    private void verifyTargets(Notifier.Notification targets) {
        if (targets.getContainer().getRoot() != this.root) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean registerForNotifications(Notifier.Notification targets, Notifier.NotificationListener callbackObject) throws IllegalArgumentException {
        this.verifyTargets(targets);
        DefaultArtifactNotification artifactNotification = new DefaultArtifactNotification(this.delegateRoot, targets.getPaths());
        DelegateListener listener = new DelegateListener(this.root, callbackObject);
        boolean isRegistered = this.delegateNotifier.registerForNotifications((ArtifactNotifier.ArtifactNotification)artifactNotification, (ArtifactNotifier.ArtifactListener)listener);
        if (isRegistered) {
            this.listenerDelegates.put(callbackObject, listener);
        }
        return isRegistered;
    }

    @Override
    public boolean removeListener(Notifier.NotificationListener listenerToRemove) {
        ArtifactNotifier.ArtifactListener delegateListener = (ArtifactNotifier.ArtifactListener)this.listenerDelegates.remove(listenerToRemove);
        return this.delegateNotifier.removeListener(delegateListener);
    }

    @Override
    public boolean setNotificationOptions(long interval, boolean useMBean) {
        return this.delegateNotifier.setNotificationOptions(interval, useMBean);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(NotifierImpl.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class DelegateListener
    implements ArtifactNotifierExtension.ArtifactListener {
        private final Notifier.NotificationListener listenerToInform;
        private String id;
        static final long serialVersionUID = 5772772784949532200L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public DelegateListener(Container root, Notifier.NotificationListener listenerToInform) {
            this.listenerToInform = listenerToInform;
            if (listenerToInform instanceof NotifierExtension.NotificationListener) {
                this.id = ((NotifierExtension.NotificationListener)listenerToInform).getId();
            }
        }

        public void notifyEntryChange(ArtifactNotifier.ArtifactNotification added, ArtifactNotifier.ArtifactNotification removed, ArtifactNotifier.ArtifactNotification modified) {
            this.notifyEntryChange(added, removed, modified, null);
        }

        public void notifyEntryChange(ArtifactNotifier.ArtifactNotification added, ArtifactNotifier.ArtifactNotification removed, ArtifactNotifier.ArtifactNotification modified, String filter) {
            DefaultNotification addedNotification = new DefaultNotification(NotifierImpl.this.root, added.getPaths());
            DefaultNotification removedNotification = new DefaultNotification(NotifierImpl.this.root, removed.getPaths());
            DefaultNotification modifiedNotification = new DefaultNotification(NotifierImpl.this.root, modified.getPaths());
            this.listenerToInform.notifyEntryChange(addedNotification, removedNotification, modifiedNotification);
        }

        public String getId() {
            return this.id;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DelegateListener.class);
        }
    }
}

