/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.cache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.zip.cache.ZipCachingProperties;
import com.ibm.ws.artifact.zip.cache.ZipCachingService;
import com.ibm.ws.artifact.zip.cache.ZipFileHandle;
import com.ibm.ws.artifact.zip.cache.internal.ZipFileHandleImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ZipCachingServiceImpl
implements ZipCachingService {
    private static final ZipFileHandlesLock zipFileHandlesLock;
    private static final LinkedHashMap<String, ZipFileHandle> zipFileHandles;
    static final long serialVersionUID = 2484763330504115050L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    @Trivial
    public ZipFileHandle openZipFile(String path) throws IOException {
        return ZipCachingServiceImpl.getZipFileHandle(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ZipFileHandle getZipFileHandle(String path) throws IOException {
        ZipFileHandlesLock zipFileHandlesLock = ZipCachingServiceImpl.zipFileHandlesLock;
        synchronized (zipFileHandlesLock) {
            ZipFileHandle handle = zipFileHandles.get(path);
            if (handle == null) {
                handle = new ZipFileHandleImpl(path);
                zipFileHandles.put(path, handle);
            }
            return handle;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ZipCachingServiceImpl.class);
        zipFileHandlesLock = new ZipFileHandlesLock();
        final int handleMax = ZipCachingProperties.ZIP_CACHE_HANDLE_MAX;
        int initialAllocation = handleMax == -1 ? 16 : handleMax;
        zipFileHandles = new LinkedHashMap<String, ZipFileHandle>(initialAllocation, 0.75f, true){
            private static final long serialVersionUID = 1L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ZipFileHandle> eldest) {
                return handleMax != -1 && this.size() > handleMax;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ZipFileHandlesLock {
        static final long serialVersionUID = -9040361189385382510L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ZipFileHandlesLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ZipFileHandlesLock.class);
        }
    }
}

