/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.opentracing.rest.client.listener;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.opentracing.OpentracingClientFilter;
import com.ibm.ws.opentracing.OpentracingJaxRsProviderRegister;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import org.eclipse.microprofile.opentracing.Traced;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OpentracingRestClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final TraceComponent tc = Tr.register(OpentracingRestClientFilter.class);
    private OpentracingClientFilter clientFilter = null;
    static final long serialVersionUID = 6776972543422917782L;

    public OpentracingRestClientFilter() {
        OpentracingJaxRsProviderRegister jaxRsProvider = OpentracingJaxRsProviderRegister.getInstance();
        if (jaxRsProvider == null) {
            Tr.debug((TraceComponent)tc, (String)"OpentracingJaxRsProviderRegister.getInstance() returned null", (Object[])new Object[0]);
        } else {
            this.clientFilter = jaxRsProvider.getClientFilter();
        }
    }

    public void filter(ClientRequestContext clientRequestContext) throws IOException {
        Method method;
        Traced traced;
        Object invokedMethod = clientRequestContext.getProperty("org.eclipse.microprofile.rest.client.invokedMethod");
        if (invokedMethod != null && (traced = (method = (Method)invokedMethod).getAnnotation(Traced.class)) != null && !traced.value()) {
            Tr.debug((TraceComponent)tc, (String)("@Traced(false) on method " + method.getName()), (Object[])new Object[0]);
            return;
        }
        if (this.clientFilter != null) {
            this.clientFilter.filter(clientRequestContext);
        } else {
            Tr.debug((TraceComponent)tc, (String)"clientFilter is null", (Object[])new Object[0]);
        }
    }

    public void filter(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) throws IOException {
        if (this.clientFilter != null) {
            this.clientFilter.filter(clientRequestContext, clientResponseContext);
        } else {
            Tr.debug((TraceComponent)tc, (String)"clientFilter is null", (Object[])new Object[0]);
        }
    }
}

