/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.web.PasswordExpiredException;
import com.ibm.websphere.security.web.UserRevokedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.security.thread.ThreadIdentityException;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.audit.Audit;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.authentication.cache.AuthCacheService;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.collaborator.CollaboratorUtils;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.JaspiService;
import com.ibm.ws.webcontainer.security.LoggedOutTokenCacheImpl;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.UnprotectedResourceService;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebSecurityContext;
import com.ibm.ws.webcontainer.security.internal.BasicAuthAuthenticator;
import com.ibm.ws.webcontainer.security.internal.ChallengeReply;
import com.ibm.ws.webcontainer.security.internal.DenyReply;
import com.ibm.ws.webcontainer.security.internal.RedirectReply;
import com.ibm.ws.webcontainer.security.internal.SRTServletRequestUtils;
import com.ibm.ws.webcontainer.security.internal.SSOAuthenticator;
import com.ibm.ws.webcontainer.security.internal.TAIChallengeReply;
import com.ibm.ws.webcontainer.security.internal.WebReply;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.webcontainer.webapp.IWebAppDispatcherContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuthenticateApi {
    private static final TraceComponent tc = Tr.register(AuthenticateApi.class);
    static final String KEY_SECURITY_SERVICE = "securityService";
    protected AtomicServiceReference<SecurityService> securityServiceRef = null;
    private final SubjectManager subjectManager = new SubjectManager();
    private final SubjectHelper subjectHelper = new SubjectHelper();
    private final SSOCookieHelper ssoCookieHelper;
    private AuthCacheService authCacheService = null;
    private final CollaboratorUtils collabUtils;
    private AuthenticationService authService = null;
    private ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRefs = null;
    private ConcurrentServiceReferenceMap<String, UnprotectedResourceService> unprotectedResourceServiceRef = null;
    private UnauthenticatedSubjectService unauthenticatedSubjectService;
    protected static final WebReply DENY_AUTHN_FAILED = new DenyReply("AuthenticationFailed");
    private Subject logoutSubject = null;
    private final String SECURITY_CONTEXT = "SECURITY_CONTEXT";
    static final long serialVersionUID = -2131384459928344098L;

    public AuthenticateApi(SSOCookieHelper ssoCookieHelper, AtomicServiceReference<SecurityService> securityServiceRef, CollaboratorUtils collabUtils, ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRef, ConcurrentServiceReferenceMap<String, UnprotectedResourceService> unprotectedResourceServiceRef, UnauthenticatedSubjectService unauthenticatedSubjectService) {
        SecurityService ss;
        this.ssoCookieHelper = ssoCookieHelper;
        this.securityServiceRef = securityServiceRef;
        this.collabUtils = collabUtils;
        this.webAuthenticatorRefs = webAuthenticatorRef;
        this.unprotectedResourceServiceRef = unprotectedResourceServiceRef;
        this.unauthenticatedSubjectService = unauthenticatedSubjectService;
        if (securityServiceRef != null && (ss = (SecurityService)securityServiceRef.getService()) != null) {
            this.authService = ss.getAuthenticationService();
            if (this.authService != null) {
                this.authCacheService = this.authService.getAuthCacheService();
            }
        }
    }

    public AuthenticateApi(SSOCookieHelper ssoCookieHelper, AuthenticationService authService) {
        this.securityServiceRef = null;
        this.collabUtils = null;
        this.authCacheService = null;
        this.authService = authService;
        this.ssoCookieHelper = ssoCookieHelper;
    }

    public void login(HttpServletRequest req, HttpServletResponse resp, String username, @Sensitive String password, WebAppSecurityConfig config, BasicAuthAuthenticator basicAuthAuthenticator) throws ServletException {
        String isJaspiAuthenticated = (String)req.getServletContext().getAttribute("com.ibm.ws.security.jaspi.authenticated");
        if (isJaspiAuthenticated != null && isJaspiAuthenticated.equals(Boolean.toString(Boolean.TRUE))) {
            throw new ServletException("The login method may not be invoked while JASPI authentication is active.");
        }
        boolean logoutOnHttpSessionExp = config.getLogoutOnHttpSessionExpire();
        if (req.getRequestedSessionId() != null && !req.isRequestedSessionIdValid() && logoutOnHttpSessionExp) {
            req.getSession(true);
        }
        this.throwExceptionIfAlreadyAuthenticate(req, resp, config, username);
        AuthenticationResult authResult = basicAuthAuthenticator.basicAuthenticate(null, username, password, req, resp);
        if (authResult == null || authResult.getStatus() != AuthResult.SUCCESS) {
            String realm = authResult.realm;
            if (realm == null) {
                realm = this.collabUtils.getUserRegistryRealm(this.securityServiceRef);
            }
            WebReply reply = null;
            reply = this.createReplyForAuthnFailure(authResult, realm);
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_API_AUTHN_01, (Object[])new Object[]{req, authResult, reply.getStatusCode()});
            if (authResult.passwordExpired) {
                throw new PasswordExpiredException(authResult.getReason());
            }
            if (authResult.userRevoked) {
                throw new UserRevokedException(authResult.getReason());
            }
            throw new ServletException(authResult.getReason());
        }
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_API_AUTHN_01, (Object[])new Object[]{req, authResult, 200});
        this.postProgrammaticAuthenticate(req, resp, authResult);
    }

    public void logout(HttpServletRequest req, HttpServletResponse res, WebAppSecurityConfig config) throws ServletException {
        this.logoutUnprotectedResourceServiceRef(req, res);
        this.createSubjectAndPushItOnThreadAsNeeded(req, res);
        AuthenticationResult authResult = new AuthenticationResult(AuthResult.SUCCESS, this.subjectManager.getCallerSubject());
        JaspiService jaspiService = this.getJaspiService();
        if (jaspiService == null) {
            authResult.setAuditCredType(req.getAuthType());
            authResult.setAuditOutcome("success");
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_API_AUTHN_TERMINATE_01, (Object[])new Object[]{req, authResult, res.getStatus()});
        }
        this.removeEntryFromAuthCache(req, res, config);
        this.invalidateSession(req);
        this.ssoCookieHelper.removeSSOCookieFromResponse(res);
        this.ssoCookieHelper.createLogoutCookies(req, res);
        try {
            if (this.unauthenticatedSubjectService != null) {
                ThreadIdentityManager.setAppThreadIdentity((Subject)this.unauthenticatedSubjectService.getUnauthenticatedSubject());
            }
        }
        catch (ThreadIdentityException threadIdentityException) {
            FFDCFilter.processException((Throwable)threadIdentityException, (String)"com.ibm.ws.webcontainer.security.AuthenticateApi", (String)"204", (Object)this, (Object[])new Object[]{req, res, config});
        }
        ReferrerURLCookieHandler referrerURLHandler = config.createReferrerURLCookieHandler();
        referrerURLHandler.clearReferrerURLCookie(req, res, "WASReqURL");
        SRTServletRequestUtils.removePrivateAttribute(req, "AUTH_TYPE");
        this.postLogout(req, res);
        this.subjectManager.clearSubjects();
    }

    void logoutUnprotectedResourceServiceRef(HttpServletRequest req, HttpServletResponse res) {
        boolean bInitUserName = false;
        String userName = null;
        Set serviceIds = this.unprotectedResourceServiceRef.keySet();
        for (String serviceId : serviceIds) {
            if (!bInitUserName) {
                bInitUserName = true;
                userName = this.getSessionUserName(req, res);
            }
            UnprotectedResourceService service = (UnprotectedResourceService)this.unprotectedResourceServiceRef.getService((Object)serviceId);
            boolean bLogout = service.logout(req, res, userName);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("logout return " + bLogout + " on service " + service), (Object[])new Object[0]);
        }
    }

    void postLogout(HttpServletRequest req, HttpServletResponse res) {
        Set serviceIds = this.unprotectedResourceServiceRef.keySet();
        for (String serviceId : serviceIds) {
            UnprotectedResourceService service = (UnprotectedResourceService)this.unprotectedResourceServiceRef.getService((Object)serviceId);
            boolean bLogout = service.postLogout(req, res);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("postLogout returns " + bLogout + " on service " + service), (Object[])new Object[0]);
        }
    }

    String getSessionUserName(HttpServletRequest req, HttpServletResponse res) {
        String result = null;
        if (req instanceof SRTServletRequest) {
            SRTServletRequest servletRequest = (SRTServletRequest)req;
            IWebAppDispatcherContext webAppDispatchContext = servletRequest.getWebAppDispatcherContext();
            WebApp webApp = webAppDispatchContext.getWebApp();
            if (webApp != null) {
                IHttpSessionContext httpSessionContext = webApp.getSessionContext();
                if (httpSessionContext != null) {
                    result = httpSessionContext.getSessionUserName(req, res);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getSessionUserName:" + result), (Object[])new Object[0]);
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"no httpSessionContext in WebApp", (Object[])new Object[0]);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"no WebApp in SRTServletRequest", (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Not a SRTServletRequest" + req), (Object[])new Object[0]);
        }
        return result;
    }

    public void simpleLogout(HttpServletRequest req, HttpServletResponse res) {
        this.createSubjectAndPushItOnThreadAsNeeded(req, res);
        AuthenticationResult authResult = new AuthenticationResult(AuthResult.SUCCESS, this.subjectManager.getCallerSubject());
        authResult.setAuditCredType(req.getAuthType());
        authResult.setAuditOutcome("success");
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_API_AUTHN_TERMINATE_01, (Object[])new Object[]{req, authResult, res.getStatus()});
        this.removeEntryFromAuthCacheForUser(req, res);
        this.invalidateSession(req);
        this.ssoCookieHelper.removeSSOCookieFromResponse(res);
        this.ssoCookieHelper.createLogoutCookies(req, res);
        this.subjectManager.clearSubjects();
    }

    private void addToLoggedOutTokenCache(String tokenString) {
        String tokenValue = "userName";
        LoggedOutTokenCacheImpl.getInstance().addTokenToDistributedMap(tokenString, tokenValue);
    }

    private void removeEntryFromAuthCache(HttpServletRequest req, HttpServletResponse res, WebAppSecurityConfig config) {
        this.removeEntryFromAuthCacheForUser(req, res);
        this.removeEntryFromAuthCacheForToken(req, res, config);
    }

    /*
     * WARNING - void declaration
     */
    private void removeEntryFromAuthCacheForToken(HttpServletRequest req, HttpServletResponse res, WebAppSecurityConfig config) {
        this.getAuthCacheService();
        if (this.authCacheService == null) {
            return;
        }
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            String[] cookieValues = null;
            cookieValues = CookieHelper.getCookieValues(cookies, this.ssoCookieHelper.getSSOCookiename());
            if (!(cookieValues != null && cookieValues.length != 0 || "LtpaToken2".equalsIgnoreCase(this.ssoCookieHelper.getSSOCookiename()))) {
                cookieValues = CookieHelper.getCookieValues(cookies, "LtpaToken2");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cookie size: ", (Object[])new Object[]{cookieValues == null ? "<null>" : Integer.valueOf(cookieValues.length)});
            }
            if (cookieValues != null && cookieValues.length > 0) {
                for (int n = 0; n < cookieValues.length; ++n) {
                    String val = cookieValues[n];
                    if (val == null || val.length() <= 0) continue;
                    try {
                        this.authCacheService.remove((Object)val);
                        if (!config.isTrackLoggedOutSSOCookiesEnabled()) continue;
                        this.addToLoggedOutTokenCache(val);
                        continue;
                    }
                    catch (Exception exception) {
                        void e;
                        Principal p;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.security.AuthenticateApi", (String)"364", (Object)this, (Object[])new Object[]{req, res, config});
                        String user = req.getRemoteUser();
                        if (user == null && (p = req.getUserPrincipal()) != null) {
                            user = p.getName();
                        }
                        Tr.warning((TraceComponent)tc, (String)"AUTHENTICATE_CACHE_REMOVAL_EXCEPTION", (Object[])new Object[]{user, e.toString()});
                    }
                }
            }
        }
    }

    private void getAuthCacheService() {
        if (this.authCacheService == null && this.securityServiceRef != null) {
            this.authCacheService = ((SecurityService)this.securityServiceRef.getService()).getAuthenticationService().getAuthCacheService();
        }
    }

    private void removeEntryFromAuthCacheForUser(HttpServletRequest req, HttpServletResponse res) {
        Principal p;
        this.getAuthCacheService();
        if (this.authCacheService == null) {
            return;
        }
        String user = req.getRemoteUser();
        if (user == null && (p = req.getUserPrincipal()) != null) {
            user = p.getName();
        }
        if (user != null) {
            String realm;
            if (this.collabUtils != null && !user.contains((realm = this.collabUtils.getUserRegistryRealm(this.securityServiceRef)) + ":")) {
                user = realm + ":" + user;
            }
            this.authCacheService.remove((Object)user);
        }
    }

    public void throwExceptionIfAlreadyAuthenticate(HttpServletRequest req, HttpServletResponse resp, WebAppSecurityConfig config, String username) throws ServletException {
        Subject callerSubject = this.subjectManager.getCallerSubject();
        if (this.subjectHelper.isUnauthenticated(callerSubject)) {
            return;
        }
        if (!config.getWebAlwaysLogin()) {
            AuthenticationResult authResult = new AuthenticationResult(AuthResult.FAILURE, username);
            authResult.setAuditCredType(req.getAuthType());
            authResult.setAuditCredValue(username);
            authResult.setAuditOutcome("failure");
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_API_AUTHN_01, (Object[])new Object[]{req, authResult, 401});
            throw new ServletException("Authentication had been already established");
        }
        this.logout(req, resp, config);
    }

    private void invalidateSession(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"invalidating existing HTTP Session", (Object[])new Object[0]);
            }
            session.invalidate();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Existing HTTP Session does not exist, nothing to invalidate", (Object[])new Object[0]);
        }
    }

    public void postProgrammaticAuthenticate(HttpServletRequest req, HttpServletResponse resp, AuthenticationResult authResult) {
        this.postProgrammaticAuthenticate(req, resp, authResult, false, true);
    }

    public void postProgrammaticAuthenticate(HttpServletRequest req, HttpServletResponse resp, AuthenticationResult authResult, boolean alwaysSetCallerSubject) {
        this.postProgrammaticAuthenticate(req, resp, authResult, alwaysSetCallerSubject, true);
    }

    public void postProgrammaticAuthenticate(final HttpServletRequest req, final HttpServletResponse resp, final AuthenticationResult authResult, final boolean alwaysSetCallerSubject, final boolean addSSOCookie) {
        if (System.getSecurityManager() == null) {
            this.setSubjectAndCookies(req, resp, authResult, alwaysSetCallerSubject, addSSOCookie);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){
                static final long serialVersionUID = 4678432324092241392L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() {
                    AuthenticateApi.this.setSubjectAndCookies(req, resp, authResult, alwaysSetCallerSubject, addSSOCookie);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
    }

    private void setSubjectAndCookies(HttpServletRequest req, HttpServletResponse resp, AuthenticationResult authResult, boolean alwaysSetCallerSubject, boolean addSSOCookie) {
        Subject subject = authResult.getSubject();
        if (alwaysSetCallerSubject || new SubjectHelper().isUnauthenticated(this.subjectManager.getCallerSubject())) {
            this.subjectManager.setCallerSubject(subject);
        }
        this.subjectManager.setInvocationSubject(subject);
        if (addSSOCookie) {
            this.ssoCookieHelper.addSSOCookiesToResponse(subject, req, resp);
        }
        try {
            Object loginToken = ThreadIdentityManager.setAppThreadIdentity((Subject)subject);
            WebSecurityContext webSecurityContext = (WebSecurityContext)SRTServletRequestUtils.getPrivateAttribute(req, "SECURITY_CONTEXT");
            if (webSecurityContext != null && webSecurityContext.getSyncToOSThreadToken() == null) {
                webSecurityContext.setSyncToOSThreadToken(loginToken);
            }
        }
        catch (ThreadIdentityException threadIdentityException) {
            FFDCFilter.processException((Throwable)threadIdentityException, (String)"com.ibm.ws.webcontainer.security.AuthenticateApi", (String)"519", (Object)this, (Object[])new Object[]{req, resp, authResult, alwaysSetCallerSubject, addSSOCookie});
        }
    }

    private void createSubjectAndPushItOnThreadAsNeeded(HttpServletRequest req, HttpServletResponse res) {
        this.logoutSubject = null;
        Subject subject = this.subjectManager.getCallerSubject();
        if (subject == null || this.subjectHelper.isUnauthenticated(subject)) {
            SSOAuthenticator ssoAuthenticator;
            AuthenticationResult authResult;
            if (this.authService == null && this.securityServiceRef != null) {
                this.authService = ((SecurityService)this.securityServiceRef.getService()).getAuthenticationService();
            }
            if ((authResult = (ssoAuthenticator = new SSOAuthenticator(this.authService, null, null, this.ssoCookieHelper)).handleSSO(req, res)) != null && authResult.getStatus() == AuthResult.SUCCESS) {
                this.subjectManager.setCallerSubject(authResult.getSubject());
                this.logoutSubject = authResult.getSubject();
            }
        }
    }

    String debugGetAllHttpHdrs(HttpServletRequest req) {
        if (req == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(512);
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames != null && headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            sb.append(headerName).append("=");
            sb.append("[").append(SRTServletRequestUtils.getHeader(req, headerName)).append("]\n");
        }
        return sb.toString();
    }

    private JaspiService getJaspiService() {
        JaspiService jaspiService = null;
        if (this.webAuthenticatorRefs != null) {
            WebAuthenticator jaspiAuthenticator = (WebAuthenticator)this.webAuthenticatorRefs.getService((Object)"com.ibm.ws.security.jaspi");
            jaspiService = (JaspiService)jaspiAuthenticator;
        }
        return jaspiService;
    }

    /*
     * WARNING - void declaration
     */
    public void logoutServlet30(HttpServletRequest res, HttpServletResponse resp, WebAppSecurityConfig webAppSecConfig) throws ServletException {
        block3: {
            JaspiService jaspiService = this.getJaspiService();
            if (jaspiService != null) {
                try {
                    jaspiService.logout(res, resp, webAppSecConfig);
                }
                catch (AuthenticationException authenticationException) {
                    void e;
                    FFDCFilter.processException((Throwable)authenticationException, (String)"com.ibm.ws.webcontainer.security.AuthenticateApi", (String)"604", (Object)this, (Object[])new Object[]{res, resp, webAppSecConfig});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"AuthenticationException invoking JASPI service logout", (Object[])new Object[]{e});
                }
            }
        }
        this.logout(res, resp, webAppSecConfig);
    }

    public WebReply createReplyForAuthnFailure(AuthenticationResult authResult, String realm) {
        WebReply reply = null;
        switch (authResult.getStatus()) {
            case FAILURE: {
                return DENY_AUTHN_FAILED;
            }
            case SEND_401: {
                return new ChallengeReply(realm);
            }
            case TAI_CHALLENGE: {
                return new TAIChallengeReply(authResult.getTAIChallengeCode());
            }
            case REDIRECT: {
                return new RedirectReply(authResult.getRedirectURL(), authResult.getCookies());
            }
            case UNKNOWN: 
            case CONTINUE: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Authentication failed with status [" + (Object)((Object)authResult.getStatus()) + "] and reason [" + authResult.getReason() + "]"), (Object[])new Object[0]);
                }
                return DENY_AUTHN_FAILED;
            }
        }
        return reply;
    }

    public Subject returnSubjectOnLogout() {
        return this.logoutSubject;
    }
}

