/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxws.metadata.EndpointInfo;
import com.ibm.ws.jaxws.metadata.builder.AbstractEndpointInfoConfigurator;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoBuilderContext;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoConfigurator;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={EndpointInfoConfigurator.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=false, property={"service.vendor=IBM"})
public class WebXMLEndpointInfoConfigurator
extends AbstractEndpointInfoConfigurator {
    private final TraceComponent tc = Tr.register(WebXMLEndpointInfoConfigurator.class);
    static final long serialVersionUID = 3820855893320214193L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WebXMLEndpointInfoConfigurator() {
        super(EndpointInfoConfigurator.Phase.PRE_PROCESS_DESCRIPTOR);
    }

    public void prepare(EndpointInfoBuilderContext context, EndpointInfo endpointInfo) throws UnableToAdaptException {
        WebAppConfig webAppConfig = (WebAppConfig)context.getContainer().adapt(WebAppConfig.class);
        if (null == webAppConfig) {
            return;
        }
        if (null != endpointInfo.getServletName()) {
            endpointInfo.setConfiguredInWebXml(true);
        }
    }

    public void config(EndpointInfoBuilderContext context, EndpointInfo endpointInfo) throws UnableToAdaptException {
        if (endpointInfo.isConfiguredInWebXml()) {
            WebAppConfig webAppConfig = (WebAppConfig)context.getContainer().adapt(WebAppConfig.class);
            if (null == webAppConfig) {
                return;
            }
            IServletConfig servletConfig = webAppConfig.getServletInfo(endpointInfo.getServletName());
            List<String> addresses = this.getAddressesFromServletConfig(servletConfig, endpointInfo.getServletName());
            if (!addresses.isEmpty()) {
                endpointInfo.clearAddresses();
                endpointInfo.addAddresses(addresses);
            }
        }
    }

    private List<String> getAddressesFromServletConfig(IServletConfig servletConfig, String servletName) {
        List servletMappings = servletConfig.getMappings();
        if (servletMappings == null || servletMappings.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> addresses = new ArrayList<String>(servletMappings.size());
        for (String mapping : servletConfig.getMappings()) {
            if (mapping.contains("*")) continue;
            addresses.add(mapping);
        }
        return addresses;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WebXMLEndpointInfoConfigurator.class);
    }
}

