/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.openapi.impl.model.media.SchemaImpl;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.SchemaProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.util.SchemaTypeUtil;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ResolverFully {
    private final boolean aggregateCombinators;
    private Map<String, Schema> schemas;
    private final Map<String, Schema> resolvedModels = new HashMap<String, Schema>();
    private Map<String, Example> examples;
    static final long serialVersionUID = -3421781930835545814L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ResolverFully() {
        this(true);
    }

    public ResolverFully(boolean aggregateCombinators) {
        this.aggregateCombinators = aggregateCombinators;
    }

    public void resolveFully(OpenAPI openAPI) {
        if (openAPI.getComponents() != null && openAPI.getComponents().getSchemas() != null) {
            this.schemas = openAPI.getComponents().getSchemas();
            if (this.schemas == null) {
                this.schemas = new HashMap<String, Schema>();
            }
        }
        if (openAPI.getComponents() != null && openAPI.getComponents().getExamples() != null) {
            this.examples = openAPI.getComponents().getExamples();
            if (this.examples == null) {
                this.examples = new HashMap<String, Example>();
            }
        }
        if (openAPI.getPaths() != null) {
            for (String pathname : openAPI.getPaths().keySet()) {
                PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)pathname);
                this.resolvePath(pathItem);
            }
        }
    }

    public void resolvePath(PathItem pathItem) {
        for (Operation op : pathItem.readOperations()) {
            Object parameter2;
            if (op.getParameters() != null) {
                for (Object parameter2 : op.getParameters()) {
                    Schema resolved;
                    if (parameter2.getSchema() != null && (resolved = this.resolveSchema(parameter2.getSchema())) != null) {
                        parameter2.setSchema(resolved);
                    }
                    if (parameter2.getContent() == null) continue;
                    Content content = parameter2.getContent();
                    for (String key : content.keySet()) {
                        Schema resolvedSchema;
                        if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolvedSchema = this.resolveSchema(((MediaType)content.get(key)).getSchema())) == null) continue;
                        ((MediaType)content.get(key)).setSchema(resolvedSchema);
                    }
                }
            }
            if (op.getCallbacks() != null) {
                Map callbacks = op.getCallbacks();
                parameter2 = callbacks.keySet().iterator();
                while (parameter2.hasNext()) {
                    String name = (String)parameter2.next();
                    Callback callback = (Callback)callbacks.get(name);
                    if (callback == null) continue;
                    for (String callbackName : callback.keySet()) {
                        PathItem path = (PathItem)callback.get((Object)callbackName);
                        if (path == null) continue;
                        this.resolvePath(path);
                    }
                }
            }
            if (op.getRequestBody() != null && op.getRequestBody().getContent() != null) {
                Content content = op.getRequestBody().getContent();
                parameter2 = content.keySet().iterator();
                while (parameter2.hasNext()) {
                    Schema resolved;
                    String key = (String)parameter2.next();
                    if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolved = this.resolveSchema(((MediaType)content.get(key)).getSchema())) == null) continue;
                    ((MediaType)content.get(key)).setSchema(resolved);
                }
            }
            if (op.getResponses() == null) continue;
            for (String code : op.getResponses().keySet()) {
                APIResponse response = (APIResponse)op.getResponses().get((Object)code);
                if (response.getContent() == null) continue;
                Content content = response.getContent();
                for (String mediaType : content.keySet()) {
                    Object resolved;
                    if (((MediaType)content.get(mediaType)).getSchema() != null) {
                        resolved = this.resolveSchema(((MediaType)content.get(mediaType)).getSchema());
                        ((MediaType)response.getContent().get((Object)mediaType)).setSchema(resolved);
                    }
                    if (((MediaType)content.get(mediaType)).getExamples() == null) continue;
                    resolved = this.resolveExample(((MediaType)content.get(mediaType)).getExamples());
                    ((MediaType)response.getContent().get((Object)mediaType)).setExamples((Map)resolved);
                }
            }
        }
    }

    public Schema resolveSchema(Schema schema) {
        if (schema.getRef() != null) {
            String ref = schema.getRef();
            Schema resolved = this.schemas.get(ref = ref.substring(ref.lastIndexOf("/") + 1));
            if (resolved == null) {
                return schema;
            }
            if (this.resolvedModels.containsKey(ref)) {
                return this.resolvedModels.get(ref);
            }
            this.resolvedModels.put(ref, schema);
            Schema model = this.resolveSchema(resolved);
            this.resolvedModels.put(ref, model);
            return model;
        }
        if (schema.getType() == Schema.SchemaType.ARRAY) {
            if (schema.getItems().getRef() != null) {
                schema.setItems(this.resolveSchema(schema.getItems()));
            } else {
                schema.setItems(schema.getItems());
            }
            return schema;
        }
        if (schema.getType() == Schema.SchemaType.OBJECT) {
            if (schema.getProperties() != null) {
                LinkedHashMap<String, Schema> updated = new LinkedHashMap<String, Schema>();
                for (String propertyName : schema.getProperties().keySet()) {
                    Schema innerProperty = (Schema)schema.getProperties().get(propertyName);
                    if (schema == innerProperty) continue;
                    Schema resolved = this.resolveSchema(innerProperty);
                    updated.put(propertyName, resolved);
                }
                schema.setProperties(updated);
            }
            return schema;
        }
        if (SchemaProcessor.isComposedSchema(schema)) {
            Schema composedSchema = schema;
            if (this.aggregateCombinators) {
                Schema model = SchemaTypeUtil.createSchema(schema.getType().toString(), schema.getFormat());
                HashSet<String> requiredProperties = new HashSet<String>();
                if (schema.getAllOf() != null) {
                    Iterator innerProperty = schema.getAllOf().iterator();
                    if (innerProperty.hasNext()) {
                        Schema innerModel = (Schema)innerProperty.next();
                        Schema resolved = this.resolveSchema(innerModel);
                        Map properties = resolved.getProperties();
                        if (resolved.getProperties() != null) {
                            for (String key : properties.keySet()) {
                                Schema prop = (Schema)resolved.getProperties().get(key);
                                model.addProperty(key, this.resolveSchema(prop));
                            }
                            if (resolved.getRequired() != null) {
                                for (int i = 0; i < resolved.getRequired().size(); ++i) {
                                    if (resolved.getRequired().get(i) == null) continue;
                                    requiredProperties.add(((String)resolved.getRequired().get(i)).toString());
                                }
                            }
                        }
                        if (requiredProperties.size() > 0) {
                            model.setRequired(new ArrayList(requiredProperties));
                        }
                        if (schema.getExtensions() != null) {
                            Map extensions = schema.getExtensions();
                            for (String key : extensions.keySet()) {
                                ((SchemaImpl)model).addExtension_compat(key, schema.getExtensions().get(key));
                            }
                        }
                        return model;
                    }
                } else if (composedSchema.getOneOf() != null) {
                    ArrayList<Schema> list = new ArrayList<Schema>();
                    for (Schema innerModel : composedSchema.getOneOf()) {
                        Schema resolved = this.resolveSchema(innerModel);
                        list.add(resolved);
                    }
                    composedSchema.setOneOf(list);
                } else if (composedSchema.getAnyOf() != null) {
                    ArrayList<Schema> list = new ArrayList<Schema>();
                    for (Schema innerModel : composedSchema.getAnyOf()) {
                        Schema resolved = this.resolveSchema(innerModel);
                        list.add(resolved);
                    }
                    composedSchema.setAnyOf(list);
                }
                return composedSchema;
            }
            if (composedSchema.getAllOf() != null) {
                composedSchema.allOf(composedSchema.getAllOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
            } else if (composedSchema.getOneOf() != null) {
                composedSchema.oneOf(composedSchema.getOneOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
            } else if (composedSchema.getAnyOf() != null) {
                composedSchema.anyOf(composedSchema.getAnyOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
            }
            return composedSchema;
        }
        if (schema.getProperties() != null) {
            Schema property;
            Schema model = schema;
            LinkedHashMap<String, Schema> updated = new LinkedHashMap<String, Schema>();
            Map properties = model.getProperties();
            for (String propertyName : properties.keySet()) {
                property = (Schema)model.getProperties().get(propertyName);
                Schema resolved = this.resolveSchema(property);
                updated.put(propertyName, resolved);
            }
            for (String key : updated.keySet()) {
                property = (Schema)updated.get(key);
                if (property.getType() != Schema.SchemaType.OBJECT) continue;
                if (property.getProperties() != model.getProperties()) {
                    if (property.getType() == null) {
                        property.setType(Schema.SchemaType.OBJECT);
                    }
                    model.addProperty(key, property);
                    continue;
                }
                Schema newSchema = new SchemaImpl().type(Schema.SchemaType.OBJECT);
                model.addProperty(key, newSchema);
            }
            return model;
        }
        return schema;
    }

    public Map<String, Example> resolveExample(Map<String, Example> examples) {
        Map<String, Example> resolveExamples = examples;
        if (examples != null) {
            for (String name : examples.keySet()) {
                if (examples.get(name).getRef() == null) continue;
                String ref = examples.get(name).getRef();
                ref = ref.substring(ref.lastIndexOf("/") + 1);
                Example sample = this.examples.get(ref);
                resolveExamples.replace(name, sample);
            }
        }
        return resolveExamples;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ResolverFully.class);
    }
}

